/*   Test of TeX parser and conversion by reading a TeX file and writing
     the parsed result.

    Author: John Collins, collins@phys.psu.edu.
    21 Jan 96

    (C) John Collins & Penn State University.
*/

#include "texparse.h"
#include <string.h>

#ifdef __MSDOS__
   // Make a large stack:
   extern unsigned _stklen = 10000;
#endif


/*==================================*/


void HelpMsg (sos & f = lite_cout){
   f << "Usage:\n\n"
        "    textotex texfile [outfile]\n\n"
        "parses texfile, and writes it to outfile (or to stdout).\n\n"
        "    textox -\n\n"
        "takes its input from stdin and sends its output to stdout, i.e., \n"
        "it works as a filter.\n"
     << flush;
}




void ParseToTeX (FILE *source=stdin, sos &dest=lite_cout){
/* Parse TeX file and output it again.
   Assume source is opened for reading.
   Assume dest is opened for writing.
   Leave source and dest at EOF, but don't close them.  (The calling routine
   may want to do further processing.)
*/
   ListHead Logic;

   lite_cerr  << "Reading... ";
   Buffer LineList(source);
   lite_cerr  << (int)LineList.NumLines() << " lines.\n";

   lite_cerr  << "Tokenizing...\n";
   int RetCode = Logic.Tokenize (LineList);
   if (RetCode) {
      lite_cerr << "Error code " << RetCode << " from tokenizing.\n";
      return;
   }

   lite_cerr  << "Parsing...\n";
   TeXState state;
   RetCode = ParseAll (&Logic, state);
   if (RetCode) {
      lite_cerr << "Error code " << RetCode << " from parsing.\n";
      return;
   }

   lite_cerr  << "Writing...\n";
   Logic.WriteTeXAll (dest);
}


//=======================================================================
//=======================================================================

int main(int argc, char** argv) {
   char *sourcename = NULL, *destname = NULL;

   if (argc <= 1){
      HelpMsg();
      return 1;
   } else if (strcmp(argv[1], "-") == 0){
      // Work as filter
      ParseToTeX();
   } else if (argc >= 2) {
      sourcename = argv[1];
      FILE *source = fopen(sourcename, "r");
      if (!source) {
         lite_cerr << "File \"" << sourcename << "\" appears not to exist.\n";
         return 2;
      }
      if (argc >=3) {
         destname = argv[2];
         fsos dest (destname);
         if (!dest.IsOpen()) {
            lite_cerr << "File \"" << destname << "\" cannot be written.\n";
            fclose (source);
            return 3;
         }
         ParseToTeX(source, dest);
         fclose(source);
         dest.close();
      } else {
         // output is stdout
         ParseToTeX(source);
         fclose(source);
      }
   }

   return 0;
}





