/* This software is Copyright 1995 by Karl-Johan Johnsson
 *
 * Permission is hereby granted to copy, reproduce, redistribute or otherwise
 * use this software as long as: there is no monetary profit gained
 * specifically from the use or reproduction of this software, it is not
 * sold, rented, traded or otherwise marketed, and this copyright notice is
 * included prominently in any copy made. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. ANY USE OF THIS
 * SOFTWARE IS AT THE USER'S OWN RISK.
 */
#include "global.h"
#include "kaction.h"
#include "kedit.h"
#include "kill.h"
#include "pixmaps.h"
#include "util.h"
#include "widgets.h"
#include "xutil.h"

static const char *scope_str[] =
{"article",	"subject",	"thread",	"subthread"};
static const char *field_str[] =
{"Message-Id",	"Subject",	"From",		"Xref"};

static void add_kill(char **params, int no_params, int append)
{
    char	buffer[80];
    KILL_NODE	*node;
    KillScope	scope;
    KillField	field;
    char	*regexp;

    if (global.busy ||
	(global.mode != NewsModeGroup && global.mode != NewsModeThread)) {
	XBell(XtDisplay(main_widgets.shell), 0);
	return;
    }

    if (!global.curr_art) {
	set_message("No selected article!", True);
	return;
    } else if (!global.curr_art->from) {
	set_message("That's a fake article!", True);
	return;
    }

    if (no_params != 2 && no_params != 3) {
	if (append)
	    set_message("kill-append() called with "
			"wrong number of arguments!", True);
	else
	    set_message("kill-prepend() called with "
			"wrong number of arguments!", True);
	return;
    }

    if (case_lstrcmp(params[0], "from") == 0) {
	field = KillFieldFrom;
	regexp = regexp_escape_string(global.curr_art->from, True);
    } else if (case_lstrcmp(params[0], "subject") == 0) {
	field = KillFieldSubject;
	regexp = regexp_escape_string(global.curr_art->subject->subject, True);
    } else if (case_lstrcmp(params[0], "message-id") == 0) {
	field = KillFieldMsgid;
	regexp = XtMalloc(global.curr_art->hash_len + 4);
	sprintf(regexp, "<%s>", global.curr_art->msgid);
    } else {
	sprintf(buffer, "kill-%s(): unknown field: ",
		append ? "append" : "prepend");
	strncat(buffer, params[0], 40);
	set_message(buffer, True);
	return;
    }


    if (case_lstrcmp(params[1], "thread") == 0)
	scope = KillScopeThread;
    else if (case_lstrcmp(params[1], "subthread") == 0)
	scope = KillScopeSubthread;
    else if (case_lstrcmp(params[1], "subject") == 0)
	scope = KillScopeSubject;
    else {
	sprintf(buffer, "kill-%s(): unknown scope: ",
		append ? "append" : "prepend");
	strncat(buffer, params[1], 40);
	set_message(buffer, True);
	XtFree(regexp);
	return;
    }

    node = (KILL_NODE *)XtMalloc(sizeof *node);
    node->color = NULL;
    node->pixel = 0;
    node->hot = 0;
    node->field = field;
    node->scope = scope;
    node->action = KillActionKill;
    node->valid = True;
    node->applicable = False;
    node->unused = False;
    node->alloced_pixel = False;
    node->msgid_valid = True;
    node->expr_re = (regex_t *)XtMalloc(sizeof(regex_t));
    node->group_re = (regex_t *)XtMalloc(sizeof(regex_t));
    node->expr_str = regexp;
    node->group_str = regexp_escape_string(global.curr_group->name, True);
    (void)regcomp(node->expr_re, node->expr_str, REGEXP_COMPILE_FLAGS);
    (void)regcomp(node->group_re, node->group_str, REGEXP_COMPILE_FLAGS);

    if (no_params == 3) {
	Display		*disp = XtDisplay(main_widgets.shell);
	Colormap	cmap;
	Arg		arg;
	XColor		col;
	int		ok;

	node->action = KillActionHot;
	node->color = XtNewString(params[2]);

	XtSetArg(arg, XtNcolormap, &cmap);
	XtGetValues(main_widgets.shell, &arg, 1);

	ok = XParseColor(disp, cmap, node->color, &col);
	if (ok && XAllocColor(disp, cmap, &col)) {
	    node->pixel = col.pixel;
	    node->alloced_pixel = True;
	} else {
	    if (ok)
		strcpy(buffer, "Warning: Cannot allocate colormap entry for ");
	    else {
		XBell(XtDisplay(main_widgets.shell), 0);
		strcpy(buffer, "Warning: Bogus color ");
	    }
	    strncat(buffer, node->color, 32);
	    buffer[79] = '\0';

	    popup_notice("colornotice", buffer, "OK", NULL, NULL, 2000,
			 NULL, NULL, XtGrabNone);

	    node->pixel = global.default_hot_pixel;
	    node->alloced_pixel = False;
	}

	create_hot_pixmap(node);
    }

    kill_add_node(node, append);

    sprintf(buffer, "%s %s-scope %s %s entry to kill file.",
	    append ? "Appended" : "Prepended",
	    scope_str[scope], field_str[field],
	    node->action == KillActionKill ? "kill" : "hot");
    set_message(buffer, False);
}

void action_kill_append(Widget w, XEvent *event,
			String *params, Cardinal *no_params)
{
    add_kill(params, *no_params, True);
}

void action_kill_prepend(Widget w, XEvent *event,
			 String *params, Cardinal *no_params)
{
    add_kill(params, *no_params, False);
}

