/* This software is Copyright 1995 by Karl-Johan Johnsson
 *
 * Permission is hereby granted to copy, reproduce, redistribute or otherwise
 * use this software as long as: there is no monetary profit gained
 * specifically from the use or reproduction of this software, it is not
 * sold, rented, traded or otherwise marketed, and this copyright notice is
 * included prominently in any copy made. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. ANY USE OF THIS
 * SOFTWARE IS AT THE USER'S OWN RISK.
 */
#ifndef TextFieldP_h
#define TextFieldP_h

#include "TextField.h"
#include "ShadowP.h"

typedef struct {
    XtPointer	empty;
} TextFieldClassPart;

typedef struct TextFieldClassRec {
    CoreClassPart	core_class;
    ShadowClassPart	shadow_class;
    TextFieldClassPart	textfield_class;
} TextFieldClassRec;

extern TextFieldClassRec textFieldClassRec;

typedef struct {
    String		buffer;
    Pixel		foreground_pixel;
    Pixel		highlight_fg;
    Pixel		highlight_bg;
    Pixel		focus_pixel;
    XFontStruct		*font;
    XtCallbackList      callback;
    XtCallbackList	tab_callback;
    XtCallbackList	focus_callback;
    Widget		focus_root;
    Dimension		internal_height;
    Dimension		internal_width;
    Cardinal		preferred_chars;
    Boolean		border_in;
    Boolean		display_caret;
    Boolean		focus_hack;
    Boolean		print_focus;	/* for debugging purposes */
    /* private data */
    GC			default_gc;
    GC			highlight_gc;
    Atom		curr_sel;
    Time		sel_time;
    Cardinal		sel_start;
    Cardinal		sel_stop;
    Cardinal		alloc;
    Cardinal		len;
    Cardinal		first;
    Cardinal		shown;
    Cardinal		pos;
    Cardinal		multiply;
    Position		caret_pos;
    Boolean		waiting_for_sel;
    Boolean		sel_set;
    Boolean		active;
} TextFieldPart;

typedef struct TextFieldRec {
    CorePart		core;
    ShadowPart		shadow;
    TextFieldPart	textfield;
} TextFieldRec;

#endif /* TextFieldP_h */

