#include <sys/types.h>
#include <sys/socket.h>
#include <linux/if.h>
#include <linux/if_ether.h>
#include <netinet/in.h>
#include <sys/ioctl.h>

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

#include "global.h"

int main(int argc, char **argv)
{
	unsigned char buf[512];
	int size;
	int s;
	char *dev=NULL;
	struct sockaddr sa;
	int asize=sizeof(sa);
	struct ifreq ifr;
	int proto=ETH_P_AX25;

	if(argv[1] && strcmp(argv[1], "-p")==0)
	{
		argv++;
		argc--;
		proto=ETH_P_ALL;
	}
	if(argv[1] && strcmp(argv[1], "-d")==0)
	{
		argv++;
		argc--;
		if(argv[1]==NULL)
		{
			fprintf(stderr,"option -d needs a device name.\n");
			exit(1);
		}
		dev=argv[1];
		argv++;
		argc--;
	}	
	
	if(argv[1])
	{
		fprintf(stderr,"Unexpected: '%s'.\n",argv[1]);
		exit(1);
	}
	
	if ((s = socket(AF_INET, SOCK_PACKET, htons(proto))) == -1)
	{
		perror("socket");
		return(1);
	}
	
	for (;;)
	{
		if ((size = recvfrom(s, buf, sizeof(buf), 0, &sa, &asize)) == -1)
		{
			perror("recv");
			return(1);
		}
		
		if(dev && strcmp(dev,sa.sa_data))
			continue;
			
		if(proto==ETH_P_ALL)
		{
			strcpy(ifr.ifr_name, sa.sa_data);
			if(ioctl(s, SIOCGIFHWADDR, &ifr))
				perror("GIFADDR");
			if(ifr.ifr_hwaddr.sa_family!=AF_AX25)
				continue;
		}

		printf("Port %s: ",sa.sa_data);
		ki_dump(buf, size);

		putc('\n', stdout);

		fflush(stdout);
	}
}

void data_dump(unsigned char *data, int length)
{
	int  i, j;
	char c;

	for (i = 0; length > 0; i += 64)
	{
		fprintf(stdout, "%04X  ", i);
	
		for (j = 0; j < 64 && length > 0; j++)
		{
			c = *data++;
			length--;
			
			if (c >= 0x20 && c < 0x7F)
				putc(c, stdout);
			else
				putc('.', stdout);
		}
		
		putc('\n', stdout);
	}
}

int get16(unsigned char *cp)
{
	int x;
	
	x = *cp++;
	x <<= 8;
	x |= *cp++;
	
	return(x);
}

int get32(unsigned char *cp)
{
	int x;
	
	x = *cp++;
	x <<= 8;
	x |= *cp++;
	x <<= 8;
	x |= *cp++;
	x <<= 8;
	x |= *cp;
	
	return(x);
}
