/*
 *                            COPYRIGHT
 *
 *  PCB, interactive printed circuit board design
 *  Copyright (C) 1994 Thomas Nau
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Contact addresses for paper mail and Email:
 *  Thomas Nau, Schlehenweg 15, 88471 Baustetten, Germany
 *  Thomas.Nau@medizin.uni-ulm.de
 *
 *  RCS: $Header: draw.h,v 1.2 94/06/19 11:22:12 nau Exp $
 */

/* prototypes for drawing routines
 */

#ifndef	__DRAW_INCLUDED__
#define	__DRAW_INCLUDED__

#include "global.h"

void	SwitchDrawingWindow(int, Window);
void	RedrawOutput(void);
void	RedrawCurrentLayer(void);
void	DrawLineOnLayer(LineTypePtr, LayerTypePtr);
void	DrawLine(LineTypePtr);
void	EraseLine(LineTypePtr);
void	EraseElement(ElementTypePtr);
void	DrawNewElement(ElementTypePtr);
void	DrawElementName(ElementTypePtr);
void	EraseElementName(ElementTypePtr);
void	DrawNewPin(PinTypePtr);
void	DrawPinOrVia(PinTypePtr);
void	ErasePinOrVia(PinTypePtr);
void	DrawNewVia(PinTypePtr);
void	DrawRectOnLayer(RectTypePtr, LayerTypePtr);
void	DrawRect(RectTypePtr);
void	EraseRect(RectTypePtr);
void	EraseText(TextTypePtr);
void	DrawTextOnLayer(TextTypePtr, LayerTypePtr);
void	DrawArc(ArcTypePtr);

#endif
