/* e_elemnt.h		-*- C++ -*-
 *$Header: /al/acs/src/RCS/e_elemnt.h,v 9.25 95/10/29 01:46:09 al Exp $
 * branch structure type definitions
 * device types (enumeration type?)
 */
#ifndef E_ELEMNT_H
#define E_ELEMNT_H
#include "e_compon.h"
#include "e_node.h"	// for setneedslu
/*--------------------------------------------------------------------------*/
extern NODE *nstat;
/*--------------------------------------------------------------------------*/
class ELEMENT : public COMPONENT {
  friend class DEV_MUTUAL_L;
  friend class DEV_CCCS;
  friend class DEV_CCVS;
protected:
	ELEMENT(){loaditer=0;loss=0.;}
	ELEMENT(const ELEMENT& p):COMPONENT(p){loaditer=0;loss=p.loss;}
	void	setneedslu(int b){nstat[n[b].m].needslu = TRUE;}

public:					// e_elem2.cc
	void	parse(CS&);
	void	print(int,int)const;
protected:
	void	parseexpr(CS&);
	void	printexpr(int)const;
	void	trsetup();
	int	conv_check()const;

protected:				// e_elem1.cc
	void	trload_loss();
	void	trunload_loss();
	void	acload_loss();
	void	trload_passive();
	void	trunload_passive();
	void	acload_passive();
	void	trload_active();
	void	trunload_active();
	void	acload_active();
	void	trload_source();
	void	trunload_source();
	void	acload_source();

protected:				// e_elem3.cc
	double   tr_amps()const;
	double   tr_outvolts()const;
	double   tr_involts()const;
	COMPLEX  ac_outvolts()const;
	COMPLEX  ac_involts()const;
	double   probe_tr_num(const char*)const;
	xprobe_t probe_ac_ext(const char*)const;
private:
  int      loaditer;	/* load iteration number		*/
  cpoly1_t m1;		/* matrix parameters, 1 fill ago	*/
protected:
  cpoly1_t m0;		/* matrix parameters, new		*/
  double   loss;	/* fixed shunt conductance (should be COMMON)	*/
  COMPLEX  acg;		/* ac admittance matrix values   	*/
  COMPLEX  ev;		/* ac effective value (usually real)	*/
  enum	{DEFAULT_NUMNODES = 2};
};
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
#endif
