
#include "sltermin.c"

int main (int argc, char **argv)
{
   Terminfo_Type *t;
   Tgetstr_Map_Type *map = Tgetstr_Map;
   unsigned char *str;
   char *term;
   
   term = getenv ("TERM");
   if (argc > 1) term = argv[1];
   if (term == NULL) return -1;
   t = (Terminfo_Type *) SLtt_tigetent (term);
   if (t == NULL) return -1;
   
   puts (t->terminal_names);
   while (map->name != NULL)
     {
	str = (unsigned char *) SLtt_tigetstr (map->name, (char **) &t);
	if (str == NULL) str = (unsigned char *) "NULL";
	
	fprintf (stdout, "\t%s=", map->name);
	while (*str)
	  {
	     if ((int) (*str & 0x7F) < ' ') 
	       {
		  putc ('^', stdout);
		  *str += '@';
	       }
	     putc (*str, stdout);
	     str++;
	  }
	putc ('\n', stdout);
	map++;
     }
   
   map = Tgetflag_Map;
   while (map->name != NULL)
     {
	if (SLtt_tigetflag (map->name, (char **) &t) > 0)
	  {
	     fprintf (stdout, "\t%s\n", map->name);
	  }
	map++;
     }
   map = Tgetnum_Map;
   while (map->name != NULL)
     {
	int val;
	if ((val = SLtt_tigetnum (map->name, (char **) &t)) >= 0)
	  {
	     fprintf (stdout, "\t%s#%d\n", map->name, val);
	  }
	map++;
     }

   return 0;
}


   
