find_root () {
	local root_device="`block_device / 2>/dev/null`"
	if [ $? -ne 0 ]; then return 1; fi
	local target_device="`block_device /target 2>/dev/null`"
	if [ $? -ne 0 ]; then return 1; fi
	if [ $root_device = $target_device ]; then
		return 1
	fi
	echo $target_device
	return 0
}

require_root () {
	local status=0
	if [ -z "$Root" ]; then
		Root=`find_root`
		if [ $? -ne 0 -o -z "$Root" ]; then
			msgBox \
"The requested operation can't be performed until the root
filesystem is mounted.

Before you begin installation, you must first partition
your disk, and then initialize and mount your root filesystem,
and initialize a swap partition.
Please use the main menu to complete any of those steps
that you have not done, and then use the main menu to return
to this step." \
			"Problem"
			return 1
		fi
	fi
	return 0
}

require_swap () {
	local status=0
	if [ -z "$Swap" ]; then
		msgBox \
"Your swap partition has not been set up.
Before you begin installation, you must first partition
your disk, and then initialize and mount your root filesystem,
and initialize a swap partition.
Please use the main menu to complete any of those steps
that you have not done, and then use the main menu to return
to this step." \
		"Problem"
		return 1
	fi
	return 0
}
