/* 
 * config.h
 *
 * This file contains the default values for vgetty, zplay and the 
 * pvf tools. These values can be changed by the configuration file 
 * and by command line arguments.
 *
 * NOTE: Configuration file support is currently missing.
 *
 */

#ifdef MAIN
char config_h[] = "$Id: config.h,v 1.3 1995/04/11 19:18:32 marc Exp $";
#endif

/*
 * Common defaults
 * ---------------
 */

/* 
 * Minimum length of detected DTMF tones, in milliseconds. This is 
 * currently only supported by ZyXel modems with a ROM release of 6.12 
 * or above. The default is 36 milliseconds.
 */
 
#define DTMF_LEN 36

/* 
 * DTMF tone detection threshold (0.0 to 1.0). Increase this if the 
 * modem erroneously detects DTMF tones, decrease it if it fails to 
 * detect real ones. This is currently only supported by ZyXel modems
 * with a ROM release of 6.12 or above. The default is 0.4.
 */
 
#define DTMF_THRESHOLD 0.4

/* 
 * This is the default compression mode for vgetty for incoming voice
 * messages and for the recording option of zplay.
 *
 * For ZyXel modems: 1 = CELP, 2 = ADPCM-2, 3 = ADPCM-3, 4 = ADPCM-4.
 * Please note that there are convertors to other sound formats only for
 * the ADPCM modes.
 *
 * For Rockwell based modems: 2, 3, or 4 (bits/sample). Please note that
 * Rockwell didn't publish the internal information of their sound format, 
 * so there are no convertors to other sound formats.
 *
 * The default is 3.
 */
 
#define REC_COMPRESSION 3

/* 
 * Silence detection length in 0.1 seconds. If the modem detects silence
 * for this time, it sends a silence detect to the host. Default is 
 * 7 seconds (70 * 0.1 seconds).
 */
 
#define REC_SILENCE_LEN 70

/* 
 * Silence detection threshold (0.0 to 1.0). Increase this value if you 
 * have a noisy phone line and the silence detection doesn't work reliably.
 * The default is 0.4.
 */

#define REC_SILENCE_THRESHOLD 0.4

/* 
 * If REC_REMOVE_SILENCE is enabled, the trailing silence of an incoming 
 * voice message as detected by the modem will be deleted. This might 
 * cause you to miss parts of a message if the silence threshold is 
 * high and the caller is talking very quietly. To be on the safe side,
 * don't define this. This feature is turned off by default.
 */
 
#define REC_REMOVE_SILENCE FALSE

/*
 * Maximum recording length in seconds. Hang up if somebody talks 
 * longer than this. Default is 5 minutes (300 seconds).
 */

#define REC_MAX_LEN 300

/*
 * Default values for vgetty
 * -------------------------
 */

/* 
 * Volume of the internal speaker when answering the phone (0.0 to 1.0).
 * 0.0 is off, 1.0 is maximum. The default is 1.0.
 */
 
#define SPEAKER_ANSWER_VOLUME 1.0

/* 
 * If vgetty knows that there are new messages (the flag file exists),
 * it will turn on the AA lamp on an external modem and enable the toll 
 * saver - it will answer the phone TOLL_SAVER_RINGS earlier than the 
 * default. This feature is turned off by default.
 */

#define TOLL_SAVER_RINGS 0

/* 
 * Should the recorded voice message file be kept even if data, fax or 
 * DTMF codes were detected? If this is set, vgetty never deletes
 * a recording, if it is not set it will delete the recording, if an
 * incoming data or fax call is detected or if DTMF codes were send. Also
 * this should work in nearly every situation, it makes You loose the
 * recording, if the caller "plays" with DTMF codes to make the message
 * even more beautiful. This feature is enabled by default.
 */

#define REC_ALWAYS_KEEP_MESSAGE TRUE

/* 
 * Support for distinctive RINGs, if you don't want this just undefine
 * DIST_RING below. This is only tested for ZyXELs, let me know if
 * you make it work on other modems.
 *
 * A simple "RING" or RING_VOICE below cause vgetty to behave as usual,
 * i.e. answer initially in voice mode and switch if appropiate.
 * RING_DATA or RING_FAX cause it to answer in fax/data mode immediately.
 * If the ring isn't one of the types above, the call is ignored and
 * vgetty won't pick up the phone. This feature is disabled by default.
 */

#define DIST_RING FALSE

#define DIST_RING_INIT	"ATS40.3=1 S40.4=1 S40.5=1 S40.6=1"
#define DIST_RING_VOICE	A_RING1
#define DIST_RING_DATA	A_RING2
#define DIST_RING_FAX	A_RING3

/* 
 * Filename of the logfile for vgetty. A "%s" will be replaced by the
 * device name.
 */

#define VGETTY_LOG_PATH "/var/log/vgetty.%s"

/* 
 * The R_FFT_PROGRAM is responsible for distinguishing voice and
 * data calls if the line is not silent. It checks the power spectrum
 * of the sound data and, if it only contains few frequencies, sends
 * a SIGUSR2 to vgetty to make it stop recording. This is also quite
 * effective against dial tones. (Code by ulrich@gaston.westfalen.de)
 *
 * It needs to convert the voice data, i.e. it currently
 * works only for ZyXEL adpcm-2 and adpcm-3. It is automatically
 * disabled if it can't deal with the voice data.
 *
 * There are a few configurable parameters, check the top of
 * pvffft.c for details. The defaults seem to work quite well.
 *
 * Undefine R_FFT_PROGRAM if you don't want this, i.e. if you
 * have a slow machine that can't handle the additional CPU load. 
 */

#define FFT_PROGRAM ""
/* #define FFT_PROGRAM "vg_fft" */

/* 
 * Primary voice directory for vgetty.
 */

#define VOICE_DIR "/var/spool/voice"

/* 
 * Location of the flag file for new incoming messages relative to the
 * primary voice directory.
 */
 
#define MESSAGE_FLAG_FILE ".flag"

/* 
 * Location of the optional answer mode file, %s is replaced with the
 * device name. If the file doesn't exist, use 'voice/fax/data' as the
 * default setting. 
 */
 
#define VGETTY_ANSWER_FILE "/etc/answer.%s"

/* 
 * Location where vgetty stores the incoming voice messages relative to
 * the primary voice directory.
 */
 
#define VGETTY_RECEIVE_DIR	"incoming"

/* 
 * Directory containing the messages for vgetty (greeting, handling the 
 * answering machine) relative to the primary voice directory.
 */
 
#define VGETTY_MESSAGE_DIR	"messages"

/* 
 * Name of the file in the R_VOICE_MESSAGE_DIR that contains the names of 
 * the greeting message files (one per line, no white space).
 */

#define VGETTY_MESSAGE_LIST	"Index"

/* 
 * Filename of a backup greeting message in R_VOICE_MESSAGE_DIR (used if
 * the random selection fails to find a message).
 */
 
#define VGETTY_BACKUP_MESSAGE "standard"

/* 
 * The programs defined below get called by vgetty. The modem will
 * still be in voice mode and is connected to STDIN. vgetty will
 * set the argument(s) ($1 for shell scripts, argv[1] for C programs)
 * as described.
 *
 * Define an empty program name, if You want to disabled one of those
 * programs. For an example see CALL_PROGRAM below.
 */

/* 
 * Program called when a voice message has been received.
 * Argument: filename of the recorded message 
 */
 
#define MESSAGE_PROGRAM "vg_message"

/* 
 * There are two separate uses for the DATA/VOICE button:
 * - if a RING was detected recently, answer the phone in fax/data mode
 * - otherwise, call an external program to play back messages
 *
 * If you don't define R_BUTTON_PROGRAM, vgetty will always pick up
 * the phone if DATA/VOICE is pressed.
 *
 * Argument: "button" (a constant string) 
 */

#define BUTTON_PROGRAM	"vg_button"

/* 
 * Program called when a DTMF command ( '*DIGITS#' ) is received.
 * Argument: the DIGITS received (without '*' and '#') 
 */
 
#define DTMF_PROGRAM "vg_dtmf"

/* 
 * Program called when the phone is answered, this is *INSTEAD*
 * of the normal behaviour. Don't define this unless you want
 * to i.e. set up a voice mailbox where the normal answering
 * machine behaviour would be inappropiate. The C code is probably
 * more stable and uses less resources. 
 */
 
#define CALL_PROGRAM ""
/* #define CALL_PROGRAM "vg_call" */

/* 
 * Command sequence used by vgetty to answer the phone.
 */
 
#define VGETTY_ATA "ATA"

/*
 * Default values for zplay
 * ------------------------
 */
 
/*
 * Maximum number of rings to wait for an answer when dialing out from 
 * zplay. The default is 5.
 */
 
#define ZPLAY_MAX_RINGS	5

/* 
 * Volume of the internal speaker when it is used to play a message
 * with zplay (0.0 to 1.0). The default is 1.0.
 */

#define ZPLAY_SPEAKER_VOLUME 1.0

/* 
 * Bps rate for zplay, must be high enough for the compression mode used.
 * Note that this is an integer, not one of the Bxxxx defines. This must
 * be set to 38400 for Rockell modems. The default value is 38400.
 */
 
#define ZPLAY_SEND_BAUD 38400

/* 
 * Filename of the logfile for zplay.
 */

#define ZPLAY_LOG_PATH "/var/log/zplay.log"

/*
 * Default values for the pvf tools
 * --------------------------------
 */
 
/* 
 * ZyXel ROM release should be set to 601, 610, 611, 612... to match
 * your ROM release. This affects ADPCM conversion.
 */
 
#define ZYXEL_ROM 613
