/*	Copyright (c) 1990, 1991 UNIX System Laboratories, Inc.	*/
/*	Copyright (c) 1984, 1986, 1987, 1988, 1989, 1990 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF     	*/
/*	UNIX System Laboratories, Inc.                     	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ifndef _FS_FIFOFS_FIFONODE_H	/* wrapper symbol for kernel use */
#define _FS_FIFOFS_FIFONODE_H	/* subject to change without notice */

#ident	"@(#)uts-3b2:fs/fifofs/fifonode.h	1.7"

#include <sys/types.h>
#include <sys/sema.h>

/*
 * fifo lock structure. In the case of normal fifo's there is one
 * lock node associated with each fifo node. In the pipe case there
 * is only one lock node which is shared between both fifo nodes.
 */
typedef struct {
	sema_t		fn_lock;
	unsigned int	fn_refcnt;
} fifo_lock_t;

/*
 * fifo lock/unlock operations
 */
#define fifo_lock(fnp) \
	if (!(fnp->fn_flag & FIFODONTLOCK)) { \
		psema(&(fnp->fn_lockp->fn_lock), PZERO); \
	}

#define fifo_unlock(fnp) \
	if (!(fnp->fn_flag & FIFODONTLOCK)) { \
		vsema(&(fnp->fn_lockp->fn_lock)); \
	}
/*
 * Each FIFOFS object is identified by a struct fifonode/vnode pair.
 */
struct fifonode {
	struct vnode	*fn_vnode;	/* represents the fifo/pipe */
	struct vnode	*fn_mate;	/* the other end of a pipe */
	struct vnode	*fn_realvp;	/* node being shadowed by fifo */
	ushort		fn_ino;		/* node id for pipes */
	short		fn_open;	/* open count of node */
	fifo_lock_t	*fn_lockp;	/* lock node ptr; common for pipes */
	sema_t		fn_wcnt;	/* number of writers */
	sema_t		fn_rcnt;	/* number of readers */
	sema_t		fn_empty;	/* number of procs waiting on empty */
	sema_t		fn_full;	/* number of procs waiting on full */
	sema_t		fn_ioctl;	/* number of procs waiting on ioctl */
	struct vnode	*fn_unique;	/* new vnode created by CONNLD */
	ushort		fn_flag;	/* flags as defined below */
	time_t		fn_atime;	/* creation times for pipe */
	time_t		fn_mtime;
	time_t		fn_ctime;
	struct fifonode	*fn_nextp;	/* next link in the linked list */
	struct fifonode	*fn_backp;	/* back link in linked list */
};

/*
 * Valid flags for fifonodes (16-bits wide)
 */
#define ISPIPE		0x1	/* fifonode is that of a pipe */
#define FIFOLOCK	0x2	/* fifonode is locked */
#define FIFOSEND        0x4	/* file descriptor at stream head of pipe */
#define FIFOWRITE       0x8	/* process is blocked waiting to write */
#define FIFOWANT       0x10	/* a process wants to access the fifonode */
#define FIFOREAD       0x20	/* process is blocked waiting to read */
#define FIFOPASS       0x40	/* CONNLD passed a new vnode in fn_unique */
#define FIFOCLOSING    0x80	/* fifonode in process of being closed */
#define FIFODONTLOCK  0x100	/* do NOT lock the fifo node as it's already */
#define FIFOWCLOSED  0x200	/* last writer has closed */

#ifdef _HIBERNATORII
/*
 * Definitions for the meaning of things returned from a I_FIFOENDS
 * ioctl.  These are masks for extracting the packed data
 */
#define FIFO_COUNTMSK   ((1<<24)-1)	/* 24 bits for counting */
#define FIFO_ISPIPE     (1<<24)		/* Is a pipe (as opposed to fifo) */
#endif /* _HIBERNATORII */

/*
 * Macros to convert a vnode to a fifnode, and vice versa.
 */
#define VTOF(vp) ((struct fifonode *)((vp)->v_data))
#define FTOV(fp) ((fp)->fn_vnode)

/*
 * Functions used in multiple places.
 */
#ifdef _KERNEL

struct cred;
struct vnode;

extern ushort fifogetid(void);
extern void   fifoclearid(ushort);
extern int fifo_rdchk(struct vnode *);
extern int fifo_stropen(struct vnode **, int, struct cred *);
extern struct vnode *makepipe(void);
extern fifo_lock_t *fifo_cr_lock(int);
void fifo_del_lock(fifo_lock_t *);

#endif	/* _KERNEL */

#endif	/* _FS_FIFOFS_FIFONODE_H */
