/*
 * dstore.c - FreeBSD global storage for lsof
 */


/*
 * Copyright 1994 Purdue Research Foundation, West Lafayette, Indiana
 * 47907.  All rights reserved.
 *
 * Written by Victor A. Abell
 *
 * This software is not subject to any license of the American Telephone
 * and Telegraph Company or the Regents of the University of California.
 *
 * Permission is granted to anyone to use this software for any purpose on
 * any computer system, and to alter it and redistribute it freely, subject
 * to the following restrictions:
 *
 * 1. Neither the authors nor Purdue University are responsible for any
 *    consequences of the use of this software.
 *
 * 2. The origin of this software must not be misrepresented, either by
 *    explicit claim or by omission.  Credit to the authors and Purdue
 *    University must appear in documentation and sources.
 *
 * 3. Altered versions must be plainly marked as such, and must not be
 *    misrepresented as being the original software.
 *
 * 4. This notice may not be removed or altered.
 */

#ifndef lint
static char copyright[] =
"@(#) Copyright 1994 Purdue Research Foundation.\nAll rights reserved.\n";
static char *rcsid = "$Id: dstore.c,v 1.5 95/07/20 12:37:04 abe Exp $";
#endif


#include "lsof.h"

#if	_FREEBSDV>=200
kvm_t *Kd = NULL;			/* kvm descriptor */
#endif	/* _FREEBSDV>=200 */

struct l_vfs *Lvfs = NULL;		/* local vfs structure table */

struct nlist Nl[] = {

#if	_FREEBSDV<205
	{ "_nchhead"    },
#else	/* _FREEBSDV>=205 */
	{ "_nclruhead"  },
#endif	/* _FREEBSDV<205 */

	{ "_numcache"   },
	{ ""            }
};

int Np = 0;				/* number of kernel processes */

#if	_FREEBSDV>=200
struct kinfo_proc *P = NULL;		/* local process table copy */
#endif	/* _FREEBSDV>=200 */
