#!/usr/local/bin/perl
# edit_sched.cgi
# Configure scheduled checking of services

require './status-lib.pl';
$access{'sched'} || &error($text{'sched_ecannot'});
&header($text{'sched_title'}, "");
print "<hr>\n";

print "<form action=save_sched.cgi>\n";
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'sched_header'}</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";

print "<tr> <td><b>$text{'sched_mode'}</b></td>\n";
printf "<td><input type=radio name=mode value=1 %s> %s\n",
	$config{'sched_mode'} ? 'checked' : '', $text{'yes'};
printf "<input type=radio name=mode value=0 %s> %s</td>\n",
	$config{'sched_mode'} ? '' : 'checked', $text{'no'};

print "<td><b>$text{'sched_single'}</b></td>\n";
printf "<td><input type=radio name=single value=1 %s> %s\n",
	$config{'sched_single'} ? 'checked' : '', $text{'yes'};
printf "<input type=radio name=single value=0 %s> %s</td> </tr>\n",
	$config{'sched_single'} ? '' : 'checked', $text{'no'};

print "<tr> <td><b>$text{'sched_int'}</b></td>\n";
printf "<td colspan=3><input name=int size=5 value='%s'>\n",
	$config{'sched_int'} ? $config{'sched_int'} : 5;
print "<select name=period>\n";
for($i=0; $i<4; $i++) {
	printf "<option value=%s %s>%s\n",
		$i, $config{'sched_period'} == $i ? 'selected' : '',
		$text{"sched_period_$i"};
	}
print "</select> $text{'sched_offset'}\n";
printf "<input name=offset size=5 value='%d'></td> </tr>\n",
	$config{'sched_offset'};

map { $hours{$_}++ } split(/\s+/, $config{'sched_hours'});
print "<tr> <td valign=top><b>$text{'sched_hours'}</b></td> <td>\n";
for($j=0; $j<24; $j+=6) {
	print "<select name=hours size=6 multiple>\n";
	for($i=$j; $i<$j+6; $i++) {
		printf "<option value=%s %s>%2.2d:00\n",
			$i, !%hours || $hours{$i} ? 'selected' : '', $i;
		}
	print "</select>\n";
	}
print "</td>\n";

map { $days{$_}++ } split(/\s+/, $config{'sched_days'});
print "<td valign=top><b>$text{'sched_days'}</b></td>\n";
print "<td><select name=days size=7 multiple>\n";
for($i=0; $i<7; $i++) {
	printf "<option value=%s %s>%s\n",
		$i, !%days || $days{$i} ? 'selected' : '', $text{"day_$i"};
	}
print "</select></td> </tr>\n";



print "<tr> <td><b>$text{'sched_warn'}</b></td>\n";
printf "<td colspan=3><input type=radio name=warn value=1 %s> %s\n",
	$config{'sched_warn'} ? 'checked' : '', $text{'sched_warn1'};
printf "<input type=radio name=warn value=0 %s> %s</td> </tr>\n",
	$config{'sched_warn'} ? '' : 'checked', $text{'sched_warn0'};

print "<tr> <td><b>$text{'sched_email'}</b></td>\n";
printf "<td colspan=3><input type=radio name=email_def value=1 %s> %s\n",
	$config{'sched_email'} ? '' : 'checked', $text{'sched_none'};
printf "<input type=radio name=email_def value=0 %s>\n",
	$config{'sched_email'} ? 'checked' : "";
printf "<input name=email size=30 value='%s'></td> </tr>\n",
	$config{'sched_email'};

print "<tr> <td><b>$text{'sched_from'}</b></td>\n";
printf "<td colspan=3><input name=from_def type=radio value=1 %s> %s (%s)\n",
	$config{'sched_from'} ? '' : 'checked', $text{'default'}, 'webmin';
printf "<input name=from_def type=radio value=0 %s>\n",
	$config{'sched_from'} ? 'checked' : '';
printf "<input name=from size=30 value='%s'></td> </tr>\n",
	$config{'sched_from'};

print "<tr> <td><b>$text{'sched_pager'}</b></td>\n";
printf "<td colspan=3><input type=radio name=pager_def value=1 %s> %s\n",
	$config{'sched_pager'} ? '' : 'checked', $text{'sched_none'};
printf "<input type=radio name=pager_def value=0 %s>\n",
	$config{'sched_pager'} ? 'checked' : "";
printf "<input name=pager size=30 value='%s'></td> </tr>\n",
	$config{'sched_pager'};

print "</table></td></tr></table>\n";
print "<input type=submit value='$text{'save'}'></form>\n";
print "<hr>\n";
&footer("", $text{'index_return'});

