#!/usr/local/bin/perl
# save_trusts.cgi
# Save trusted users list

require './sendmail-lib.pl';
&ReadParseMime();
$access{'trusts'} || &error($text{'trusts_ecannot'});
&error_setup($text{'trusts_err'});
&lock_file($config{'sendmail_cf'});
$conf = &get_sendmailcf();
@tlist = split(/\s+/, $in{'tlist'});
foreach $u (@tlist) {
	@uinfo = getpwnam($u);
	@uinfo || &error(&text('trusts_euser', $u));
	}
@tlist = &unique(@tlist);

# get old T directives
@old = &find_type("T", $conf);
foreach $f (&find_type("C", $conf)) {
	if ($f->{'value'} =~ /^t\s*(.*)$/) {
		push(@old, $f);
		}
	}

if ($in{'ctfile'}) {
	# If there is a .ct file, write all users to it and take any
	# out of sendmail.cf
	&lock_file($in{'ctfile'});
	open(CT, "> $in{'ctfile'}");
	foreach $u (@tlist) { print CT $u,"\n"; }
	close(CT);
	&unlock_file($in{'ctfile'});
	}
else {
	# Stick all users in sendmail.cf
	foreach $u (@tlist) {
		push(@new, { 'type' => 'T',
			     'values' => [ $u ] });
		}
	}
&save_directives($conf, \@old, \@new);
&flush_file_lines();
&unlock_file($config{'sendmail_cf'});
&restart_sendmail();
&webmin_log("trusts");
&redirect("");

