#!/usr/local/bin/perl
# index.cgi
# Display icons for various things that can be configured in sendmail

require './sendmail-lib.pl';

# check for mail-only user
if (!$access{'opts'} && !$access{'cws'} && !$access{'masq'} &&
    !$access{'trusts'} && !$access{'vmode'} && !$access{'amode'} &&
    !$access{'omode'} && !$access{'cgs'} && !$access{'relay'} &&
    !$access{'mailq'} && !$access{'mailers'} && !$access{'access'} &&
    !$access{'domains'} && $access{'mmode'}) {
	if ($access{'mmode'} == 2 && $access{'musers'} !~ /\s/) {
		&redirect("/$module_name/list_mail.cgi?user=$access{'musers'}");
		exit;
		}
	elsif ($access{'mmode'} == 4) {
		&redirect("/$module_name/list_mail.cgi?".
			  "user=$remote_user");
		exit;
		}
	else {
		&redirect("/$module_name/list_boxes.cgi");
		exit;
		}
	}

&header($text{'index_title'}, "", "intro", 1, 1, 0,
	&help_search_link("sendmail", "man", "doc", "google"));
print "<hr>\n";

# Check if sendmail is actually installed
if (!-x $config{'sendmail_path'}) {
	print "<p>",&text('index_epath', "<tt>$config{'sendmail_path'}</tt>",
			  "/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}

# Check if the config file exists, and is the right version
if (!-r $config{'sendmail_cf'}) {
	print "<p>",&text('index_econfig', "<tt>$config{'sendmail_cf'}</tt>",
			  "/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}
$conf = &get_sendmailcf();
if (!&check_sendmail_version($conf)) {
	print "<p>$text{'index_eversion'}<p>\n";
	print "<hr>\n";
	&footer("/", "index");
	exit;
	}

# Check the mail spool
local $mcount = 0;
foreach $mqueue (&mailq_dir($conf)) {
	opendir(QDIR, $mqueue);
	$mcount += scalar(grep { /^qf/ } readdir(QDIR));
	closedir(QDIR);
	}

@olinks =  ( "list_opts.cgi", "list_aliases.cgi", "list_cws.cgi", "list_masq.cgi", "list_trusts.cgi", "list_virtusers.cgi", "list_mailers.cgi", "list_generics.cgi", "list_cgs.cgi", "list_domains.cgi", "list_access.cgi", "list_relay.cgi", "list_features.cgi", "list_mailq.cgi", "list_boxes.cgi" );

@otitles = ( "$text{'opts_title'} (O)", "$text{'aliases_title'} (aliases)", "$text{'cws_title'} (Cw)", "$text{'masq_title'} (CM)", "$text{'trusts_title'} (T)", "$text{'virtusers_title'} (virtuser)", "$text{'mailers_title'} (mailertable)", "$text{'generics_title'} (generics)", "$text{'cgs_title'} (CG)", "$text{'domains_title'} (domaintable)", "$text{'access_title'} (access)", "$text{'relay_title'} (CR)", $text{'features_title'}, "$text{'mailq_title'} (mailq)<br>".&text('mailq_count', $mcount), "$text{'boxes_title'}"); 

@oicons =  ( "images/opts.gif", "images/aliases.gif", "images/cws.gif", "images/masq.gif", "images/trusts.gif", "images/virtusers.gif", "images/mailers.gif", "images/generics.gif", "images/cgs.gif", "images/domains.gif", "images/access.gif", "images/relay.gif", "images/features.gif", "images/mailq.gif", "images/boxes.gif" );

&filter_icons($access{'opts'}, "list_opts.cgi");
&filter_icons($access{'cws'}, "list_cws.cgi");
&filter_icons($access{'masq'}, "list_masq.cgi");
&filter_icons($access{'trusts'}, "list_trusts.cgi");
&filter_icons($access{'vmode'}, "list_virtusers.cgi");
&filter_icons($access{'amode'}, "list_aliases.cgi");
&filter_icons($access{'omode'}, "list_generics.cgi");
&filter_icons($access{'cgs'}, "list_cgs.cgi");
&filter_icons($access{'relay'}, "list_relay.cgi");
&filter_icons($access{'mailq'}, "list_mailq.cgi");
&filter_icons($access{'mailers'}, "list_mailers.cgi");
&filter_icons($access{'access'}, "list_access.cgi");
&filter_icons($access{'domains'}, "list_domains.cgi");
&filter_icons($features_access, "list_features.cgi");
&filter_icons($access{'mmode'}, "list_boxes.cgi");

&icons_table(\@olinks, \@otitles, \@oicons);

if ($access{'stop'}) {
	print "<hr>\n";
	if (open(PID, $config{'sendmail_pid'})) {
		chop($pid = <PID>);
		close(PID);
		}
	if ($pid && kill(0, $pid)) {
		print "<table cellpadding=5 width=100%><tr><td>\n";
		print "<form action=stop.cgi>\n";
		print "<input type=hidden name=pid value=$pid>\n";
		print "<input type=submit value=\"$text{'index_stop'}\">\n";
		print "</td> <td>$text{'index_stopmsg'}\n";
		}
	else {
		print "<table cellpadding=5 width=100%><tr><td>\n";
		print "<form action=start.cgi>\n";
		print "<input type=submit value=\"$text{'index_start'}\">\n";
		print "</td> <td>",&text('index_startmsg',
		      "<tt>$config{'sendmail_command'}</tt>"),"\n";
		}
	print "</td></tr></table></form>\n";
	}

print "<hr>\n";
&footer("/", $text{'index'});

sub filter_icons
{
if (!$_[0]) {
	local $idx = &indexof($_[1], @olinks);
	splice(@olinks, $idx, 1);
	splice(@otitles, $idx, 1);
	splice(@oicons, $idx, 1);
	}
}

