
do './quota-lib.pl';

# useradmin_create_user(&details)
# Sets quotas on chosen filesystems
sub useradmin_create_user
{
local ($k, $fs);
foreach $k (keys %config) {
	if ($k =~ /^sync_(\S+)$/) {
		# found a filesystem to set quotas on
		$fs = $1;
		@quot = split(/\s+/, $config{$k});
		&edit_user_quota($_[0]->{'user'}, $fs, @quot);
		}
	}
}

# useradmin_delete_user(&details)
# Zero the quotas of a deleted user
sub useradmin_delete_user
{
$n = &list_filesystems();
for($i=0; $i<$n; $i++) {
	if ($filesys{$i,'quotacan'} && $filesys{$i,'quotanow'}) {
		$fslist{$filesys{$i,'dir'}}++;
		}
	}
$n = &user_filesystems($_[0]->{'user'});
for($i=0; $i<$n; $i++) {
	$f = $filesys{$i,'filesys'};
	if ($fslist{$f}) {
		# user has quota, and filesystem is local
		&edit_user_quota($_[0]->{'user'}, $f, 0, 0, 0, 0);
		}
	}
}

# useradmin_modify_user(&details)
# Quotas are stored by UID, so no need to change anything
# when a username changes.
sub useradmin_modify_user
{
}

1;

