#!/usr/local/bin/perl
# list_cprivs.cgi
# Display a list of column priviliges

require './mysql-lib.pl';
$access{'perms'} || &error($text{'perms_ecannot'});
&header($text{'cprivs_title'}, "", "cprivs");
print "<hr>\n";

$d = &execute_sql($master_db, "select * from columns_priv order by table_name,column_name");
if (@{$d->{'data'}}) {
	print "<table border>\n";
	print "<tr $tb> <td><b>$text{'cprivs_field'}</b></td>\n",
	      "<td><b>$text{'cprivs_table'}</b></td>\n",
	      "<td><b>$text{'cprivs_db'}</b></td>\n",
	      "<td><b>$text{'cprivs_host'}</b></td>\n",
	      "<td><b>$text{'cprivs_user'}</b></td>\n",
	      "<td><b>$text{'cprivs_privs'}</b></td> </tr>\n";
	$i = -1;
	foreach $u (@{$d->{'data'}}) {
		$i++;
		next if ($access{'perms'} == 2 && !&can_edit_db($u->[1]));
		print "<tr $cb>\n";
		print "<td><a href='edit_cpriv.cgi?idx=$i'>",
			&html_escape($u->[4]),"</a></td>\n";
		print "<td>",&html_escape($u->[3]),"</td>\n";
		print "<td>",&html_escape($u->[1]),"</td>\n";
		print "<td>", $u->[0] eq '' || $u->[0] eq '%' ?
		      $text{'cprivs_all'} : &html_escape($u->[0]),"</td>\n";
		print "<td>",$u->[2] ? &html_escape($u->[2])
				     : $text{'cprivs_anon'},"</td>\n";
		print "<td>",!$u->[6] ? $text{'cprivs_none'} :
		     join("&nbsp;| ",split(/[, ]+/, $u->[6])),"</td>\n";
		print "</tr>\n";
		}
	print "</table>\n";
	}
else {
	print "<p><b>$text{'cprivs_norows'}</b><p>\n";
	}
print "<form action=edit_cpriv.cgi>\n";
print "<input type=submit value='$text{'cprivs_add'}'>\n";
print "<select name=table>\n";
foreach $d (&list_databases()) {
	if ($access{'perms'} == 1 || &can_edit_db($d)) {
		foreach $t (&list_tables($d)) {
			print "<option>$d.$t\n";
			}
		}
	}
print "</select></form>\n";

print "<hr>\n";
&footer("", $text{'index_return'});

