#!/usr/local/bin/perl
# index.cgi
# Show fetchmail configurations

require './fetchmail-lib.pl';
&header($text{'index_title'}, "", undef, 1, 1, 0,
	&help_search_link("fetchmail", "doc", "man", "google"));
print "<hr>\n";

# Check if fetchmail is installed
if (!&has_command($config{'fetchmail_path'})) {
	print "<p>",&text('index_efetchmail',
			  "<tt>$config{'fetchmail_path'}</tt>",
			  "/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}

if ($config{'config_file'}) {
	# Just read one config file
	@conf = &parse_config_file($config{'config_file'});
	@conf = grep { $_->{'poll'} } @conf;
	print "<b>",&text('index_file',
			  "<tt>$config{'config_file'}</tt>"),"</b><p>\n";
	&show_polls(\@conf, $config{'config_file'}, $config{'daemon_user'});

	# Show the fetchmail daemon form
	local @uinfo = getpwnam($config{'daemon_user'});
	print "<hr>\n";
	print "<table width=100%><tr><td>\n";
	foreach $pf ($config{'pid_file'},
		     "$uinfo[7]/.fetchmail.pid", "$uinfo[7]/.fetchmail") {
		if (open(PID, $pf) && ($line=<PID>) &&
		    (($pid,$interval) = split(/\s+/, $line)) && $pid &&
		    kill(0, $pid)) {
			$running++;
			last;
			}
		}
	if ($running) {
		# daemon is running - offer to stop it
		print "<form action=stop.cgi>\n";
		print "<input type=submit value='$text{'index_stop'}'></td>\n";
		print "<td>",&text('index_stopmsg',
				   "<tt>$config{'daemon_user'}</tt>",
				   $interval),"</td>\n";
		}
	else {
		# daemon isn't running - offer to start it
		print "<form action=start.cgi>\n";
		print "<input type=submit value='$text{'index_start'}'></td>\n";
		print "<td>",&text('index_startmsg',
				   "<input name=interval size=5 value='60'>",
				   "<tt>$config{'daemon_user'}</tt>"),"</td>\n";
		}
	print "</td></tr></table></form>\n";
	}
else {
	# Read all users' .fetchmailrc files
	print "<table border width=100%>\n";
	setpwent();
	while(@uinfo = getpwent()) {
		next if ($donehome{$uinfo[7]}++);
		@conf = &parse_config_file("$uinfo[7]/.fetchmailrc");
		@conf = grep { $_->{'poll'} } @conf;
		if (@conf) {
			if (!$doneheader++) {
				print "<tr $tb> <td><b>$text{'index_user'}</b></td> <td><b>$text{'index_conf'}</b></td> </tr>\n";
				}
			print "<tr $cb>\n";
			print "<td valign=top><b>",&html_escape($uinfo[0]),
			      "</b></td> <td>\n";
			&show_polls(\@conf, "$uinfo[7]/.fetchmailrc",
				    $uinfo[0]);
			print "</td> </tr>\n";
			}
		}
	endpwent() if ($gconfig{'os_type'} ne 'hpux');
	print "</table>\n";
	print "<br><b>$text{'index_none'}</b><br>\n" if (!$doneheader);
	print "<form action=edit_poll.cgi>\n";
	print "<input type=hidden name=new value=1>\n";
	print "<input type=submit value='$text{'index_ok'}'>\n";
	print &unix_user_input("user");
	print "</form>\n";
	}

print "<hr>\n";
&footer("/", $text{'index'});

# show_polls(&polls, file, user)
sub show_polls
{
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'index_poll'}</b></td> ",
      "<td><b>$text{'index_proto'}</b></td> ",
      "<td><b>$text{'index_users'}</b></td> </tr>\n" if (@{$_[0]});
foreach $p (@{$_[0]}) {
	print "<tr $cb>\n";
	print "<td valign=top><a href='edit_poll.cgi?file=$_[1]&",
	      "idx=$p->{'index'}&user=$_[2]'>",&html_escape($p->{'poll'}),
	      "</a></td>\n";
	print "<td>",$p->{'proto'} ? &html_escape(uc($p->{'proto'}))
				   : $text{'default'},"</td>\n";
	print "<td>\n";
	foreach $u (@{$p->{'users'}}) {
		printf "%s -> %s<br>\n",
			&html_escape($u->{'user'}),
			&html_escape(@{$u->{'is'}} ? join(" ", @{$u->{'is'}})
						   : $_[2]);
		}
	print "</td> </tr>\n";
	}
print "</table>\n";
print "<a href='edit_poll.cgi?new=1&file=$_[1]&user=$_[2]'>$text{'index_add'}</a>\n";
print "&nbsp;&nbsp;\n";
print "<a href='edit_global.cgi?file=$_[1]&user=$_[2]'>$text{'index_global'}</a>\n";
print "&nbsp;&nbsp;\n";
if (@{$_[0]}) {
	print "<a href='check.cgi?file=$_[1]&user=$_[2]'>$text{'index_run'}</a>\n";
	}
print "<p>\n";
}

