#!/usr/local/bin/perl
# save.cgi
# Save an edited file

require './custom-lib.pl';
&ReadParseMime();
@cmds = &list_commands();
$edit = $cmds[$in{'idx'}];
&error_setup($text{'view_err'});
$edit->{'edit'} && &can_run_command($edit) || &error($text{'edit_ecannot'});

# Run the before-command
if ($edit->{'before'}) {
	&system_logged("$edit->{'before'} >/dev/null 2>&1 </dev/null");
	}

# Save the file
&lock_file($edit->{'edit'});
$in{'data'} =~ s/\r//g;
open(FILE, ">$edit->{'edit'}") ||
	&error(&text('view_efile', $edit->{'edit'}, $!));
print FILE $in{'data'};
close(FILE);
&unlock_file($edit->{'edit'});

# Set permissions
if ($edit->{'user'}) {
	&system_logged("chown $edit->{'user'}:$edit->{'group'} ".
		       "$edit->{'edit'} >/dev/null 2>&1");
	}
if ($edit->{'perms'}) {
	&system_logged("chmod $edit->{'perms'} ".
		       "$edit->{'edit'} >/dev/null 2>&1");
	}

# Run the after-command
if ($edit->{'after'}) {
	&system_logged("$edit->{'after'} >/dev/null 2>&1 </dev/null");
	}

&webmin_log("save", "edit", $cmd->{'id'}, $edit);
&redirect("");

