# cpan-lib.pl
# Functions for getting information about perl modules

do '../web-lib.pl';
&init_config();
use Config;
$packages_file = "$module_config_directory/packages.txt.gz";

# Get the paths to perl and perldoc
open(PERL, "$config_directory/perl-path");
chop($perl_path = <PERL>);
close(PERL);
if (&has_command("perldoc")) {
	$perl_doc = &has_command("perldoc");
	}
else {
	$perl_path =~ /^(.*)\/[^\/]+$/;
	if (-x "$1/perldoc") {
		$perl_doc = "$1/perldoc";
		}
	}
if ($perl_doc && $] >= 5.006) {
	$perl_doc = "$perl_path -T $perl_doc";
	}

# list_perl_modules()
# Returns a list of all installed perl modules
sub list_perl_modules
{
local (@rv, $lmod, $podfile);
foreach $k (keys %Config) {
	if ($Config{$k} =~ /^\/(\S+)$/ && -r "$Config{$k}/perllocal.pod") {
		$podfile = "$Config{$k}/perllocal.pod";
		}
	}
open(POD, $podfile);
while(<POD>) {
	if (/^=head2\s+(.*):\s+C<Module>\s+L<([^\|>]*)(.*)>/i) {
		local $name = $2;
		local $mod = { 'name' => $2,
			       'date' => $1,
			       'index' => scalar(@rv) };
		if ($perl_doc) {
			chop($mod->{'file'}= `$perl_doc -l $name 2>/dev/null`);
			}
		if ($mod->{'file'}) {
			local $in_name;
			open(MOD, $mod->{'file'});
			while(<MOD>) {
				if (/^=head1\s+name/i) {
					$in_name = 1;
					}
				elsif (/^=/ && $in_name) {
					last;
					}
				elsif ($in_name) {
					$mod->{'desc'} .= $_;
					}
				}
			close(MOD);
			$mod->{'desc'} =~ s/^\s*$name\s+\-\s+//;
			}
		$lmod = $mod;
		push(@rv, $mod);
		}
	elsif (/^C<(\S+):\s+(.*)>/) {
		$lmod->{lc($1)} = $2;
		}
	}
close(POD);
return @rv;
}

sub download_packages_file
{
$config{'packages'} =~ /^http:\/\/([^\/]+)(\/.*)$/ ||
	&error($text{'download_epackages'});
local ($host, $page, $port) = ($1, $2, 80);
if ($host =~ /^(.*):(\d+)$/) { $host = $1; $port = $2; }
&http_download($host, $port, $page, $packages_file);
}

1;

