/* 
 *	HT Editor
 *	hthex.cc
 *
 *	Copyright (C) 1999, 2000, 2001 Stefan Weyergraf (stefan@weyergraf.de)
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2 as
 *	published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "htapp.h"
#include "htiobox.h"
#include "hthex.h"
#include "htsearch.h"
#include "stream.h"
#include "tools.h"

#include <string.h>

ht_view *hthex_init(bounds *b, ht_streamfile *file, ht_format_group *group)
{
	ht_hex_viewer *v=new ht_hex_viewer();
	v->init(b, HEX_DESC, VC_EDIT | VC_GOTO | VC_SEARCH | VC_REPLACE | VC_BLOCKOP | VC_RESIZE, file, group);

	v->search_caps|=SEARCHMODE_BIN | SEARCHMODE_EVALSTR | SEARCHMODE_EXPR;

/*	ht_group_sub *g=new ht_group_sub();
	g->init(file);

	ht_hex_sub *h=new ht_hex_sub();
	h->init(file, 0, 2, 0);
	ht_collapsable_sub *ch=new ht_collapsable_sub();
	ch->init(file, h, true, "eins", true);

	ht_hex_sub *i=new ht_hex_sub();
	i->init(file, 0, 2, 1);
	ht_collapsable_sub *ci=new ht_collapsable_sub();
	ci->init(file, i, true, "zwei", true);
	
	g->insert(ch);
	g->insert(ci);

	ht_collapsable_sub *cs=new ht_collapsable_sub();
	cs->init(file, g, true, "jo", true);

	v->insertsub(cs);*/
	
	ht_hex_file_sub *h=new ht_hex_file_sub();
	h->init(file, 0x0, file->get_size(), 0);
	v->insertsub(h);
	return v;
}

format_viewer_if hthex_if = {
	hthex_init,
	0
};

/*
 *	CLASS ht_hex_viewer
 */

char *ht_hex_viewer::func(UINT i, bool execute)
{
/*	switch (i) {
		case 6: {
			if (execute) {
				FILEOFS ofs;
				if (get_current_offset(&ofs)) {
					byte buf[64];
					if (pread(ofs, buf, 64)==64) {
						int e = calc_entropy2(buf, 64);
						infobox("64-byte entropy at offset %08x: %d %%", ofs, e);
					}
				}
			}
			return "entropy";
		}
		default:*/
			return ht_uformat_viewer::func(i, execute);
/*	}*/
	return 0;
}

void ht_hex_viewer::get_pindicator_str(char *buf)
{
	FILEOFS o;
	if (get_current_offset(&o)) {
		sprintf(buf, " %s %08x/%u ", edit() ? "edit" : "view", o, o);
	} else {
		strcpy(buf, "?");
	}
}
	
bool ht_hex_viewer::get_hscrollbar_pos(int *pstart, int *psize)
{
	int s=file->get_size();
	if (s) {
		int z=MIN(size.h*16, s-(int)top_id1);
		return scrollbar_pos(top_id1, z, s, pstart, psize);
	}
	return false;
}

void ht_hex_viewer::handlemsg(htmsg *msg)
{
	switch (msg->msg) {
		case msg_filesize_changed:
			htmsg m;
			m.msg=msg_filesize_changed;
			m.type=mt_broadcast;
			sendsubmsg(&m);
			
			uf_initialized=false;
			complete_init();
			
			dirtyview();
			return;
		case msg_get_scrollinfo:
			switch (msg->data1.integer) {
				case gsi_pindicator: {
					get_pindicator_str((char*)msg->data2.ptr);
					break;
				}
				case gsi_hscrollbar: {
					gsi_scrollbar_t *p=(gsi_scrollbar_t*)msg->data2.ptr;
					get_hscrollbar_pos(&p->pstart, &p->psize);
					break;
				}
				case gsi_vscrollbar: {
					gsi_scrollbar_t *p=(gsi_scrollbar_t*)msg->data2.ptr;
					get_vscrollbar_pos(&p->pstart, &p->psize);
					break;
				}
			}
			clearmsg(msg);
			dirtyview();
			return;
		case msg_keypressed:
			switch (msg->data1.integer) {
				case K_Control_T: {
					FILEOFS ofs;
					if (get_current_offset(&ofs)) {
						byte buf[64];
						if (pread(ofs, buf, 64)==64) {
							int e = calc_entropy2(buf, 64);
							infobox("64-byte entropy at offset %08x: %d %%", ofs, e);
						}
					}
				}
			}
	}
	ht_uformat_viewer::handlemsg(msg);
}

bool ht_hex_viewer::address_to_offset(fmt_vaddress addr, FILEOFS *ofs)
{
	*ofs=addr;
	return 1;
}

bool ht_hex_viewer::offset_to_address(FILEOFS ofs, fmt_vaddress *addr)
{
	*addr=ofs;
	return 1;
}

/*
 *	CLASS ht_hex_file_sub
 */

void ht_hex_file_sub::handlemsg(htmsg *msg)
{
	if (msg->msg==msg_filesize_changed) {
		UINT s=file->get_size();
		fsize=s;
		return;
	}
	ht_hex_sub::handlemsg(msg);
}

