/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: hxbackend.h,v 1.17.2.8 2004/11/23 00:24:25 rggammon Exp $
 * 
 * * Portions Copyright (c) 1995-2002 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef __HXPLAYERBACKEND__H
#define __HXPLAYERBACKEND__H

#ifdef DEBUG
#  undef DEBUG
#endif

#include "nsISupports.h"
#include "nsISupportsUtils.h"
#include "nsIPromptService.h"
#include "nsIScriptableUConv.h"
#include "nsIMemory.h"
#include "nsIObserver.h"

/* Mozilla 1.0-1.2 had nsIScriptableTimer.h and a different nsITimer.h. We
   use the nsIScriptableTimer version to avoid conflicts with the newer
   nsITimer. */
#include "nsIScriptableTimer.h"

/* Mozilla 1.3+ have the modern nsITimer */
#include "nsITimer.h"

#include "nsHXPlayer.h"

#define IPC_TIMEOUT 3 /* Three second timeout on ipc operations */

// #define IPC_TIMEOUT 360 /* Use this if debugging, and attaching to a
//                            mozilla process. */
// #warning "using extended IPC timeout"

class CHXPlayerBackend : public nsIObserver
{
public:
    NS_DECL_ISUPPORTS

    CHXPlayerBackend();
    virtual ~CHXPlayerBackend();
    
    // nsIObserver methods
    NS_IMETHOD Observe(nsISupports *pSubject, const char *szTopic, const PRUnichar *pData);
        
    nsresult SendMessage(const char *pBuf, int nSize);
    nsresult ReceiveMessage(char **ppBuf);
    
    int GetBackendVersion() { return m_iBackendVersion; }
    int GetPlayerVersion()  { return m_iPlayerVersion;  }
    
    nsresult Init(NPP instance);
    void Shutdown(PRBool bSendShutdownCommand = PR_TRUE);

    PRBool IsEmbeddedPlayerOpen(void) { return m_bEmbeddedPlayerOpen; }
    nsresult OpenEmbeddedPlayer(NPP instance);
    void CloseEmbeddedPlayer(PRBool bSendShutdownCommand = PR_TRUE);
    
    void AddHXPlayer(nsHXPlayer *pPlayer);
    void RemoveHXPlayer(nsHXPlayer *pPlayer);
    nsresult ReadGenericResponse(PRBool *retval);

    PRBool AreCallbacksSupported(void) { return m_pTimer || m_pObsoleteTimer; }
    
private:
    void ShowError(const char *szError, NPP instance = NULL);
    int  DestroyBackend();
    void ProcessCallback(const char *szCallback);
    nsresult PollForCallbacks(void);
    void StartCallbackTimer(void);
    void StopCallbackTimer(void);
    PRBool m_bCallbackTimerRunning;
    
    int m_fdApi;
    int m_fdCallback;
    
    int m_nChildPid;
    PRBool m_bPlayerShutdown;
    PRBool m_bEmbeddedPlayerOpen;
    
    char *m_pCallbackBuf;
    int m_nCallbackBufLen;
    int m_nCallbackBufPos;    
    
    nsITimer *m_pTimer;
    nsIScriptableTimer *m_pObsoleteTimer; // Only found in old mozilla's
    nsIScriptableUnicodeConverter *m_pUConv;
    nsIPromptService *m_pPromptService;
    nsIMemory *m_pMemory;

    nsHXPlayer **m_pPlayersList;
    int m_nPlayerCount;
    int m_nMaxPlayers;
    
    static const int m_iBackendVersion;
    static const int m_iPlayerVersion;

    friend void NS_PluginShutdown();
};

#endif // __HXPLAYERBACKEND__H

