/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: fontinfo.h,v 1.1.2.1 2004/07/09 01:50:15 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

/////////////////////////////////////////////////////////////////////////////
//
//  fontinfo.h
//
//  INT16 GetCharacterWidth(UINT16 ch, ULONG32 ulFontFaceIndex,
//  	    ULONG32 ulFontPtSize, BOOL isBold, BOOL isItalicized,
//	    ULONG32 ulFontCharsetIndex)
//  This function takes a char (which can be a 2-byte char, thus the val
//  passed in is a UINT16) and calculates its "width" (x-extent) in pixels
//  based on its font face (e.g., "courier"), its point size, whether or not
//  it is bold and/or is italicized.  The parameter ulFontCharsetIndex tells
//  the function whether or not the character is single byte, double byte,
//  or Unicode.
//
//
//  INT16 GetStringWidthInPixels(_CHAR* pStr, ULONG32 len,
//	    ULONG32 ulFontFaceIndex, ULONG32 ulFontPtSize, BOOL isBold,
//	    BOOL isItalicized, ULONG32 ulFontCharsetIndex);
//  This function returns the "width" in pixels of the string pStr, given
//  the font face, font charset, font point size, and whether or not the
//  character is bold &/or italicized:
//  WARNING: the value returned may be an error (which is a negative number)
//  so you must check the return val before using it!  A negative number is
//  the negative of the width found up to the point of error, so zero return
//  means error occurred before any char widths were calculated.
//
//
//

#if !defined(_FONTINFO_H_)
#define _FONTINFO_H_


//Error return values for the functions herein:
#define FONTINFO_ERROR_UNKNOWN_CHARSET    -1


/////////////////////////////////////////////////////////////////////////////
//
//  This function converts text that was authored in the mac-roman charset
//  to iso-8859-1 if we're in a renderer on a non-Mac machine, and vice
//  versa.
//
//  Returns FALSE if there was a problem, e.g., pBuf NULL.
//
#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */
BOOL ConvertAcrossCharacterSets(_CHAR* pBuf, ULONG32 ulCharset,
				BOOL bRendererIsCallingThis,
				UINT16 uiMaxSupportedLevel);
#ifdef __cplusplus
}
#endif  /* __cplusplus */



/////////////////////////////////////////////////////////////////////////////
//
//  This function returns the "width" in pixels of the character ch, given
//  the font face, font charset, font point size, and whether or not the
//  character is bold &/or italicized:
//
//  WARNING: the value returned may be an error (which is a negative number)
//  so you must check the return val before using it!
//
#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */
INT16 GetCharacterWidth(UINT16 ch, ULONG32 ulFontFaceIndex,
	ULONG32 ulFontPtSize, BOOL isBold, BOOL isItalicized,
	ULONG32 ulFontCharsetIndex);
#ifdef __cplusplus
}
#endif  /* __cplusplus */


/////////////////////////////////////////////////////////////////////////////
//
//  This function returns the "width" in pixels of the string pStr, given
//  the font face, font charset, font point size, and whether or not the
//  character is bold &/or italicized:
//
//  WARNING: the value returned may be an error (which is a negative number)
//  so you must check the return val before using it!  A negative number is
//  the negative of the width found up to the point of error, so zero return
//  means error occurred before any char widths were calculated.
//
#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */
INT16 GetStringWidthInPixels(_CHAR* pStr, ULONG32 len,
	ULONG32 ulFontFaceIndex, ULONG32 ulFontPtSize, BOOL isBold,
	BOOL isItalicized, ULONG32 ulFontCharsetIndex);
#ifdef __cplusplus
}
#endif  /* __cplusplus */

/////////////////////////////////////////////////////////////////////////////
//
//  This function returns the string associated with the point size, e.g.,
//  a point size of 16 (which is FONT_SIZE_0) returns "+0":
//
//  Note: pRetBuf must be capable of holding 3 chars + the NULL-terminator;
//  retBufSize is the number of bytes pRetBuf was allocated.
//
#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */
void getFontPointSizeStringFromPtSize(ULONG32 ulPtSize, char* pRetBuf,
	ULONG32 retBufSize);
#ifdef __cplusplus
}
#endif  /* __cplusplus */

/////////////////////////////////////////////////////////////////////////////
//
//  This function returns the string associated with the charset, e.g.,
//  a charset value of CHARSET__us_ascii returns "us-ascii":
//
//  Note: pRetBuf must be capable of holding 31 chars + the NULL-terminator;
//  retBufSize is the number of bytes pRetBuf was allocated.
//
#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */
void getFontCharsetStringFromCharsetVal(ULONG32 ulCharsetVal, char* pRetBuf,
	ULONG32 retBufSize);
#ifdef __cplusplus
}
#endif  /* __cplusplus */

/////////////////////////////////////////////////////////////////////////////
//
//  This function returns the string associated with the font face, e.g.,
//  a font face index of 20 (TIMES_FONT_FACE_STR) returns "times":
//
//  Note: pRetBuf must be capable of holding 31 chars + the NULL-terminator;
//  retBufSize is the number of bytes pRetBuf was allocated.
//
#ifdef __cplusplus
extern "C" {
#endif  /* __cplusplus */
void getFontFaceStringFromFaceIndex(ULONG32 ulFontFaceIndex, char* pRetBuf,
	ULONG32 retBufSize,
	//The following are necessary for backwards-compatibility; we don't
	// want to support fonts that can't play on older players, so, if
	// content version is older than when the font faces were added,
	// we have to ignore those font faces:
	ULONG32 ulMajorContentVersion, ULONG32 ulMinorContentVersion);
#ifdef __cplusplus
}
#endif  /* __cplusplus */

#endif

