/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: smldoc.h,v 1.6.12.2 2004/07/13 22:14:47 ehodge Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef SMLDOC_H
#define SMLDOC_H

// Forward declarations
typedef _INTERFACE IHXSite               IHXSite;
typedef _INTERFACE IHXValues             IHXValues;
typedef _INTERFACE IHXRenderer           IHXRenderer;
typedef _INTERFACE IHXGroup              IHXGroup;
typedef _INTERFACE IHXBuffer             IHXBuffer;
typedef _INTERFACE IHXScheduler          IHXScheduler;
typedef _INTERFACE IHXSiteManager        IHXSiteManager;
typedef _INTERFACE IHXStatusMessage      IHXStatusMessage;
typedef _INTERFACE IHXViewPortManager    IHXViewPortManager;
typedef _INTERFACE IHXErrorMessages      IHXErrorMessages;
typedef _INTERFACE IHXErrorSink          IHXErrorSink;
typedef _INTERFACE IHXHyperNavigate      IHXHyperNavigate;
typedef _INTERFACE IHXMutex              IHXMutex;
typedef _INTERFACE IHXSiteUser           IHXSiteUser;
typedef _INTERFACE IHXPlayer             IHXPlayer;
typedef _INTERFACE IHXPersistentRenderer IHXPersistentRenderer;
typedef _INTERFACE IHXLayoutStream       IHXLayoutStream;
typedef void*                             LISTPOSITION;
typedef void*                             POSITION;
class  CSmilRenderer;
class  CSmilAddGroup;
class  CSmilRegion;
class  CSmilRegPoint;
#if defined(HELIX_FEATURE_SMIL2_MULTIWINDOWLAYOUT)
class  CSmilViewport;
#endif /* #if defined(HELIX_FEATURE_SMIL2_MULTIWINDOWLAYOUT) */
class  CSmilRootLayout;
class  CSmilSource;
class  CSmilMeta;
class  CSmilMetadata;
class  CSmilEndLayout;
class  CSmilRendererPreFetch;
class  CSmilSourceUpdate;
class  CSmilTransition;
class  SMILNode;
class  CSmilAnimateElement;
class  CSmilElement;
class  CSmilSiteUser;
class  CSmilBasicRegion;
#if defined(HELIX_FEATURE_SMIL2_MULTIWINDOWLAYOUT)
class  CSmilBasicViewport;
#endif /* #if defined(HELIX_FEATURE_SMIL2_MULTIWINDOWLAYOUT) */
#if defined(HELIX_FEATURE_SMIL2_TRANSITIONS)
class  CSmilTransitionInfo;
#endif /* #if defined(HELIX_FEATURE_SMIL2_TRANSITIONS) */
class  CAnimationSandwichLayer;
class  CSmilBasicBox;
class  CSmilAnimateInfo;
class  CAttr;
class  CSmilSiteWatcher;
class  CSmilLayoutEvent;
class  CHXSimpleList;
class  CSmilAAnchorElement;
class  CSmilParser;
class  CHXMapStringToOb;
class  CSmilBasicRootLayout;
class  CHXMapPtrToPtr;
class  CHXMapLongToObj;
class  CSmilTransition;
class  CSmilShowSiteEvent;
class  CSmilAnimateEvent;
class  CHyperlinkCallback;
class  HandlePendingSchedulingCallback;
class  CHXString;
class  CHXStack;
class  CExternalMediaMarkerInfo;
#if defined(_MACINTOSH) || defined(_MAC_UNIX)
class CResourceLoader;
#elif defined(_UNIX) && (!(defined(_BEOS))) && (!(defined(_MAC_UNIX)))
class XData;
#endif
struct SMILSiteInfo;
struct SMILPlayToAssoc;
struct SMILGroupInfo;
struct SMILSourceInfo;

#if defined(_UNIX) && (!(defined(_BEOS))) && (!(defined(_MAC_UNIX)))
//We need to include the X headers...
// XXXMEH - try to get rid of these - not
// usually a good idea to have includes
// inside of a header file
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "hxmap.h"
#include "hxvsurf.h"
#endif

#define DEFAULT_ROOT_LAYOUT_WIDTH  320
#define DEFAULT_ROOT_LAYOUT_HEIGHT 240

class CSmilDocumentRenderer:  public IHXRendererAdviseSink,
                              public IHXClientAdviseSink,
                              public IHXGroupSink,
                              public IHXPrefetchSink,
                              public IHXTrackSink,
#if defined(HELIX_FEATURE_SMIL2_MULTIWINDOWLAYOUT)
                              public IHXViewPortSink,
#if defined(XXXMEH_DO_VIEWPORT_TLC)
                              public IHXViewPortSupplier,
#endif
#endif /* #if defined(HELIX_FEATURE_SMIL2_MULTIWINDOWLAYOUT) */
#if defined(BE_SITE_SUPPLIER_20010205)
                              public IHXSiteSupplier,
#endif
                              public IHXMediaMarkerSink,
                              public IHXEventSink,
                              public IHXErrorSink,
                              public CSmilElementHandler,
                              public CSmilEventHookResponse,
                              public CSmilSiteUserResponse,
                              public CSmilPassiveSiteWatcherResponse
{
public:
    CSmilDocumentRenderer(CSmilRenderer* pParent, IUnknown* pContext);
    virtual ~CSmilDocumentRenderer();

    // IUnknown methods
    STDMETHOD(QueryInterface)    (THIS_ REFIID riid, void** ppvObj);
    STDMETHOD_(ULONG32, AddRef)  (THIS);
    STDMETHOD_(ULONG32, Release) (THIS);

    // IHXRendererAdviseSink methods
    STDMETHOD(TrackDurationSet)         (THIS_ UINT32 ulGroupIndex, UINT32 ulTrackIndex,
                                               UINT32 ulDuration,   UINT32 ulDelay,
                                               BOOL   bIsLive);
    STDMETHOD(RepeatedTrackDurationSet) (THIS_ const char* pID, UINT32 ulDuration,
                                               BOOL bIsLive);
    STDMETHOD(TrackUpdated)             (THIS_ UINT32 ulGroupIndex, UINT32 ulTrackIndex,
                                               IHXValues* pValues);
    STDMETHOD(RendererInitialized)      (THIS_ IHXRenderer* pRend, IUnknown* pStream,
                                               IHXValues* pInfo);
    STDMETHOD(RendererClosed)           (THIS_ IHXRenderer* pRend, IHXValues* pInfo);

   // IHXClientAdviseSink methods               ref:  hxclsnk.h
    STDMETHOD (OnPosLength)  (THIS_ UINT32 ulPosition, UINT32 ulLength);
    STDMETHOD (OnPresentationOpened) (THIS);
    STDMETHOD (OnPresentationClosed) (THIS);
    STDMETHOD (OnStatisticsChanged)  (THIS);
    STDMETHOD (OnPreSeek)    (THIS_ UINT32 ulOldTime, UINT32 ulNewTime);
    STDMETHOD (OnPostSeek)   (THIS_ UINT32 ulOldTime, UINT32 ulNewTime);
    STDMETHOD (OnStop)       (THIS);
    STDMETHOD (OnPause)      (THIS_ UINT32 ulTime);
    STDMETHOD (OnBegin)      (THIS_ UINT32 ulTime);
    STDMETHOD (OnBuffering)  (THIS_ UINT32 ulFlags, UINT16 unPercentComplete);
    STDMETHOD (OnContacting) (THIS_ const char* pHostName);

    // IHXGroupSink methods
    STDMETHOD(GroupAdded)       (THIS_ UINT16 uGroupIndex, IHXGroup* pGroup);
    STDMETHOD(GroupRemoved)     (THIS_ UINT16 uGroupIndex, IHXGroup* pGroup);
    STDMETHOD(AllGroupsRemoved) (THIS);
    STDMETHOD(TrackAdded)       (THIS_ UINT16 uGroupIndex, UINT16 uTrackIndex, IHXValues* pTrack);
    STDMETHOD(TrackRemoved)     (THIS_ UINT16 uGroupIndex, UINT16 uTrackIndex, IHXValues* pTrack);
    STDMETHOD(TrackStarted)     (THIS_ UINT16 uGroupIndex, UINT16 uTrackIndex, IHXValues* pTrack);
    STDMETHOD(TrackStopped)     (THIS_ UINT16 uGroupIndex, UINT16 uTrackIndex, IHXValues* pTrack);
    STDMETHOD(CurrentGroupSet)  (THIS_ UINT16 uGroupIndex, IHXGroup* pGroup);

    // IHXPrefetchSink methods
    STDMETHOD(PrefetchTrackAdded)   (THIS_ UINT16 uGroupIndex, UINT16 uPrefetchTrackId,
                                           IHXValues* pTrack);
    STDMETHOD(PrefetchTrackRemoved) (THIS_ UINT16 uGroupIndex, UINT16 uPrefetchTrackId,
                                           IHXValues* pTrack);
    STDMETHOD(PrefetchTrackDone)    (THIS_ UINT16 uGroupIndex, UINT16 uPrefetchTrackId,
                                           HX_RESULT   status);

    // IHXTrackSink methods
    STDMETHOD(BeginDone)             (THIS_ UINT16 uGroupIndex, UINT16 uTrackIndex);
    STDMETHOD(SeekDone)              (THIS_ UINT16 uGroupIndex, UINT16 uTrackIndex,
                                            UINT32 ulSeekTime);
    STDMETHOD(PauseDone)             (THIS_ UINT16 uGroupIndex, UINT16 uTrackIndex);
    STDMETHOD(StopDone)              (THIS_ UINT16 uGroupIndex, UINT16 uTrackIndex);
    STDMETHOD(OnSoundLevelAnimation) (THIS_ UINT16 uGroupIndex, UINT16 uTrackIndex,
                                            UINT32 ulSoundLevelAnimationTime);

#if defined(HELIX_FEATURE_SMIL2_MULTIWINDOWLAYOUT)
    // IHXViewPortSink methods
    STDMETHOD(ViewPortOpened)    (THIS_ const char* pszViewPort);
    STDMETHOD(ViewPortClosed)    (THIS_ const char* pszViewPort);
    STDMETHOD(ViewPortShown)     (THIS_ const char* pszViewPort);
    STDMETHOD(ViewPortHidden)    (THIS_ const char* pszViewPort);
    STDMETHOD(ViewPortFocusSet)  (THIS_ const char* pszViewPort);
    STDMETHOD(ViewPortZOrderSet) (THIS_ const char* pszViewPort, UINT32 ulZOrder);

#ifdef XXXMEH_DO_VIEWPORT_TLC
    // IHXViewPortSupplier methods
    STDMETHOD(OnViewPortOpen)   (THIS_ IHXValues* pValues, IHXSiteUser* pSiteUser);
    STDMETHOD(OnViewPortClose)  (THIS_ const char* pszViewPort);
    STDMETHOD(OnViewPortShow)   (THIS_ const char* pszViewPort);
    STDMETHOD(OnViewPortHide)   (THIS_ const char* pszViewPort);
    STDMETHOD(OnViewPortFocus)  (THIS_ const char* pszViewPort);
    STDMETHOD(OnViewPortZOrder) (THIS_ const char* pszViewPort, UINT32 ulZOrder);
#endif

#endif /* #if defined(HELIX_FEATURE_SMIL2_MULTIWINDOWLAYOUT) */

#if defined(BE_SITE_SUPPLIER_20010205)
    // IHXSiteSupplier methods
    STDMETHOD(SitesNeeded)       (THIS_ UINT32 uRequestID, IHXValues* pSiteProps);
    STDMETHOD(SitesNotNeeded)    (THIS_ UINT32 uRequestID);
    STDMETHOD(BeginChangeLayout) (THIS);
    STDMETHOD(DoneChangeLayout)  (THIS);
#endif

    // IHXMediaMarkerSink methods
    STDMETHOD(MarkerResolved) (THIS_ IHXBuffer* pURLStr,
                                     IHXBuffer* pMarkerNameStr,
                                     UINT32      ulTime,
                                     IHXValues* pOtherMarkerParams);

    // IHXEventSink methods
    STDMETHOD(EventFired) (THIS_ IHXBuffer* pURLStr,
                                 IHXBuffer* pFragmentStr,
                                 IHXBuffer* pEventNameStr,
                                 IHXValues* pOtherValues);

    // IHXErrorSink methods
    STDMETHOD(ErrorOccurred) (THIS_ const UINT8   unSeverity,
                                    const ULONG32 ulHXCode,
                                    const ULONG32 ulUserCode,
                                    const char*   pUserString,
                                    const char*   pMoreInfoURL);

    // CSmilElementHandler methods - these are
    // the methods that the CSmilParser and CSmilElements
    // will call us back on
    HX_RESULT handleAddGroup(CSmilAddGroup* pAddGroup);
    HX_RESULT handleRegion(CSmilRegion* pRegion);
    HX_RESULT handleRegPoint(CSmilRegPoint* pRegPt);
#if defined(HELIX_FEATURE_SMIL2_MULTIWINDOWLAYOUT)
    HX_RESULT handleViewport(CSmilViewport* pView);
#endif /* #if defined(HELIX_FEATURE_SMIL2_MULTIWINDOWLAYOUT) */
    HX_RESULT handleRootLayout(CSmilRootLayout* pRootLayout);
    HX_RESULT handleSource(CSmilSource* pSource);
    HX_RESULT handleMeta(CSmilMeta* pMeta);
    HX_RESULT handleMetadata(CSmilMetadata* pMetadata);
    HX_RESULT handleEndLayout(CSmilEndLayout* pSource);
    HX_RESULT handleRendererPreFetch(CSmilRendererPreFetch* pRend);
    HX_RESULT handleSourceUpdate(CSmilSourceUpdate* pUpdate);
#if defined(HELIX_FEATURE_SMIL2_TRANSITIONS)
    HX_RESULT handleTransition(CSmilTransition* pTrans);
#endif /* #if defined(HELIX_FEATURE_SMIL2_TRANSITIONS) */
    HX_RESULT handleTrackRemoval(const char* pID, INT32 nGroupNum);
    HX_RESULT handleTrackPausing(SMILNode*                     pNode,
                                 LONG32                        lTimeOfPause,
                                 SMILPriorityClassPauseDisplay pauseDisplay,
                                 const char*                   pIdOfPauser);
    HX_RESULT handleTrackResuming(const char* pID, INT32 nGroupNum);
#if defined(HELIX_FEATURE_SMIL2_ANIMATION)
    HX_RESULT handleAnimate(CSmilAnimateElement* pAnimate);
#endif /* #if defined(HELIX_FEATURE_SMIL2_ANIMATION) */
    HX_RESULT handleRemoveTimeUpdate(CSmilElement* pElement, UINT32 ulRemoveTime);
    HX_RESULT handleExternalMediaMarkerFile(CSmilElement* pElement,
                                            const char*   pszID,
                                            const char*   pszExternalFileName,
                                            const char*   pszRelativeSource);
    HX_RESULT resolveGroupDurToOuterTimeContainerDur(UINT32 ulGroupIndex,
                                                     UINT32 ulGroupTimeContainerDuration);
    HX_RESULT GetCurGroupDuration(REF(UINT32) ulCurGrpDur);

    // CSmilEventHookResponse methods
    STDMETHOD(HandleMouseMove)        (THIS_ void*       pWindow,
                                             const char* pRegionID,
                                             const char* pMediaID,
                                             UINT16      uXPos,
                                             UINT16      uYPos,
                                             UINT32      kRMAEvent,
                                             REF(BOOL)   bHandleSetCursor);
    STDMETHOD(HandleLButtonUp)        (THIS_ const char* pRegionID,
                                             const char* pMediaID,
                                             UINT16      uXPos,
                                             UINT16      uYPos,
                                             REF(BOOL)   rbHandled);
    STDMETHOD(HandleGotFocus)         (THIS_ const char* pRegionID,
                                             const char* pMediaID);
    STDMETHOD(HandleLostFocus)        (THIS_ const char* pRegionID,
                                             const char* pMediaID);
    STDMETHOD(HandleCharEvent)        (THIS_ UINT16 uChar);
    STDMETHOD_(BOOL, HandleSetCursor) (THIS);
    STDMETHOD(AddShowEvents)          (THIS_ const char* pRegionName, IHXSite* pSite);

    // CSmilSiteUserResponse methods
    STDMETHOD(SiteUserAttachSite)  (THIS_ CSmilSiteUser* pUser, IHXSite* pSite);
    STDMETHOD(SiteUserDetachSite)  (THIS_ CSmilSiteUser* pUser);
    STDMETHOD(SiteUserHandleEvent) (THIS_ CSmilSiteUser* pUser, HXxEvent* pEvent);

    // CSmilPassiveSiteWatcherResponse methods
    STDMETHOD(SitePositionChanged) (THIS_ IHXSite* pSite, HXxPoint* pPoint);
    STDMETHOD(SiteSizeChanged)     (THIS_ IHXSite* pSite, HXxSize*  pSize);

    // CSmilDocumentRenderer public methods
    HX_RESULT            close(CSmilRenderer* pParent);
    HX_RESULT            setDocument(const char* pFragment);
    HX_RESULT            setupDummySource();
    HX_RESULT            onPacket(IHXBuffer* pBuffer, BOOL bIsFinal);
    HX_RESULT            handleNamedEvent(const char* pRegionID,
                                          const char* pMediaID,
                                          const char* pEventName);
    HX_RESULT            detachSite(IHXSite* pSite);
    double               getResizeXScale() { return m_dResizeXScale; }
    double               getResizeYScale() { return m_dResizeYScale; }
    HX_RESULT            onHeader(IHXValues* pHeader);
    HX_RESULT            onTimeSync(UINT32 ulTimeValue);
    HX_RESULT            onPreSeek(UINT32 ulOldTime, UINT32 ulNewTime);
    HX_RESULT            endStream();
    CSmilBasicRegion*    setupDefaultLayout();
    CSmilBasicRegion*    getRegionByID(const char* pID);
    UINT32               getNumRegionsByName(const char* pszName);
    CSmilBasicRegion*    getFirstRegionByName(const char* pszName);
    CSmilBasicRegion*    getNextRegionByName(const char* pszName);
    BOOL                 isAncestorRegion(CSmilBasicRegion* pPossibleParent,
                                          CSmilBasicRegion* pPossibleChild);
    HX_RESULT            getCommonAncestorRegion(CSmilBasicRegion*      pRegA,
                                                 CSmilBasicRegion*      pRegB,
                                                 REF(CSmilBasicRegion*) rpCommon);
    CSmilRegPoint*       getRegPoint(const char* pszID);
    CSmilSource*         getSource(const char* pszID);
    HX_RESULT            handleHyperlinkTraversal(CSmilAAnchorElement* pAnc,
                                                  BOOL bCalledFromCallback = FALSE);
#if defined(HELIX_FEATURE_SMIL2_MULTIWINDOWLAYOUT)
    CSmilBasicViewport*  getViewport(const char* pszID);
    CSmilBasicViewport*  getViewportBySiteUser(CSmilSiteUser* pSiteUser);
    CSmilBasicViewport*  getViewportBySite(IHXSite* pSite);
    CSmilBasicViewport*  getViewportByDescendant(CSmilBasicRegion* pRegion);
#endif /* #if defined(HELIX_FEATURE_SMIL2_MULTIWINDOWLAYOUT) */
    CSmilBasicBox*       getTopLevelBox(CSmilBasicRegion* pRegion);
    void                 resizeRegion(const char* pRegionName, HXxSize* pNewSize);
    void                 repositionRegion(const char* pRegionName, HXxPoint* pNewPosition);
    void                 setTopLevelSiteSize();
    HX_RESULT            getErrorInfo(REF(UINT32) ulErrorLine,
                                      REF(UINT32) ulErrorColumn,
                                      REF(IHXBuffer*) pErrorText);
    HX_RESULT            getErrorInterface(REF(IHXErrorMessages*) rpErrMsgs);
#if defined(HELIX_FEATURE_SMIL2_TRANSITIONS)
    CSmilTransitionInfo* getTransition(const char* pID);
    HX_RESULT            makeTransitionValues(CSmilTransitionInfo* pInfo,
                                              BOOL                 bTransIn,
                                              REF(IHXValues*)     rpValues);
    HX_RESULT            startTransition(UINT32               ulStartTime,
                                         CSmilTransitionInfo* pTransInfo,
                                         SMILSiteInfo*        pInfo,
                                         SMILPlayToAssoc*     pAssoc,
                                         IHXSite*            pSite,
                                         UINT32               ulActualTime,
                                         BOOL                 bBeginTransition);
#endif /* #if defined(HELIX_FEATURE_SMIL2_TRANSITIONS) */
#if defined(HELIX_FEATURE_SMIL2_ANIMATION)
    HX_RESULT            addAnimation(CAnimationSandwichLayer* pLayer);
    HX_RESULT            removeAnimation(CSmilAnimateElement* pAnimate);
    void                 removeAnimation(CSmilAnimateInfo* pInfo);
#endif /* #if defined(HELIX_FEATURE_SMIL2_ANIMATION) */
    const char*          getDefaultNamespace();
    void                 setMediaNativeSize(const char* pszID, HXxSize cSize);
    HX_RESULT            processMediaRegionOverrides(const char* pszRegionID,
                                                     const char* pszMediaID,
                                                     BOOL        bMediaStart,
                                                     UINT32      ulTime);
    BOOL                 isTransparent(UINT32 ulColor) const;
    void                 resolveZOrder(CSmilBasicBox* pBox, UINT32 ulTime);
    HX_RESULT            getMostRecentInfo(IHXSite* pSite, UINT32 ulTime,
                                           REF(UINT32) rulStartTime,
                                           REF(UINT32) rulLexicalOrder);
    BOOL                 hasParamChildren(CSmilElement* pElement,
                                          BOOL          bServerOnly);
    void                 addParamProperties(CSmilElement* pElement,
                                            IHXValues*   pValues,
                                            IUnknown*     pContext,
                                            BOOL          bServerOnly);
    void                 checkAnimChildren(CSmilElement* pElement, UINT32 ulTrackEnd);
    void                 showAllSites(CSmilBasicBox* pBox, BOOL bShow);

    HX_RESULT            GetElementProperties(UINT16            uGroupID, 
                                              UINT16            uTrackID, 
                                              REF(IHXValues*)  pProperties);

    HX_RESULT            GetElementStatus(UINT16            uGroupID,
                                          UINT16            uTrackID,
                                          UINT32            ulCurrentTime,
                                          REF(IHXValues*)  pStatus);

    HX_RESULT		 AttachElementLayout(UINT16	    uGroupID,
					     UINT16	    uTrackID,
					     IHXRenderer*  pRenderer,
					     IHXStream*    pStream,
					     IHXValues*    pProps);
    HX_RESULT		 DetachElementLayout(IUnknown*	    pLSG);

    BOOL                 isRegionActive(const char* pszRegID, UINT16 usGroup, UINT32 ulTime);
    void                 handlePendingScheduling(void);

    HX_RESULT            AdjustSoundLevelsOfAllCurrentTracks(UINT16 uCurGroupIndex,
                                        UINT32 ulSoundLevelAdjustment_pct,
                                        CSmilSource* pSmilSourceDontAdjustMe);


    // CSmilDocumentRenderer static public methods
    static void          computeRegPoint(HXxRect       cRegionRect,
                                         RegPoint      cRegPointInfo,
                                         REF(HXxPoint) rcRegPoint);
    static HX_RESULT     computeMediaLayout(HXxRect      cRegionRect,
                                            Fit          eFit,
                                            HXxPoint     cRegPoint,
                                            RegAlign     eRegAlign,
                                            HXxSize      cMediaSize,
                                            REF(HXxRect) rcMediaRect,
                                            BOOL         bMediaIsBrush);
    static void          computeHalfBounds(INT32 lMid, INT32 lSpan,
                                           REF(INT32) rlMin, REF(INT32) rlMax);
    static void          computeFillHiddenScaling(Fit eFit, INT32 lRegPt, INT32 lMediaDim,
                                                  INT32 lRegionLo, INT32 lRegionHi,
                                                  REF(INT32) rlMediaLo,
                                                  REF(INT32) rlMediaHi);
    static void          computeMeetSliceScaling(BOOL   bIsMeet, UINT32 ulNumDim,
                                                 INT32 lA1, INT32 lA2, INT32 lA3,
                                                 INT32 lB1, INT32 lB2, INT32 lB3,
                                                 INT32 lC1, INT32 lC2, INT32 lC3,
                                                 INT32 lD1, INT32 lD2, INT32 lD3,
                                                 REF(INT32) rlA, REF(INT32) rlB,
                                                 REF(INT32) rlC, REF(INT32) rlD);
    static void          showSite(IHXSite* pSite, BOOL bShow);
    static BOOL          isSiteVisible(IHXSite* pSite);
    static void          setSiteZIndex(IHXSite* pSite, INT32 lZIndex);
    static INT32         getSiteZIndex(IHXSite* pSite);
    static UINT32        getNumberOfChildSites(IHXSite* pSite);
    static void          addStringProperty(IHXValues* pValues,
                                           IUnknown*   pContext,
                                           const char* pszName,
                                           const char* pszValue);


    // CSmilDocumentRenderer public members
    CHXString        m_metadata;
    CHXStack*        m_pPlayerResumeStack;
#if defined(BE_SITE_SUPPLIER_20010205)
    CHXString        m_XXXEH_HACK_regionId;
    IHXPlayer*      m_pIndependentPlayer;
    CHXMapLongToObj* m_pChildSiteInfoMap;
#endif

    friend class CSmilRenderer;
private:
    // CSmilDocumentRenderer private methods
    HX_RESULT            addSiteForRenderer(SMILPlayToAssoc* pPlayToAssoc,
                                            SMILSourceInfo*  pSMILSourceInfo,
                                            IHXRenderer*    pRenderer,
                                            BOOL             bNoRegion);
    HX_RESULT            addSiteForRendererByRegion(SMILPlayToAssoc*  pPlayToAssoc,
                                                    SMILSourceInfo*   pSMILSourceInfo,
                                                    IHXRenderer*     pRenderer,
                                                    BOOL              bNoRegion,
                                                    CSmilBasicRegion* pRegion);
    HX_RESULT            setSiteProperty(IHXSite*   pSite,
                                         const char* pszKey,
                                         const char* pszValue);
    HX_RESULT            setSitePropertyULONG32(IHXSite*   pSite,
                                                const char* pszKey,
                                                UINT32      ulValue);
    HX_RESULT            getSiteProperty(IHXSite*        pSite,
                                         const char*      pszKey,
                                         REF(IHXBuffer*) rpValueStr);
    void                 setPlayToAssoc(UINT16      uGroupIndex, 
                                        UINT16      uTrackIndex, 
                                        const char* pID,
                                        const char* pRepeatID,
                                        const char* pPlayTo,
                                        const char* pRegionName,
                                        const char* pBeginTransition,
                                        const char* pEndTransition,
                                        UINT32      regionZOrder,
                                        BOOL        bXMMSource = FALSE);
    HX_RESULT            doTransition(LISTPOSITION pos, UINT32 ulTime);
    HX_RESULT            moveHideEventForSiteBack(SMILSiteInfo* pInfo,
                                                  UINT32        ulEndTime,
                                                  UINT32        len, 
                                                  BOOL          bJustRenderer);
#if defined(HELIX_FEATURE_SMIL2_TRANSITIONS)
    HX_RESULT            checkSitesHideTime(SMILSiteInfo*        pOtherSiteInfo,
                                            SMILSiteInfo*        pSiteInfo,
                                            CSmilTransitionInfo* pTransInfo,
                                            REF(IHXSite*)       pSiteToTransition,
                                            BOOL                 bBeginTransition);
#endif /* #if defined(HELIX_FEATURE_SMIL2_TRANSITIONS) */
    HX_RESULT            ignoreLastHideEvent(UINT32 ulGroupIndex, SMILGroupInfo* pGroupInfo);
    BOOL                 SitesOverlap(IHXSite* pCanidate, IHXSite* pSite);
    SMILPlayToAssoc*     getPlayToAssoc(UINT16 uGroupIndex, UINT16 uTrackIndex);
    SMILPlayToAssoc*     getPlayToAssoc(const char* pName);
    SMILPlayToAssoc*     getPlayToAssocByMedia(const char* pszMediaID);
    void                 removeAllPlayToAssoc();
    void                 removeGroupsPlayToAssoc(UINT16 uGroupIndex);
    void                 removeTracksPlayToAssoc(UINT16 uGroupIndex, UINT16 uTrackIndex);
    void                 removeActiveTransitions();
    void                 removeViewports();
    void                 resetRendererSites(CSmilBasicRegion* pRegion);
    CSmilSiteWatcher*    getRendererSiteWatcher(const char* pszMediaID);
    void                 addRendererSiteWatcherToMap(const char* pszMediaID,
                                                     CSmilSiteWatcher* pWatch);
    void                 removeRendererSiteWatcherFromMap(const char* pszMediaID);
    void                 clearRendererSiteWatcherMap();
    HX_RESULT            getRendererSite(const char* pszMediaID, REF(IHXSite*) rpSite);
    void                 addRendererSiteToMap(const char* pszMediaID, IHXSite* pSite);
    void                 removeRendererSiteFromMap(const char* pszMediaID);
    void                 clearRendererSiteMap();
    HX_RESULT            getRenderer(const char* pszMediaID, REF(IHXRenderer*) rpRenderer);
    void                 addRendererToMap(const char* pszMediaID, IHXRenderer* pRenderer);
    void                 removeRendererFromMap(const char* pszMediaID);
    void                 clearRendererMap();
    HX_RESULT            actualRendererClosed(IHXRenderer* pRenderer,
                                              IHXValues*   pInfo);
    HX_RESULT            closeOldRenderers(BOOL bAll);
    HX_RESULT            addOldRendererHideEvents(UINT16 uGroupIndex);
    void                 removeSourcemap(SMILPlayToAssoc* pPlayToAssoc);
    HX_RESULT            insertEvent(CSmilLayoutEvent* pEvent);
    CSmilShowSiteEvent*  getShowHideEvent(const char* pszMediaID,
                                          const char* pszRegionID,
                                          BOOL        bShowEvent);
#if defined(HELIX_FEATURE_SMIL2_ANIMATION)
    void                 doAnimation(CSmilAnimateInfo* pInfo, UINT32 ulTime);
    HX_RESULT            getUnderlyingValue(CSmilAnimateInfo* pInfo, REF(CAttr*) rpValue);
    HX_RESULT            getDependentValue(CSmilAnimateInfo* pInfo, REF(CAttr*) rpDepend);
    HX_RESULT            setValue(CSmilAnimateInfo* pInfo, CAttr* pValue,
                                  CAttr* pDepend, BOOL bUnderlyingValue = FALSE);
    void                 removeActiveAnimations();
    CSmilAnimateEvent*   getAnimateEvent(CSmilAnimateElement* pAnim);
#endif /* #if defined(HELIX_FEATURE_SMIL2_ANIMATION) */
    void                 removeEvent(CSmilLayoutEvent* pEvent);
    HX_RESULT            insertSiteInfo(void* pInfo);
    void                 removeSiteInfo(SMILSiteInfo* pSiteInfo);
    void                 removeGroupEvents(UINT16 uGroupIndex);
    BOOL                 draw(HXxEvent* pEvent, IHXSite* pSite, UINT32 ulBgColor);
    HX_RESULT            insertIntoZOrderList(CHXSimpleList* pList,
                                              SMILSiteInfo*  pSiteInfo);
    HX_RESULT            setRendererZOrder(SMILSiteInfo* pSiteInfo);
    HX_RESULT            handleElements();
    HX_RESULT            postParseSetup();
    void                 setProperty(IHXValues* pValues, 
                                     const char* pName, 
                                     const char* pValue);
    HX_RESULT            parseDimension(const char* pDimensionString,
                                        REF(UINT32) ulValue,
                                        REF(BOOL)   bIsPercent);
    HX_RESULT            computeBoxDimension(CSmilBasicBox* pBox, BoxDimension eDim);
    void                 clearResolvedFlags(CSmilBasicBox* pBox);
    void                 resetSites(CSmilBasicBox* pBox, BOOL bOptimizeRedraws);
    void                 resizeTopLevelBox(CSmilBasicBox* pBox, HXxSize cOrigSize, HXxSize cSize);
    void                 zoomRect(CSmilBasicBox* pBox, double dScaleX, double dScaleY);
    void                 recomputeBoxLayout(CSmilBasicBox* pBox, BOOL bOptimizeRedraws);
    BOOL                 isMediaPausedAndDisabled(const char* pID);
    BOOL                 reenablePausedAndDisabledMedia(const char* pID,
                                UINT16 iGroupIndex);

    CSmilAAnchorElement* findHyperlinkElement(const char* pRegionID,
                                              const char* pMediaID,
                                              UINT16      uXPos,
                                              UINT16      uYPos,
                                              BOOL        bResolveTargetBeginIfFragment = FALSE);
    CSmilElement*        findIfCurElementHasAltOrLongdesc(const char* pID,
                                            UINT16 ulXPos, UINT16 ulYPos);
    HX_RESULT            convertURL(const char* pszBaseRoot, const char* pszBasePrefix,
                                    const char* pURL, CHXString& newURL);
    HX_RESULT            doSourceUpdate(SMILPlayToAssoc*   pPlayToAssoc,
                                        CSmilSourceUpdate* pUpdateElement);
    HX_RESULT            updateStreamTiming(const char* pElementID,
                                            UINT32      ulDuration);
    HX_RESULT            updateStreamDelay(UINT16 uGroupIndex, UINT32 ulDelay);
    HX_RESULT            updateSiteEvents(UINT16 uGroupIndex);
    HX_RESULT            seekTo(const char* pElementID);
    HX_RESULT            setRegionParentChild(CSmilBasicRegion* pRegion);
    HX_RESULT            createRegionSites(CHXSimpleList* pChildList);
    HX_RESULT            createRegionSite(CSmilBasicRegion* pRegion);
    void                 destroyRegionSites(CHXSimpleList* pChildList);
    CSmilBasicRegion*    getRegionByName(const char* pszName);
    void                 RemoveEvents(UINT32 ulGroupIndex, IHXSite* pSite);
    HX_RESULT            flushAllEvents(UINT32 ulFlushToTime, BOOL bBreak = FALSE);
    HX_RESULT            flushAllEvents () { return flushAllEvents(m_ulCurrentTime); }
    BOOL                 IsFullScreen();
    BOOL                 isAttributeAnimated(const char* pszElementID, UINT32 ulAttrName);
    BOOL                 isRegionBackgroundColorOverridden(CSmilBasicRegion* pRegion);
#if defined(HELIX_FEATURE_SMIL2_ANIMATION)
    void                 startSoundLevelAnimation(CSmilAnimateInfo* pInfo);
    void                 finishSoundLevelAnimation(CSmilAnimateInfo* pInfo,
                                                   BOOL bUseCurrentLevel = FALSE);
    CSmilAnimateElement* getFirstAnimationElement(const char* pszElementID, UINT32 ulAttrName);
    CSmilAnimateElement* getNextAnimationElement(const char* pszElementID, UINT32 ulAttrName);
#endif /* #if defined(HELIX_FEATURE_SMIL2_ANIMATION) */
    BOOL                 getGroupDuration(UINT16 usGroupIndex, REF(UINT32) rulDuration);
    HX_RESULT            getTrack(UINT16 uGroupIndex, UINT16 uTrackIndex, REF(IHXTrack*) rpTrack);
    void                 forceFullRedraw(IHXSite* pSite);
    void                 forceFullRecursiveRedraw(CSmilBasicBox* pBox);
    void                 destroyRendererSites(CSmilBasicBox* pBox);
    HX_RESULT            setupRootLayout(BOOL bAssignDefaults);
#if defined(HELIX_FEATURE_SMIL2_MULTIWINDOWLAYOUT)
    HX_RESULT            setupViewports();
    HX_RESULT            finishOneViewportSetup(CSmilBasicViewport* pPort);
    HX_RESULT            setupViewportsDone(HX_RESULT status);
    void                 closeViewports();
    void                 showHideViewport(const char* pszID, BOOL bShow);
    void                 showHideViewport(CSmilBasicViewport* pPort, BOOL bShow);
#ifdef XXXMEH_DO_VIEWPORT_TLC
    void                 clearViewportMap();
#endif
#endif /* #if defined(HELIX_FEATURE_SMIL2_MULTIWINDOWLAYOUT) */
    void                 destroyRegions(CHXSimpleList* pChildList);
    void                 destroyAllRegions();
    void                 setElementRemoveTime(const char* pszID, UINT32 ulRemoveTime);
#if defined(_UNIX) && (!(defined(_BEOS))) && (!(defined(_MAC_UNIX)))
    XData*               InitXVisualSupport(IHXSite* pSite, HXxWindow* pWnd);
#endif
#if defined(_DEBUG)
    void                 DumpEventQueue();
    void                 DumpZOrder(CSmilBasicBox* pBox, UINT32 ulIndentLevel);
    void                 DumpAllGroupInfo(UINT32 ulTime);
    void                 DumpAllProperties(IHXValues* pValues, UINT32 ulNumTabIndent);
    void                 DumpAllSiteInfo(const char* pszFileName, UINT32 ulTime);
    void                 DumpBoxSiteInfo(CSmilBasicBox* pBox, FILE* fp, UINT32 ulIndentLevel);
#endif
    HX_RESULT            getMediaIDFromSite(IHXSite* pSite, REF(CHXString) rcStr);
    CExternalMediaMarkerInfo* getExternalMediaMarkerInfo(const char* pszURL);
    BOOL                      isIDMappedToExternalMediaMarkerFile(CExternalMediaMarkerInfo* pInfo,
                                                                  const char*               pszID);
    void                      deleteExternalMediaMarkerList();
    void                      queueSiteForAnimationRedraw(IHXSite* pSite);
    void                      queueRegionForRecompute(CSmilBasicRegion* pRegion);
    void                      removePendingAnimationRedraw(IHXSite* pSite);
    void                      turnSiteCompositionModeON();
    void                      turnSiteCompositionModeOFF();
    void                      lockSiteComposition();
    void                      unlockSiteComposition();
    void                      bltSiteComposition();
    BOOL                      isSiteCompositionLocked();
    BOOL                      isSiteCompositionModeON();
    void                      GoToURLWithParamCheck(const char*        pszURL,
                                                    const char*        pszTarget,
                                                    const char*        pszSendTo,
                                                    IHXHyperNavigate* pHyper,
                                                    CSmilElement*      pElement,
                                                    IUnknown*          pContext,
                                                    BOOL               bUserInvoked,
                                                    BOOL               bHint = FALSE);
    UINT16                    getCurrentGroup();
    HX_RESULT                 InitPersistent(UINT32                   ulPersistentComponentID,
                                             UINT16                   uPersistentGroupID,
                                             UINT16                   uPersistentTrackID,
                                             IHXPersistentRenderer*  pPersistentParent);
    BOOL                      IsNestedMetaSupported(void);
    void                      PersistentDurationSet(UINT32 ulDuration, UINT32 ulDelay, BOOL bIsLive);
    FillType                  getMediaFillBehavior(const char* pszID);
    BOOL                      atLeastOneActiveAnimation(UINT32 ulTime);
    void                      clearAllEventHandledFlags();
    HX_RESULT                 setRendererULONG32Property(const char* pszMediaID,
                                                         const char* pszName,
                                                         UINT32      ulValue,
                                                         REF(BOOL)   rbSetNewValue);
    HX_RESULT                 setRendererCStringProperty(const char* pszMediaID,
                                                         const char* pszName,
                                                         const char* pszValue,
                                                         REF(BOOL)   rbSetNewValue);
    void                      addRemoveMediaMarkerSink(BOOL bAdd);
    void                      addRemoveEventSink(BOOL bAdd);
    void                      addRemoveErrorSink(BOOL bAdd);
    void                      addEventSinkFilterRule(const char*    pszURL,
                                                     const char*    pszFragment,
                                                     const char*    pszEventName,
                                                     IHXEventSink* pSink = NULL);
    HX_RESULT                 getEventSink(const char*         pszID,
                                           REF(IHXEventSink*) rpEventSink);
    HX_RESULT                 addRemoveEventSink(const char* pszID, BOOL bAdd);
    void                      removeAllEventSinks();
    HX_RESULT                 setupEventPipe(const char* pszSrcID,
                                             const char* pszDstID,
                                             const char* pszEventName);
    void                      SendHyperlinkHints();
    void                      HintHyperlinkNodeRecurse(SMILNode* pNode);
    void                      HintHyperlinkNode(CSmilAAnchorElement* pAnchor);

    void                      CleanUpSiteInfoContainers();


    // CSmilDocumentRenderer private members
    CSmilRenderer*          m_pParent;
    CSmilParser*            m_pSmilParser;
    HX_RESULT               m_ulParseResult;
    IHXScheduler*          m_pScheduler;
    char*                   m_pFragment;
    CHXMapStringToOb*       m_pRegionMap;
    CSmilBasicRootLayout*   m_pRootLayout;
    CHXSimpleList*          m_pViewportList;
    CHXMapStringToOb*       m_pRegPointMap;
#if defined(HELIX_FEATURE_SMIL2_TRANSITIONS)
    CHXMapStringToOb*       m_pTransitionMap;
#endif /* #if defined(HELIX_FEATURE_SMIL2_TRANSITIONS) */
    CHXMapPtrToPtr*         m_pSiteInfoByRendererMap;
    CHXMapPtrToPtr*         m_pSiteWatcherMap;
    CHXMapLongToObj*        m_pGroupInfoMap;
    CHXMapLongToObj*        m_pGroupMap;
    CHXMapStringToOb*       m_pDeferredSourceMap;
    CHXMapStringToOb*       m_pPausedAndDisabledIDMap;
    CHXMapStringToOb*       m_pPausedAndDisabledBrightnessMap;
    CHXMapLongToObj*        m_pPrefetchTrackElementMap;
    CHXSimpleList*          m_pSiteInfoList;
    CHXSimpleList*          m_pPlayToAssocList;
    CHXSimpleList*          m_pEventList;
    CHXSimpleList*          m_pZOrderList;
    CHXSimpleList*          m_pDelayedRendererCloseList;
    LISTPOSITION            m_ulEventListPosition;
    INT16                   m_uCurrentGroupIndex;
    INT16                   m_nFragmentTracks;
    UINT32                  m_ulCurrentTime;
    LONG32                  m_lRefCount;
    IUnknown*               m_pContext;
    IHXSiteManager*        m_pSiteMgr;
    IHXStatusMessage*      m_pStatusMessage;
    ULONG32                 m_ulFragmentTimeOffset;
    double                  m_dResizeXScale;
    double                  m_dResizeYScale;
    CHXSimpleList*          m_pActiveTransitions;
    CHXSimpleList*          m_pActiveAnimations;
    POSITION                m_pRegionMapIterator;
    CHXMapStringToOb*       m_pAnimationMap;
    IHXLayoutStream*       m_pPersistentLayoutStream;
    UINT32                  m_ulNoLayoutRendererCount;
    IHXErrorMessages*      m_pErrorMessages;
    UINT32                  m_ulGroupIndex;
    UINT32                  m_ulTrackIndex;
    UINT16                  m_uGroupIndexWithin;
    IHXBuffer*             m_pSMILDefaultNamespaceStr;
    IHXViewPortManager*    m_pViewPortManager;
    HandlePendingSchedulingCallback* m_pHandlePendingSchedulingCallback;
    CHyperlinkCallback*     m_pHyperlinkCallback;
    HXxSize                 m_topSiteSize;
    HXxSize                 m_topSiteOriginalSize;
#ifdef XXXMEH_DO_VIEWPORT_TLC
    CHXMapStringToOb*       m_pViewPortSiteMap;
#endif
#if defined(_WINDOWS)
    HCURSOR                 m_hHyperlinkCursor;
    HCURSOR                 m_hPreHyperlinkCursor;
#elif defined(_MACINTOSH) || defined(_MAC_UNIX)
    CursHandle              m_hHyperlinkCursor;
    CResourceLoader*        m_pResourceLoader;
#elif defined(_UNIX) && (!(defined(_BEOS))) && (!(defined(_MAC_UNIX)))
    XVisualInfo*            m_pVisualInfo;
    Cursor                  m_hHyperlinkCursor;
    Cursor                  m_hCurrentCursor;
    Display*                m_pDisplay;          
    Window                  m_Window;
    Display*                m_pPixmapDisplay;
    CHXMapPtrToPtr          m_siteToXDataMap;
#endif
    UINT32                  m_ulPersistentComponentID;
    UINT16                  m_uPersistentGroupID;
    UINT16                  m_uPersistentTrackID;
    IHXValues*             m_pPersistentProperties;
    IHXPersistentRenderer* m_pPersistentParentRenderer;
    CHXSimpleList*          m_pExternalMediaMarkerList;
    POSITION                m_AnimationIterator;
    CHXMapPtrToPtr*         m_pAnimSiteRedrawMap;
    CHXMapPtrToPtr*         m_pAnimRegionRecomputeMap;
    CHXMapPtrToPtr*         m_pAnimTopLayoutMap;
    UINT16                  m_usAnimBaseGroupIndex;
    UINT32                  m_ulAnimDuration;
    UINT32                  m_ulCurGroupDuration;
    IHXMutex*              m_pSoundLevelMutex;
    CHXMapStringToOb*       m_pMediaID2RendererMap;
    CHXMapStringToOb*       m_pMediaID2RendererSiteMap;
    CHXMapStringToOb*       m_pMediaID2RendererSiteWatcherMap;
    CHXMapStringToOb*       m_pDeferrededRemoveTrackMap;
    CHXSimpleList*          m_pEventSinkList;
    UINT32                  m_ulPktnum;
    UINT16                  m_usOldXPos;
    UINT16                  m_usOldYPos;
    // ONLY HX_BITFIELD MEMBERS SHOULD GO BELOW THIS LINE!
    // ALL OTHER MEMBER TYPES SHOULD GO ABOVE THIS LINE!
    HX_BITFIELD             m_bFirstTimeSync : 1;
    HX_BITFIELD             m_bSettingFragment : 1;
    HX_BITFIELD             m_bFragFoundAndResolved : 1;
    HX_BITFIELD             m_bInHyperlink : 1;
    HX_BITFIELD             m_bSiteLayoutComplete : 1;
    HX_BITFIELD             m_bStatusMessageSet : 1;
    HX_BITFIELD             m_bMetadataPassedOffAlready : 1;
    HX_BITFIELD             m_bIsRootLayoutSetup : 1;
    HX_BITFIELD             m_bSMILPresentationHasEnded : 1;
    HX_BITFIELD             m_bSitesDetached : 1;
    HX_BITFIELD             m_bLayoutElementPresent : 1;
    HX_BITFIELD             m_bEmptyLayout : 1;
    HX_BITFIELD             m_bDoNotZoom : 1;
    HX_BITFIELD             m_bAnimateRootLayout : 1;
    HX_BITFIELD             m_bCloseCalled : 1;
    HX_BITFIELD             m_bRootLayoutSiteDetached : 1;
    HX_BITFIELD             m_bInTrackDurationSetCall : 1;
    HX_BITFIELD             m_bEventSinkWasSetup : 1;
    HX_BITFIELD             m_bDestPlaystateIsPause : 1;
#ifdef XXXMEH_DO_VIEWPORT_TLC
    HX_BITFIELD             m_bSMILViewportClose : 1;
#endif
#if defined(_WINDOWS)
    HX_BITFIELD             m_bNeedToSetHyperlinkCursor : 1;
#elif defined(_MACINTOSH) || defined(_MAC_UNIX)
    HX_BITFIELD             m_bResetCursor : 1;
#endif
};

inline BOOL CSmilDocumentRenderer::isTransparent(UINT32 ulColor) const
{
    BOOL bRet = FALSE;

    if ((ulColor & 0xFF000000) == 0xFF000000)
    {
        bRet = TRUE;
    }

    return bRet;
}

#endif
