/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: ppffstrm.h,v 1.2.30.1 2004/07/19 21:04:16 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#ifndef _PPFFSTRM_H_
#define _PPFFSTRM_H_

class CPurePlayFileFormat;
class ReceptionReport;
class CPurePlaySource;

#include "ntptime.h"
#include "packetq.h"
#include "tconverter.h"
#include "rtpclsnc.h"

class CMember
{
public:
    CMember();
    CMember(CPurePlaySource* pSrc, UINT32 ulSsrc);
    ~CMember();

    CPurePlaySource*	m_pSrc;   
    UINT32		m_ulSSRC; // Id
    BinInfo		m_binInfo;
    CHXString*		m_pCName;
    CHXString*		m_pName;
    CHXString*		m_pTool;
    CHXString*		m_pEmail;
    CHXString*		m_pPhone;
    CHXString*		m_pLoc;	  // geographic location
    CHXString*		m_pNote;
    CHXString*		m_pPriv;  // private extensionss
};


class CStream : public CMember
{
public:
	typedef enum
	{
	    STREAM_TYPE_VIDEO,
	    STREAM_TYPE_AUDIO,
	    STREAM_TYPE_EVENT,
	    STREAM_TYPE_IMGMAP,
	    STREAM_TYPE_OTHER
	} StreamType;

	CStream(CPurePlaySource* pSrc, 
		UINT32 ulSsrc, 
		UINT16 unSeq, 
		ULONG32 ulHXAFactor,
		ULONG32 ulRTPFactor,
		IHXCommonClassFactory* pFactory,
		BOOL bIsSyncMaster = FALSE);
	~CStream();

	void	Init();
	void	InitSeqNum(UINT16 unSeq);
	BOOL	UpdateSeqNum(UINT16 unSeq, ULONG32 ulRTPTS);
	BOOL	GetReceptionReport(REF(ReceptionReport) rr);	// used for RR
	UINT16	GetPercentDone();
	BOOL    MarkAsEnd();
	BOOL	IsMarkedAsEnd() { return m_bMarkedAsEnd; }
	void	SetStats(ULONG32 ulPacketTime, ULONG32 ulPacketSize);
	void	UpdateStatistics(IHXRegistry* pReg, ULONG32 ulTimeNow);
	void	SetMinTransportWindowSize(INT32 lSize);

	BOOL	IsRMStream		    (void);
	StreamType GetStreamtype	    (void);
	
	inline void	    SequentializeRMATS(ULONG32& ulHXTime);
    	inline HX_RESULT    GetPacket	    (REF(IHXPacket*) pPacket,
					     ULONG32 ulTimeNow);
    	inline UINT32	    GetLastHXTime  (void);
    	inline void	    SetLastHXTime  (UINT32 unTime);
	inline void	    SetPendingFlag  (BOOL bPending) { m_bPending = bPending; }
	inline BOOL	    GetPendingFlag  (void)	    { return m_bPending; }
	inline BOOL	    IsInProbation   (void)	    { return (m_ulProbation > 0); }

	inline HX_RESULT    GetNextTS	    (REF(UINT32)ulTS,
					     ULONG32 ulTimeNow);
	inline ULONG32	    GetBufferedPacketCount(void);
	inline ULONG32	    GetBufferAge(ULONG32 ulTimeNow);
	
	inline BOOL	    IsBufferFlexible(void);
	inline void	    SetBufferFlexible(BOOL bIsFlexible);

#ifdef XXXGo_DEBUG
	FILE*   m_pLogFile;
#endif
	CPurePlaySource* m_pSrc;
	UINT16	m_unMaxSeq;			// highest seq# seen
	UINT32	m_ulCycles;			// shifted count of seq#
	UINT32	m_ulBaseSeq;		// base seq#
	UINT32	m_ulBadSeq;			// last 'bad' seq# - 1
	UINT32	m_ulProbation;		// seq packets till source is valid
	UINT32	m_ulReceived;		// packets received
	UINT32	m_ulExpectedPrior;	// pkt expected at last interval
	UINT32	m_ulReceivedPrior;	// pkt received at last interval
	UINT32	m_ulTransit;		// relative trans time for prev pkt
	UINT32	m_ulJitter;			// estimated jitter
	
	UINT32	m_ulSSRC;		// synchronization source id
	UINT32 	m_ulLSR;		// last SR timestamp
	UINT32  m_ulLastSRArrivalTime;  // used to calc. delay since last SR 

	BOOL 	m_bInitialPkt;
	UINT32  m_ulInitialRTPTime;
	UINT32  m_ulStartTimeMS;
	UINT16  m_unStreamNum;
	CHXTimestampConverter* m_pMasterTSConverter;
	
	// time synchronization and tracking
	CRTPClientStreamSync m_Syncer;
	ULONG32 m_ulLastRawRTPTS;
	ULONG32 m_ulLastRTPTS;
	ULONG32 m_ulLastHXTS;
	ULONG32* m_pLastHXSentRcvdPair;
	
	PacketQueue* m_pTransBuf;
	BOOL	m_bHeardSinceLastTime;
	UINT32  m_ulNumRRIntervals;
	BOOL	m_bPending;
	UINT32  m_ulLastHXTime;
	UINT32  m_ulLost;

	BOOL    m_bMarkedAsEnd;
	BOOL	m_bMadeCut;
    
	UINT32	m_ulClipBandwidthID;	
	double	m_fTotalBytesRecv;
	UINT32  m_ulStatBytesRecv;
	UINT32  m_ulStatStartMS;

	UINT32  m_ulNormal;
	// for stream stats
	UINT32	m_ulStreamRegId;		
};

/******************************************************************************
 *	Inline functions
 */
inline HX_RESULT
CStream::GetPacket(REF(IHXPacket*) pPacket, ULONG32 ulTimeNow)
{
    return m_pTransBuf->GetPacket(pPacket, ulTimeNow);
}


inline UINT32
CStream::GetLastHXTime()
{
    return m_ulLastHXTime;
}

inline void
CStream::SetLastHXTime(UINT32 unTime)
{
    m_ulLastHXTime = unTime;
}

inline HX_RESULT    
CStream::GetNextTS(REF(UINT32)ulTS, ULONG32 ulTimeNow)
{
    return m_pTransBuf->GetNextTS(ulTS, ulTimeNow);
}

inline ULONG32 
CStream::GetBufferedPacketCount(void)
{
    return m_pTransBuf->GetQueuedPktCount();
}

inline ULONG32 
CStream::GetBufferAge(ULONG32 ulTimeNow)
{
    return m_pTransBuf->GetAge(ulTimeNow);
}

inline void
CStream::SequentializeRMATS(ULONG32& ulHXTime)
{
    if (m_pLastHXSentRcvdPair)
    {
	if (((LONG32) (ulHXTime - m_pLastHXSentRcvdPair[0])) > 0)
	{
	    m_pLastHXSentRcvdPair[0] = ulHXTime;
	    m_pLastHXSentRcvdPair[1] = ulHXTime;
	    return;
	}
	else if (ulHXTime == m_pLastHXSentRcvdPair[1])
	{
	    ulHXTime = m_pLastHXSentRcvdPair[0];
	    return;
	}
	else
	{
	    m_pLastHXSentRcvdPair[1] = ulHXTime;
	    ulHXTime = (++(m_pLastHXSentRcvdPair[0]));
	    return;
	}
    }

    m_pLastHXSentRcvdPair = new ULONG32 [2];
    if (m_pLastHXSentRcvdPair)
    {
	m_pLastHXSentRcvdPair[0] = ulHXTime;
	m_pLastHXSentRcvdPair[1] = ulHXTime;
    }
}

inline BOOL
CStream::IsBufferFlexible(void)
{
    return m_pTransBuf->IsFlexTimeWindow();
}

inline void
CStream::SetBufferFlexible(BOOL bIsFlexible)
{
    m_pTransBuf->SetFlexTimeWindow(bIsFlexible);
}

#endif	// _PPFFSTRM_H_
