// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v0/resources/media_file.proto

package resources // import "google.golang.org/genproto/googleapis/ads/googleads/v0/resources"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"
import enums "google.golang.org/genproto/googleapis/ads/googleads/v0/enums"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// A media file.
type MediaFile struct {
	// The resource name of the media file.
	// Media file resource names have the form:
	//
	// `customers/{customer_id}/mediaFiles/{media_file_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The ID of the media file.
	Id *wrappers.Int64Value `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// Type of the media file.
	Type enums.MediaTypeEnum_MediaType `protobuf:"varint,5,opt,name=type,proto3,enum=google.ads.googleads.v0.enums.MediaTypeEnum_MediaType" json:"type,omitempty"`
	// The mime type of the media file.
	MimeType enums.MimeTypeEnum_MimeType `protobuf:"varint,6,opt,name=mime_type,json=mimeType,proto3,enum=google.ads.googleads.v0.enums.MimeTypeEnum_MimeType" json:"mime_type,omitempty"`
	// The URL of where the original media file was downloaded from (or a file
	// name).
	SourceUrl *wrappers.StringValue `protobuf:"bytes,7,opt,name=source_url,json=sourceUrl,proto3" json:"source_url,omitempty"`
	// The name of the media file. The name can be used by clients to help
	// identify previously uploaded media.
	Name *wrappers.StringValue `protobuf:"bytes,8,opt,name=name,proto3" json:"name,omitempty"`
	// The size of the media file in bytes.
	FileSize *wrappers.Int64Value `protobuf:"bytes,9,opt,name=file_size,json=fileSize,proto3" json:"file_size,omitempty"`
	// The specific type of the media file.
	//
	// Types that are valid to be assigned to Mediatype:
	//	*MediaFile_Image
	//	*MediaFile_MediaBundle
	Mediatype            isMediaFile_Mediatype `protobuf_oneof:"mediatype"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *MediaFile) Reset()         { *m = MediaFile{} }
func (m *MediaFile) String() string { return proto.CompactTextString(m) }
func (*MediaFile) ProtoMessage()    {}
func (*MediaFile) Descriptor() ([]byte, []int) {
	return fileDescriptor_media_file_8d950f5477004c2c, []int{0}
}
func (m *MediaFile) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MediaFile.Unmarshal(m, b)
}
func (m *MediaFile) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MediaFile.Marshal(b, m, deterministic)
}
func (dst *MediaFile) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MediaFile.Merge(dst, src)
}
func (m *MediaFile) XXX_Size() int {
	return xxx_messageInfo_MediaFile.Size(m)
}
func (m *MediaFile) XXX_DiscardUnknown() {
	xxx_messageInfo_MediaFile.DiscardUnknown(m)
}

var xxx_messageInfo_MediaFile proto.InternalMessageInfo

func (m *MediaFile) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *MediaFile) GetId() *wrappers.Int64Value {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *MediaFile) GetType() enums.MediaTypeEnum_MediaType {
	if m != nil {
		return m.Type
	}
	return enums.MediaTypeEnum_UNSPECIFIED
}

func (m *MediaFile) GetMimeType() enums.MimeTypeEnum_MimeType {
	if m != nil {
		return m.MimeType
	}
	return enums.MimeTypeEnum_UNSPECIFIED
}

func (m *MediaFile) GetSourceUrl() *wrappers.StringValue {
	if m != nil {
		return m.SourceUrl
	}
	return nil
}

func (m *MediaFile) GetName() *wrappers.StringValue {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *MediaFile) GetFileSize() *wrappers.Int64Value {
	if m != nil {
		return m.FileSize
	}
	return nil
}

type isMediaFile_Mediatype interface {
	isMediaFile_Mediatype()
}

type MediaFile_Image struct {
	Image *MediaImage `protobuf:"bytes,3,opt,name=image,proto3,oneof"`
}

type MediaFile_MediaBundle struct {
	MediaBundle *MediaBundle `protobuf:"bytes,4,opt,name=media_bundle,json=mediaBundle,proto3,oneof"`
}

func (*MediaFile_Image) isMediaFile_Mediatype() {}

func (*MediaFile_MediaBundle) isMediaFile_Mediatype() {}

func (m *MediaFile) GetMediatype() isMediaFile_Mediatype {
	if m != nil {
		return m.Mediatype
	}
	return nil
}

func (m *MediaFile) GetImage() *MediaImage {
	if x, ok := m.GetMediatype().(*MediaFile_Image); ok {
		return x.Image
	}
	return nil
}

func (m *MediaFile) GetMediaBundle() *MediaBundle {
	if x, ok := m.GetMediatype().(*MediaFile_MediaBundle); ok {
		return x.MediaBundle
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*MediaFile) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _MediaFile_OneofMarshaler, _MediaFile_OneofUnmarshaler, _MediaFile_OneofSizer, []interface{}{
		(*MediaFile_Image)(nil),
		(*MediaFile_MediaBundle)(nil),
	}
}

func _MediaFile_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*MediaFile)
	// mediatype
	switch x := m.Mediatype.(type) {
	case *MediaFile_Image:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Image); err != nil {
			return err
		}
	case *MediaFile_MediaBundle:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MediaBundle); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("MediaFile.Mediatype has unexpected type %T", x)
	}
	return nil
}

func _MediaFile_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*MediaFile)
	switch tag {
	case 3: // mediatype.image
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MediaImage)
		err := b.DecodeMessage(msg)
		m.Mediatype = &MediaFile_Image{msg}
		return true, err
	case 4: // mediatype.media_bundle
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(MediaBundle)
		err := b.DecodeMessage(msg)
		m.Mediatype = &MediaFile_MediaBundle{msg}
		return true, err
	default:
		return false, nil
	}
}

func _MediaFile_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*MediaFile)
	// mediatype
	switch x := m.Mediatype.(type) {
	case *MediaFile_Image:
		s := proto.Size(x.Image)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MediaFile_MediaBundle:
		s := proto.Size(x.MediaBundle)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Encapsulates an Image.
type MediaImage struct {
	// Raw image data.
	Data                 *wrappers.BytesValue `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *MediaImage) Reset()         { *m = MediaImage{} }
func (m *MediaImage) String() string { return proto.CompactTextString(m) }
func (*MediaImage) ProtoMessage()    {}
func (*MediaImage) Descriptor() ([]byte, []int) {
	return fileDescriptor_media_file_8d950f5477004c2c, []int{1}
}
func (m *MediaImage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MediaImage.Unmarshal(m, b)
}
func (m *MediaImage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MediaImage.Marshal(b, m, deterministic)
}
func (dst *MediaImage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MediaImage.Merge(dst, src)
}
func (m *MediaImage) XXX_Size() int {
	return xxx_messageInfo_MediaImage.Size(m)
}
func (m *MediaImage) XXX_DiscardUnknown() {
	xxx_messageInfo_MediaImage.DiscardUnknown(m)
}

var xxx_messageInfo_MediaImage proto.InternalMessageInfo

func (m *MediaImage) GetData() *wrappers.BytesValue {
	if m != nil {
		return m.Data
	}
	return nil
}

// Represents a ZIP archive media the content of which contains HTML5 assets.
type MediaBundle struct {
	// Raw zipped data.
	Data                 *wrappers.BytesValue `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *MediaBundle) Reset()         { *m = MediaBundle{} }
func (m *MediaBundle) String() string { return proto.CompactTextString(m) }
func (*MediaBundle) ProtoMessage()    {}
func (*MediaBundle) Descriptor() ([]byte, []int) {
	return fileDescriptor_media_file_8d950f5477004c2c, []int{2}
}
func (m *MediaBundle) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MediaBundle.Unmarshal(m, b)
}
func (m *MediaBundle) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MediaBundle.Marshal(b, m, deterministic)
}
func (dst *MediaBundle) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MediaBundle.Merge(dst, src)
}
func (m *MediaBundle) XXX_Size() int {
	return xxx_messageInfo_MediaBundle.Size(m)
}
func (m *MediaBundle) XXX_DiscardUnknown() {
	xxx_messageInfo_MediaBundle.DiscardUnknown(m)
}

var xxx_messageInfo_MediaBundle proto.InternalMessageInfo

func (m *MediaBundle) GetData() *wrappers.BytesValue {
	if m != nil {
		return m.Data
	}
	return nil
}

func init() {
	proto.RegisterType((*MediaFile)(nil), "google.ads.googleads.v0.resources.MediaFile")
	proto.RegisterType((*MediaImage)(nil), "google.ads.googleads.v0.resources.MediaImage")
	proto.RegisterType((*MediaBundle)(nil), "google.ads.googleads.v0.resources.MediaBundle")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v0/resources/media_file.proto", fileDescriptor_media_file_8d950f5477004c2c)
}

var fileDescriptor_media_file_8d950f5477004c2c = []byte{
	// 503 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x54, 0x5d, 0x6b, 0xd4, 0x40,
	0x14, 0x6d, 0xd2, 0xb4, 0x6e, 0x66, 0x6b, 0x1f, 0xe6, 0x29, 0x54, 0x91, 0xed, 0x8a, 0xb0, 0x20,
	0x9d, 0x84, 0xb5, 0x14, 0xa1, 0x28, 0x6c, 0xa0, 0xf6, 0x03, 0x94, 0x9a, 0xd5, 0x7d, 0x90, 0x85,
	0x65, 0xb6, 0xb9, 0x0d, 0x03, 0x99, 0x24, 0xcc, 0x24, 0x95, 0xed, 0xcf, 0xf1, 0xd1, 0x9f, 0xe2,
	0x83, 0x2f, 0xfe, 0x21, 0x99, 0x99, 0x24, 0x5b, 0xd0, 0x9a, 0xfa, 0x76, 0xef, 0xee, 0x39, 0xe7,
	0x9e, 0x73, 0x73, 0x13, 0x34, 0x4e, 0xf2, 0x3c, 0x49, 0xc1, 0xa7, 0xb1, 0xf4, 0x4d, 0xa9, 0xaa,
	0x9b, 0xc0, 0x17, 0x20, 0xf3, 0x4a, 0x5c, 0x81, 0xf4, 0x39, 0xc4, 0x8c, 0x2e, 0xae, 0x59, 0x0a,
	0xa4, 0x10, 0x79, 0x99, 0xe3, 0x7d, 0x03, 0x24, 0x34, 0x96, 0xa4, 0xe5, 0x90, 0x9b, 0x80, 0xb4,
	0x9c, 0x3d, 0x72, 0x9f, 0x2c, 0x64, 0x15, 0x6f, 0x24, 0xcb, 0x55, 0x51, 0x4b, 0xee, 0x1d, 0x74,
	0xe0, 0x19, 0x87, 0xbb, 0xf0, 0x67, 0x35, 0x5c, 0x77, 0xcb, 0xea, 0xda, 0xff, 0x2a, 0x68, 0x51,
	0x80, 0x90, 0xe6, 0xff, 0xe1, 0x4f, 0x07, 0xb9, 0xef, 0xd5, 0x8c, 0x77, 0x2c, 0x05, 0xfc, 0x1c,
	0x3d, 0x6e, 0x9c, 0x2d, 0x32, 0xca, 0xc1, 0xb3, 0x06, 0xd6, 0xc8, 0x8d, 0x76, 0x9a, 0x1f, 0x3f,
	0x50, 0x0e, 0xf8, 0x25, 0xb2, 0x59, 0xec, 0xd9, 0x03, 0x6b, 0xd4, 0x1f, 0x3f, 0xa9, 0xed, 0x93,
	0x46, 0x9f, 0x9c, 0x67, 0xe5, 0xd1, 0xe1, 0x8c, 0xa6, 0x15, 0x44, 0x36, 0x8b, 0xf1, 0x05, 0x72,
	0x94, 0x1b, 0x6f, 0x6b, 0x60, 0x8d, 0x76, 0xc7, 0x47, 0xe4, 0xbe, 0x85, 0x68, 0xf7, 0x44, 0x3b,
	0xf9, 0xb4, 0x2a, 0xe0, 0x24, 0xab, 0xf8, 0xba, 0x8b, 0xb4, 0x06, 0xfe, 0x88, 0xdc, 0x36, 0x9e,
	0xb7, 0xad, 0x05, 0x0f, 0xbb, 0x04, 0x19, 0x87, 0xb5, 0x5e, 0xdd, 0x44, 0x3d, 0x5e, 0x57, 0xf8,
	0x18, 0xa1, 0x3a, 0x6e, 0x25, 0x52, 0xef, 0x91, 0xce, 0xf4, 0xf4, 0x8f, 0x4c, 0xd3, 0x52, 0xb0,
	0x2c, 0x31, 0xa1, 0x5c, 0x83, 0xff, 0x2c, 0x52, 0x1c, 0x20, 0x47, 0x2f, 0xa9, 0xf7, 0x00, 0x9a,
	0x46, 0xe2, 0xd7, 0xc8, 0x55, 0xd7, 0xb1, 0x90, 0xec, 0x16, 0x3c, 0xb7, 0x7b, 0x83, 0x3d, 0x85,
	0x9e, 0xb2, 0x5b, 0xc0, 0x27, 0x68, 0x8b, 0x71, 0x9a, 0x80, 0xb7, 0xa9, 0x59, 0x07, 0xa4, 0xf3,
	0xb2, 0xcc, 0xfa, 0xce, 0x15, 0xe9, 0x6c, 0x23, 0x32, 0x6c, 0x3c, 0x45, 0x3b, 0xe6, 0xa2, 0x96,
	0x55, 0x16, 0xa7, 0xe0, 0x39, 0x5a, 0x8d, 0x3c, 0x54, 0x2d, 0xd4, 0xac, 0xb3, 0x8d, 0xa8, 0xcf,
	0xd7, 0x6d, 0xd8, 0x47, 0xae, 0x6e, 0xd5, 0x73, 0x19, 0xbe, 0x41, 0x68, 0x3d, 0x18, 0xfb, 0xc8,
	0x89, 0x69, 0x49, 0xf5, 0x1d, 0xfd, 0x2d, 0x6b, 0xb8, 0x2a, 0x41, 0xd6, 0x1b, 0x52, 0xc0, 0xe1,
	0x5b, 0xd4, 0xbf, 0x33, 0xe9, 0xbf, 0xf9, 0xe1, 0x2f, 0x0b, 0xbd, 0xb8, 0xca, 0x79, 0x77, 0xa0,
	0x70, 0xb7, 0x3d, 0xfb, 0x4b, 0xa5, 0x76, 0x69, 0x7d, 0xb9, 0xa8, 0x49, 0x49, 0x9e, 0xd2, 0x2c,
	0x21, 0xb9, 0x48, 0xfc, 0x04, 0x32, 0x3d, 0xab, 0x79, 0xd5, 0x0a, 0x26, 0xff, 0xf1, 0x01, 0x38,
	0x6e, 0xab, 0x6f, 0xf6, 0xe6, 0xe9, 0x64, 0xf2, 0xdd, 0xde, 0x3f, 0x35, 0x92, 0x93, 0x58, 0x12,
	0x53, 0xaa, 0x6a, 0x16, 0x90, 0xa8, 0x41, 0xfe, 0x68, 0x30, 0xf3, 0x49, 0x2c, 0xe7, 0x2d, 0x66,
	0x3e, 0x0b, 0xe6, 0x2d, 0x66, 0xb9, 0xad, 0x4d, 0xbc, 0xfa, 0x1d, 0x00, 0x00, 0xff, 0xff, 0x31,
	0x9f, 0xe1, 0xeb, 0x84, 0x04, 0x00, 0x00,
}
