// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v0/resources/ad_group_criterion.proto

package resources // import "google.golang.org/genproto/googleapis/ads/googleads/v0/resources"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"
import common "google.golang.org/genproto/googleapis/ads/googleads/v0/common"
import enums "google.golang.org/genproto/googleapis/ads/googleads/v0/enums"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// An ad group criterion.
type AdGroupCriterion struct {
	// The resource name of the ad group criterion.
	// Ad group criterion resource names have the form:
	//
	// `customers/{customer_id}/adGroupCriteria/{ad_group_id}_{criterion_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The ID of the criterion.
	//
	// This field is ignored for mutates.
	CriterionId *wrappers.Int64Value `protobuf:"bytes,26,opt,name=criterion_id,json=criterionId,proto3" json:"criterion_id,omitempty"`
	// The status of the criterion.
	Status enums.AdGroupCriterionStatusEnum_AdGroupCriterionStatus `protobuf:"varint,3,opt,name=status,proto3,enum=google.ads.googleads.v0.enums.AdGroupCriterionStatusEnum_AdGroupCriterionStatus" json:"status,omitempty"`
	// Information regarding the quality of the criterion.
	QualityInfo *AdGroupCriterion_QualityInfo `protobuf:"bytes,4,opt,name=quality_info,json=qualityInfo,proto3" json:"quality_info,omitempty"`
	// The ad group to which the criterion belongs.
	AdGroup *wrappers.StringValue `protobuf:"bytes,5,opt,name=ad_group,json=adGroup,proto3" json:"ad_group,omitempty"`
	// The type of the criterion.
	Type enums.CriterionTypeEnum_CriterionType `protobuf:"varint,25,opt,name=type,proto3,enum=google.ads.googleads.v0.enums.CriterionTypeEnum_CriterionType" json:"type,omitempty"`
	// Whether to target (`false`) or exclude (`true`) the criterion.
	//
	// This field is immutable. To switch a criterion from positive to negative,
	// remove then re-add it.
	Negative *wrappers.BoolValue `protobuf:"bytes,31,opt,name=negative,proto3" json:"negative,omitempty"`
	// The modifier for the bid when the criterion matches. The modifier must be
	// in the range: 0.1 - 10.0. Most targetable criteria types support modifiers.
	BidModifier *wrappers.DoubleValue `protobuf:"bytes,44,opt,name=bid_modifier,json=bidModifier,proto3" json:"bid_modifier,omitempty"`
	// The CPC (cost-per-click) bid.
	CpcBidMicros *wrappers.Int64Value `protobuf:"bytes,16,opt,name=cpc_bid_micros,json=cpcBidMicros,proto3" json:"cpc_bid_micros,omitempty"`
	// The CPM (cost-per-thousand viewable impressions) bid.
	CpmBidMicros *wrappers.Int64Value `protobuf:"bytes,17,opt,name=cpm_bid_micros,json=cpmBidMicros,proto3" json:"cpm_bid_micros,omitempty"`
	// The CPV (cost-per-view) bid.
	CpvBidMicros *wrappers.Int64Value `protobuf:"bytes,24,opt,name=cpv_bid_micros,json=cpvBidMicros,proto3" json:"cpv_bid_micros,omitempty"`
	// The CPC bid amount, expressed as a fraction of the advertised price
	// for some good or service. The valid range for the fraction is [0,1) and the
	// value stored here is 1,000,000 * [fraction].
	PercentCpcBidMicros *wrappers.Int64Value `protobuf:"bytes,33,opt,name=percent_cpc_bid_micros,json=percentCpcBidMicros,proto3" json:"percent_cpc_bid_micros,omitempty"`
	// The effective CPC (cost-per-click) bid.
	EffectiveCpcBidMicros *wrappers.Int64Value `protobuf:"bytes,18,opt,name=effective_cpc_bid_micros,json=effectiveCpcBidMicros,proto3" json:"effective_cpc_bid_micros,omitempty"`
	// The effective CPM (cost-per-thousand viewable impressions) bid.
	EffectiveCpmBidMicros *wrappers.Int64Value `protobuf:"bytes,19,opt,name=effective_cpm_bid_micros,json=effectiveCpmBidMicros,proto3" json:"effective_cpm_bid_micros,omitempty"`
	// The effective CPV (cost-per-view) bid.
	EffectiveCpvBidMicros *wrappers.Int64Value `protobuf:"bytes,20,opt,name=effective_cpv_bid_micros,json=effectiveCpvBidMicros,proto3" json:"effective_cpv_bid_micros,omitempty"`
	// The effective Percent CPC bid amount.
	EffectivePercentCpcBidMicros *wrappers.Int64Value `protobuf:"bytes,34,opt,name=effective_percent_cpc_bid_micros,json=effectivePercentCpcBidMicros,proto3" json:"effective_percent_cpc_bid_micros,omitempty"`
	// Source of the effective CPC bid.
	EffectiveCpcBidSource enums.BiddingSourceEnum_BiddingSource `protobuf:"varint,21,opt,name=effective_cpc_bid_source,json=effectiveCpcBidSource,proto3,enum=google.ads.googleads.v0.enums.BiddingSourceEnum_BiddingSource" json:"effective_cpc_bid_source,omitempty"`
	// Source of the effective CPM bid.
	EffectiveCpmBidSource enums.BiddingSourceEnum_BiddingSource `protobuf:"varint,22,opt,name=effective_cpm_bid_source,json=effectiveCpmBidSource,proto3,enum=google.ads.googleads.v0.enums.BiddingSourceEnum_BiddingSource" json:"effective_cpm_bid_source,omitempty"`
	// Source of the effective CPV bid.
	EffectiveCpvBidSource enums.BiddingSourceEnum_BiddingSource `protobuf:"varint,23,opt,name=effective_cpv_bid_source,json=effectiveCpvBidSource,proto3,enum=google.ads.googleads.v0.enums.BiddingSourceEnum_BiddingSource" json:"effective_cpv_bid_source,omitempty"`
	// Source of the effective Percent CPC bid.
	EffectivePercentCpcBidSource enums.BiddingSourceEnum_BiddingSource `protobuf:"varint,35,opt,name=effective_percent_cpc_bid_source,json=effectivePercentCpcBidSource,proto3,enum=google.ads.googleads.v0.enums.BiddingSourceEnum_BiddingSource" json:"effective_percent_cpc_bid_source,omitempty"`
	// Estimates for criterion bids at various positions.
	PositionEstimates *AdGroupCriterion_PositionEstimates `protobuf:"bytes,10,opt,name=position_estimates,json=positionEstimates,proto3" json:"position_estimates,omitempty"`
	// The list of possible final URLs after all cross-domain redirects for the
	// ad.
	FinalUrls []*wrappers.StringValue `protobuf:"bytes,11,rep,name=final_urls,json=finalUrls,proto3" json:"final_urls,omitempty"`
	// The URL template for constructing a tracking URL.
	TrackingUrlTemplate *wrappers.StringValue `protobuf:"bytes,13,opt,name=tracking_url_template,json=trackingUrlTemplate,proto3" json:"tracking_url_template,omitempty"`
	// The list of mappings used to substitute custom parameter tags in a
	// `tracking_url_template`, `final_urls`, or `mobile_final_urls`.
	UrlCustomParameters []*common.CustomParameter `protobuf:"bytes,14,rep,name=url_custom_parameters,json=urlCustomParameters,proto3" json:"url_custom_parameters,omitempty"`
	// The ad group criterion.
	//
	// Exactly one must be set.
	//
	// Types that are valid to be assigned to Criterion:
	//	*AdGroupCriterion_Keyword
	//	*AdGroupCriterion_Placement
	//	*AdGroupCriterion_ListingGroup
	//	*AdGroupCriterion_AgeRange
	//	*AdGroupCriterion_Gender
	//	*AdGroupCriterion_IncomeRange
	//	*AdGroupCriterion_ParentalStatus
	//	*AdGroupCriterion_UserList
	//	*AdGroupCriterion_YoutubeVideo
	//	*AdGroupCriterion_YoutubeChannel
	//	*AdGroupCriterion_Topic
	//	*AdGroupCriterion_UserInterest
	Criterion            isAdGroupCriterion_Criterion `protobuf_oneof:"criterion"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *AdGroupCriterion) Reset()         { *m = AdGroupCriterion{} }
func (m *AdGroupCriterion) String() string { return proto.CompactTextString(m) }
func (*AdGroupCriterion) ProtoMessage()    {}
func (*AdGroupCriterion) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_group_criterion_84c24ce63224e446, []int{0}
}
func (m *AdGroupCriterion) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdGroupCriterion.Unmarshal(m, b)
}
func (m *AdGroupCriterion) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdGroupCriterion.Marshal(b, m, deterministic)
}
func (dst *AdGroupCriterion) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdGroupCriterion.Merge(dst, src)
}
func (m *AdGroupCriterion) XXX_Size() int {
	return xxx_messageInfo_AdGroupCriterion.Size(m)
}
func (m *AdGroupCriterion) XXX_DiscardUnknown() {
	xxx_messageInfo_AdGroupCriterion.DiscardUnknown(m)
}

var xxx_messageInfo_AdGroupCriterion proto.InternalMessageInfo

func (m *AdGroupCriterion) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *AdGroupCriterion) GetCriterionId() *wrappers.Int64Value {
	if m != nil {
		return m.CriterionId
	}
	return nil
}

func (m *AdGroupCriterion) GetStatus() enums.AdGroupCriterionStatusEnum_AdGroupCriterionStatus {
	if m != nil {
		return m.Status
	}
	return enums.AdGroupCriterionStatusEnum_UNSPECIFIED
}

func (m *AdGroupCriterion) GetQualityInfo() *AdGroupCriterion_QualityInfo {
	if m != nil {
		return m.QualityInfo
	}
	return nil
}

func (m *AdGroupCriterion) GetAdGroup() *wrappers.StringValue {
	if m != nil {
		return m.AdGroup
	}
	return nil
}

func (m *AdGroupCriterion) GetType() enums.CriterionTypeEnum_CriterionType {
	if m != nil {
		return m.Type
	}
	return enums.CriterionTypeEnum_UNSPECIFIED
}

func (m *AdGroupCriterion) GetNegative() *wrappers.BoolValue {
	if m != nil {
		return m.Negative
	}
	return nil
}

func (m *AdGroupCriterion) GetBidModifier() *wrappers.DoubleValue {
	if m != nil {
		return m.BidModifier
	}
	return nil
}

func (m *AdGroupCriterion) GetCpcBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CpcBidMicros
	}
	return nil
}

func (m *AdGroupCriterion) GetCpmBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CpmBidMicros
	}
	return nil
}

func (m *AdGroupCriterion) GetCpvBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CpvBidMicros
	}
	return nil
}

func (m *AdGroupCriterion) GetPercentCpcBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.PercentCpcBidMicros
	}
	return nil
}

func (m *AdGroupCriterion) GetEffectiveCpcBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.EffectiveCpcBidMicros
	}
	return nil
}

func (m *AdGroupCriterion) GetEffectiveCpmBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.EffectiveCpmBidMicros
	}
	return nil
}

func (m *AdGroupCriterion) GetEffectiveCpvBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.EffectiveCpvBidMicros
	}
	return nil
}

func (m *AdGroupCriterion) GetEffectivePercentCpcBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.EffectivePercentCpcBidMicros
	}
	return nil
}

func (m *AdGroupCriterion) GetEffectiveCpcBidSource() enums.BiddingSourceEnum_BiddingSource {
	if m != nil {
		return m.EffectiveCpcBidSource
	}
	return enums.BiddingSourceEnum_UNSPECIFIED
}

func (m *AdGroupCriterion) GetEffectiveCpmBidSource() enums.BiddingSourceEnum_BiddingSource {
	if m != nil {
		return m.EffectiveCpmBidSource
	}
	return enums.BiddingSourceEnum_UNSPECIFIED
}

func (m *AdGroupCriterion) GetEffectiveCpvBidSource() enums.BiddingSourceEnum_BiddingSource {
	if m != nil {
		return m.EffectiveCpvBidSource
	}
	return enums.BiddingSourceEnum_UNSPECIFIED
}

func (m *AdGroupCriterion) GetEffectivePercentCpcBidSource() enums.BiddingSourceEnum_BiddingSource {
	if m != nil {
		return m.EffectivePercentCpcBidSource
	}
	return enums.BiddingSourceEnum_UNSPECIFIED
}

func (m *AdGroupCriterion) GetPositionEstimates() *AdGroupCriterion_PositionEstimates {
	if m != nil {
		return m.PositionEstimates
	}
	return nil
}

func (m *AdGroupCriterion) GetFinalUrls() []*wrappers.StringValue {
	if m != nil {
		return m.FinalUrls
	}
	return nil
}

func (m *AdGroupCriterion) GetTrackingUrlTemplate() *wrappers.StringValue {
	if m != nil {
		return m.TrackingUrlTemplate
	}
	return nil
}

func (m *AdGroupCriterion) GetUrlCustomParameters() []*common.CustomParameter {
	if m != nil {
		return m.UrlCustomParameters
	}
	return nil
}

type isAdGroupCriterion_Criterion interface {
	isAdGroupCriterion_Criterion()
}

type AdGroupCriterion_Keyword struct {
	Keyword *common.KeywordInfo `protobuf:"bytes,27,opt,name=keyword,proto3,oneof"`
}

type AdGroupCriterion_Placement struct {
	Placement *common.PlacementInfo `protobuf:"bytes,28,opt,name=placement,proto3,oneof"`
}

type AdGroupCriterion_ListingGroup struct {
	ListingGroup *common.ListingGroupInfo `protobuf:"bytes,32,opt,name=listing_group,json=listingGroup,proto3,oneof"`
}

type AdGroupCriterion_AgeRange struct {
	AgeRange *common.AgeRangeInfo `protobuf:"bytes,36,opt,name=age_range,json=ageRange,proto3,oneof"`
}

type AdGroupCriterion_Gender struct {
	Gender *common.GenderInfo `protobuf:"bytes,37,opt,name=gender,proto3,oneof"`
}

type AdGroupCriterion_IncomeRange struct {
	IncomeRange *common.IncomeRangeInfo `protobuf:"bytes,38,opt,name=income_range,json=incomeRange,proto3,oneof"`
}

type AdGroupCriterion_ParentalStatus struct {
	ParentalStatus *common.ParentalStatusInfo `protobuf:"bytes,39,opt,name=parental_status,json=parentalStatus,proto3,oneof"`
}

type AdGroupCriterion_UserList struct {
	UserList *common.UserListInfo `protobuf:"bytes,42,opt,name=user_list,json=userList,proto3,oneof"`
}

type AdGroupCriterion_YoutubeVideo struct {
	YoutubeVideo *common.YouTubeVideoInfo `protobuf:"bytes,40,opt,name=youtube_video,json=youtubeVideo,proto3,oneof"`
}

type AdGroupCriterion_YoutubeChannel struct {
	YoutubeChannel *common.YouTubeChannelInfo `protobuf:"bytes,41,opt,name=youtube_channel,json=youtubeChannel,proto3,oneof"`
}

type AdGroupCriterion_Topic struct {
	Topic *common.TopicInfo `protobuf:"bytes,43,opt,name=topic,proto3,oneof"`
}

type AdGroupCriterion_UserInterest struct {
	UserInterest *common.UserInterestInfo `protobuf:"bytes,45,opt,name=user_interest,json=userInterest,proto3,oneof"`
}

func (*AdGroupCriterion_Keyword) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_Placement) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_ListingGroup) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_AgeRange) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_Gender) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_IncomeRange) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_ParentalStatus) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_UserList) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_YoutubeVideo) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_YoutubeChannel) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_Topic) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_UserInterest) isAdGroupCriterion_Criterion() {}

func (m *AdGroupCriterion) GetCriterion() isAdGroupCriterion_Criterion {
	if m != nil {
		return m.Criterion
	}
	return nil
}

func (m *AdGroupCriterion) GetKeyword() *common.KeywordInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_Keyword); ok {
		return x.Keyword
	}
	return nil
}

func (m *AdGroupCriterion) GetPlacement() *common.PlacementInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_Placement); ok {
		return x.Placement
	}
	return nil
}

func (m *AdGroupCriterion) GetListingGroup() *common.ListingGroupInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_ListingGroup); ok {
		return x.ListingGroup
	}
	return nil
}

func (m *AdGroupCriterion) GetAgeRange() *common.AgeRangeInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_AgeRange); ok {
		return x.AgeRange
	}
	return nil
}

func (m *AdGroupCriterion) GetGender() *common.GenderInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_Gender); ok {
		return x.Gender
	}
	return nil
}

func (m *AdGroupCriterion) GetIncomeRange() *common.IncomeRangeInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_IncomeRange); ok {
		return x.IncomeRange
	}
	return nil
}

func (m *AdGroupCriterion) GetParentalStatus() *common.ParentalStatusInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_ParentalStatus); ok {
		return x.ParentalStatus
	}
	return nil
}

func (m *AdGroupCriterion) GetUserList() *common.UserListInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_UserList); ok {
		return x.UserList
	}
	return nil
}

func (m *AdGroupCriterion) GetYoutubeVideo() *common.YouTubeVideoInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_YoutubeVideo); ok {
		return x.YoutubeVideo
	}
	return nil
}

func (m *AdGroupCriterion) GetYoutubeChannel() *common.YouTubeChannelInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_YoutubeChannel); ok {
		return x.YoutubeChannel
	}
	return nil
}

func (m *AdGroupCriterion) GetTopic() *common.TopicInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_Topic); ok {
		return x.Topic
	}
	return nil
}

func (m *AdGroupCriterion) GetUserInterest() *common.UserInterestInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_UserInterest); ok {
		return x.UserInterest
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*AdGroupCriterion) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _AdGroupCriterion_OneofMarshaler, _AdGroupCriterion_OneofUnmarshaler, _AdGroupCriterion_OneofSizer, []interface{}{
		(*AdGroupCriterion_Keyword)(nil),
		(*AdGroupCriterion_Placement)(nil),
		(*AdGroupCriterion_ListingGroup)(nil),
		(*AdGroupCriterion_AgeRange)(nil),
		(*AdGroupCriterion_Gender)(nil),
		(*AdGroupCriterion_IncomeRange)(nil),
		(*AdGroupCriterion_ParentalStatus)(nil),
		(*AdGroupCriterion_UserList)(nil),
		(*AdGroupCriterion_YoutubeVideo)(nil),
		(*AdGroupCriterion_YoutubeChannel)(nil),
		(*AdGroupCriterion_Topic)(nil),
		(*AdGroupCriterion_UserInterest)(nil),
	}
}

func _AdGroupCriterion_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*AdGroupCriterion)
	// criterion
	switch x := m.Criterion.(type) {
	case *AdGroupCriterion_Keyword:
		b.EncodeVarint(27<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Keyword); err != nil {
			return err
		}
	case *AdGroupCriterion_Placement:
		b.EncodeVarint(28<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Placement); err != nil {
			return err
		}
	case *AdGroupCriterion_ListingGroup:
		b.EncodeVarint(32<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ListingGroup); err != nil {
			return err
		}
	case *AdGroupCriterion_AgeRange:
		b.EncodeVarint(36<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AgeRange); err != nil {
			return err
		}
	case *AdGroupCriterion_Gender:
		b.EncodeVarint(37<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Gender); err != nil {
			return err
		}
	case *AdGroupCriterion_IncomeRange:
		b.EncodeVarint(38<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.IncomeRange); err != nil {
			return err
		}
	case *AdGroupCriterion_ParentalStatus:
		b.EncodeVarint(39<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ParentalStatus); err != nil {
			return err
		}
	case *AdGroupCriterion_UserList:
		b.EncodeVarint(42<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.UserList); err != nil {
			return err
		}
	case *AdGroupCriterion_YoutubeVideo:
		b.EncodeVarint(40<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.YoutubeVideo); err != nil {
			return err
		}
	case *AdGroupCriterion_YoutubeChannel:
		b.EncodeVarint(41<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.YoutubeChannel); err != nil {
			return err
		}
	case *AdGroupCriterion_Topic:
		b.EncodeVarint(43<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Topic); err != nil {
			return err
		}
	case *AdGroupCriterion_UserInterest:
		b.EncodeVarint(45<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.UserInterest); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("AdGroupCriterion.Criterion has unexpected type %T", x)
	}
	return nil
}

func _AdGroupCriterion_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*AdGroupCriterion)
	switch tag {
	case 27: // criterion.keyword
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.KeywordInfo)
		err := b.DecodeMessage(msg)
		m.Criterion = &AdGroupCriterion_Keyword{msg}
		return true, err
	case 28: // criterion.placement
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.PlacementInfo)
		err := b.DecodeMessage(msg)
		m.Criterion = &AdGroupCriterion_Placement{msg}
		return true, err
	case 32: // criterion.listing_group
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.ListingGroupInfo)
		err := b.DecodeMessage(msg)
		m.Criterion = &AdGroupCriterion_ListingGroup{msg}
		return true, err
	case 36: // criterion.age_range
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.AgeRangeInfo)
		err := b.DecodeMessage(msg)
		m.Criterion = &AdGroupCriterion_AgeRange{msg}
		return true, err
	case 37: // criterion.gender
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.GenderInfo)
		err := b.DecodeMessage(msg)
		m.Criterion = &AdGroupCriterion_Gender{msg}
		return true, err
	case 38: // criterion.income_range
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.IncomeRangeInfo)
		err := b.DecodeMessage(msg)
		m.Criterion = &AdGroupCriterion_IncomeRange{msg}
		return true, err
	case 39: // criterion.parental_status
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.ParentalStatusInfo)
		err := b.DecodeMessage(msg)
		m.Criterion = &AdGroupCriterion_ParentalStatus{msg}
		return true, err
	case 42: // criterion.user_list
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.UserListInfo)
		err := b.DecodeMessage(msg)
		m.Criterion = &AdGroupCriterion_UserList{msg}
		return true, err
	case 40: // criterion.youtube_video
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.YouTubeVideoInfo)
		err := b.DecodeMessage(msg)
		m.Criterion = &AdGroupCriterion_YoutubeVideo{msg}
		return true, err
	case 41: // criterion.youtube_channel
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.YouTubeChannelInfo)
		err := b.DecodeMessage(msg)
		m.Criterion = &AdGroupCriterion_YoutubeChannel{msg}
		return true, err
	case 43: // criterion.topic
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.TopicInfo)
		err := b.DecodeMessage(msg)
		m.Criterion = &AdGroupCriterion_Topic{msg}
		return true, err
	case 45: // criterion.user_interest
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.UserInterestInfo)
		err := b.DecodeMessage(msg)
		m.Criterion = &AdGroupCriterion_UserInterest{msg}
		return true, err
	default:
		return false, nil
	}
}

func _AdGroupCriterion_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*AdGroupCriterion)
	// criterion
	switch x := m.Criterion.(type) {
	case *AdGroupCriterion_Keyword:
		s := proto.Size(x.Keyword)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupCriterion_Placement:
		s := proto.Size(x.Placement)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupCriterion_ListingGroup:
		s := proto.Size(x.ListingGroup)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupCriterion_AgeRange:
		s := proto.Size(x.AgeRange)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupCriterion_Gender:
		s := proto.Size(x.Gender)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupCriterion_IncomeRange:
		s := proto.Size(x.IncomeRange)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupCriterion_ParentalStatus:
		s := proto.Size(x.ParentalStatus)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupCriterion_UserList:
		s := proto.Size(x.UserList)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupCriterion_YoutubeVideo:
		s := proto.Size(x.YoutubeVideo)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupCriterion_YoutubeChannel:
		s := proto.Size(x.YoutubeChannel)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupCriterion_Topic:
		s := proto.Size(x.Topic)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupCriterion_UserInterest:
		s := proto.Size(x.UserInterest)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A container for ad group criterion quality information.
type AdGroupCriterion_QualityInfo struct {
	// The quality score.
	//
	// This field may not be populated if Google does not have enough
	// information to determine a value.
	QualityScore *wrappers.Int32Value `protobuf:"bytes,1,opt,name=quality_score,json=qualityScore,proto3" json:"quality_score,omitempty"`
	// The performance of the ad compared to other advertisers.
	CreativeQualityScore enums.QualityScoreBucketEnum_QualityScoreBucket `protobuf:"varint,2,opt,name=creative_quality_score,json=creativeQualityScore,proto3,enum=google.ads.googleads.v0.enums.QualityScoreBucketEnum_QualityScoreBucket" json:"creative_quality_score,omitempty"`
	// The quality score of the landing page.
	PostClickQualityScore enums.QualityScoreBucketEnum_QualityScoreBucket `protobuf:"varint,3,opt,name=post_click_quality_score,json=postClickQualityScore,proto3,enum=google.ads.googleads.v0.enums.QualityScoreBucketEnum_QualityScoreBucket" json:"post_click_quality_score,omitempty"`
	// The click-through rate compared to that of other advertisers.
	SearchPredictedCtr   enums.QualityScoreBucketEnum_QualityScoreBucket `protobuf:"varint,4,opt,name=search_predicted_ctr,json=searchPredictedCtr,proto3,enum=google.ads.googleads.v0.enums.QualityScoreBucketEnum_QualityScoreBucket" json:"search_predicted_ctr,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                        `json:"-"`
	XXX_unrecognized     []byte                                          `json:"-"`
	XXX_sizecache        int32                                           `json:"-"`
}

func (m *AdGroupCriterion_QualityInfo) Reset()         { *m = AdGroupCriterion_QualityInfo{} }
func (m *AdGroupCriterion_QualityInfo) String() string { return proto.CompactTextString(m) }
func (*AdGroupCriterion_QualityInfo) ProtoMessage()    {}
func (*AdGroupCriterion_QualityInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_group_criterion_84c24ce63224e446, []int{0, 0}
}
func (m *AdGroupCriterion_QualityInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdGroupCriterion_QualityInfo.Unmarshal(m, b)
}
func (m *AdGroupCriterion_QualityInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdGroupCriterion_QualityInfo.Marshal(b, m, deterministic)
}
func (dst *AdGroupCriterion_QualityInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdGroupCriterion_QualityInfo.Merge(dst, src)
}
func (m *AdGroupCriterion_QualityInfo) XXX_Size() int {
	return xxx_messageInfo_AdGroupCriterion_QualityInfo.Size(m)
}
func (m *AdGroupCriterion_QualityInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_AdGroupCriterion_QualityInfo.DiscardUnknown(m)
}

var xxx_messageInfo_AdGroupCriterion_QualityInfo proto.InternalMessageInfo

func (m *AdGroupCriterion_QualityInfo) GetQualityScore() *wrappers.Int32Value {
	if m != nil {
		return m.QualityScore
	}
	return nil
}

func (m *AdGroupCriterion_QualityInfo) GetCreativeQualityScore() enums.QualityScoreBucketEnum_QualityScoreBucket {
	if m != nil {
		return m.CreativeQualityScore
	}
	return enums.QualityScoreBucketEnum_UNSPECIFIED
}

func (m *AdGroupCriterion_QualityInfo) GetPostClickQualityScore() enums.QualityScoreBucketEnum_QualityScoreBucket {
	if m != nil {
		return m.PostClickQualityScore
	}
	return enums.QualityScoreBucketEnum_UNSPECIFIED
}

func (m *AdGroupCriterion_QualityInfo) GetSearchPredictedCtr() enums.QualityScoreBucketEnum_QualityScoreBucket {
	if m != nil {
		return m.SearchPredictedCtr
	}
	return enums.QualityScoreBucketEnum_UNSPECIFIED
}

// Estimates for criterion bids at various positions.
type AdGroupCriterion_PositionEstimates struct {
	// The estimate of the CPC bid required for ad to be shown on first
	// page of search results.
	FirstPageCpcMicros *wrappers.Int64Value `protobuf:"bytes,1,opt,name=first_page_cpc_micros,json=firstPageCpcMicros,proto3" json:"first_page_cpc_micros,omitempty"`
	// The estimate of the CPC bid required for ad to be displayed in first
	// position, at the top of the first page of search results.
	FirstPositionCpcMicros *wrappers.Int64Value `protobuf:"bytes,2,opt,name=first_position_cpc_micros,json=firstPositionCpcMicros,proto3" json:"first_position_cpc_micros,omitempty"`
	// The estimate of the CPC bid required for ad to be displayed at the top
	// of the first page of search results.
	TopOfPageCpcMicros   *wrappers.Int64Value `protobuf:"bytes,3,opt,name=top_of_page_cpc_micros,json=topOfPageCpcMicros,proto3" json:"top_of_page_cpc_micros,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *AdGroupCriterion_PositionEstimates) Reset()         { *m = AdGroupCriterion_PositionEstimates{} }
func (m *AdGroupCriterion_PositionEstimates) String() string { return proto.CompactTextString(m) }
func (*AdGroupCriterion_PositionEstimates) ProtoMessage()    {}
func (*AdGroupCriterion_PositionEstimates) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_group_criterion_84c24ce63224e446, []int{0, 1}
}
func (m *AdGroupCriterion_PositionEstimates) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdGroupCriterion_PositionEstimates.Unmarshal(m, b)
}
func (m *AdGroupCriterion_PositionEstimates) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdGroupCriterion_PositionEstimates.Marshal(b, m, deterministic)
}
func (dst *AdGroupCriterion_PositionEstimates) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdGroupCriterion_PositionEstimates.Merge(dst, src)
}
func (m *AdGroupCriterion_PositionEstimates) XXX_Size() int {
	return xxx_messageInfo_AdGroupCriterion_PositionEstimates.Size(m)
}
func (m *AdGroupCriterion_PositionEstimates) XXX_DiscardUnknown() {
	xxx_messageInfo_AdGroupCriterion_PositionEstimates.DiscardUnknown(m)
}

var xxx_messageInfo_AdGroupCriterion_PositionEstimates proto.InternalMessageInfo

func (m *AdGroupCriterion_PositionEstimates) GetFirstPageCpcMicros() *wrappers.Int64Value {
	if m != nil {
		return m.FirstPageCpcMicros
	}
	return nil
}

func (m *AdGroupCriterion_PositionEstimates) GetFirstPositionCpcMicros() *wrappers.Int64Value {
	if m != nil {
		return m.FirstPositionCpcMicros
	}
	return nil
}

func (m *AdGroupCriterion_PositionEstimates) GetTopOfPageCpcMicros() *wrappers.Int64Value {
	if m != nil {
		return m.TopOfPageCpcMicros
	}
	return nil
}

func init() {
	proto.RegisterType((*AdGroupCriterion)(nil), "google.ads.googleads.v0.resources.AdGroupCriterion")
	proto.RegisterType((*AdGroupCriterion_QualityInfo)(nil), "google.ads.googleads.v0.resources.AdGroupCriterion.QualityInfo")
	proto.RegisterType((*AdGroupCriterion_PositionEstimates)(nil), "google.ads.googleads.v0.resources.AdGroupCriterion.PositionEstimates")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v0/resources/ad_group_criterion.proto", fileDescriptor_ad_group_criterion_84c24ce63224e446)
}

var fileDescriptor_ad_group_criterion_84c24ce63224e446 = []byte{
	// 1334 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x98, 0xdf, 0x72, 0xdb, 0xc4,
	0x17, 0xc7, 0x7f, 0x4e, 0xfa, 0x2f, 0x6b, 0x27, 0xbf, 0x76, 0x53, 0x87, 0x6d, 0x5a, 0x20, 0x6d,
	0x29, 0xa4, 0xff, 0xe4, 0x4c, 0x0a, 0x85, 0xa1, 0x43, 0x8b, 0x9d, 0x76, 0xd2, 0x50, 0xda, 0xba,
	0x8a, 0x1b, 0x06, 0x26, 0x8c, 0x66, 0xbd, 0x5a, 0xab, 0x3b, 0x91, 0xb4, 0xea, 0xee, 0xca, 0x9d,
	0x70, 0xc1, 0x0c, 0x37, 0x5c, 0xf1, 0x14, 0x5c, 0xf2, 0x28, 0xdc, 0x70, 0xcf, 0x6b, 0xf0, 0x02,
	0xcc, 0xae, 0x56, 0xb6, 0x6c, 0xd7, 0x91, 0xcb, 0xe4, 0x4e, 0x3a, 0xd9, 0xef, 0xe7, 0x9c, 0xfd,
	0x1e, 0x59, 0x7b, 0x14, 0xf0, 0x65, 0xc0, 0x79, 0x10, 0xd2, 0x06, 0xf6, 0x65, 0x23, 0xbb, 0xd4,
	0x57, 0xfd, 0x8d, 0x86, 0xa0, 0x92, 0xa7, 0x82, 0x50, 0xd9, 0xc0, 0xbe, 0x17, 0x08, 0x9e, 0x26,
	0x1e, 0x11, 0x4c, 0x51, 0xc1, 0x78, 0xec, 0x24, 0x82, 0x2b, 0x0e, 0x2f, 0x67, 0x02, 0x07, 0xfb,
	0xd2, 0x19, 0x68, 0x9d, 0xfe, 0x86, 0x33, 0xd0, 0xae, 0xde, 0x9e, 0x86, 0x27, 0x3c, 0x8a, 0x78,
	0xdc, 0xb0, 0x48, 0x9c, 0x11, 0x57, 0x3f, 0x2b, 0x5b, 0x9e, 0x4a, 0xc5, 0x23, 0x2f, 0xc1, 0x02,
	0x47, 0x54, 0x51, 0x61, 0x65, 0x5f, 0x4d, 0x93, 0xd1, 0x38, 0x8d, 0xde, 0xb6, 0x01, 0x4f, 0x2a,
	0xac, 0x52, 0x69, 0xe5, 0x9b, 0x47, 0xcb, 0xbb, 0xcc, 0xf7, 0x59, 0x1c, 0x78, 0xd9, 0x9e, 0x66,
	0xd3, 0x0c, 0x33, 0xa9, 0xc3, 0x24, 0xd7, 0x7c, 0x71, 0xb4, 0xe6, 0x75, 0x8a, 0x43, 0xa6, 0x0e,
	0x3d, 0x49, 0xb8, 0xa0, 0x5e, 0x37, 0x25, 0x07, 0x54, 0x59, 0xe5, 0x07, 0x56, 0x69, 0xee, 0xba,
	0x69, 0xaf, 0xf1, 0x46, 0xe0, 0x24, 0xa1, 0xc2, 0xee, 0xe0, 0xca, 0x3f, 0xef, 0x83, 0xb3, 0x4d,
	0x7f, 0x5b, 0x6f, 0x72, 0x2b, 0xcf, 0x0c, 0xaf, 0x82, 0xc5, 0xbc, 0x11, 0x5e, 0x8c, 0x23, 0x8a,
	0x2a, 0x6b, 0x95, 0xf5, 0x05, 0xb7, 0x96, 0x07, 0x9f, 0xe1, 0x88, 0xc2, 0xfb, 0xa0, 0x36, 0xac,
	0x95, 0xf9, 0x68, 0x75, 0xad, 0xb2, 0x5e, 0xdd, 0xbc, 0x68, 0xfb, 0xe9, 0xe4, 0x09, 0x9d, 0x9d,
	0x58, 0xdd, 0xfd, 0x74, 0x0f, 0x87, 0x29, 0x75, 0xab, 0x03, 0xc1, 0x8e, 0x0f, 0x5f, 0x81, 0x53,
	0x99, 0x97, 0x68, 0x7e, 0xad, 0xb2, 0xbe, 0xb4, 0xd9, 0x76, 0xa6, 0x3d, 0x14, 0x66, 0x93, 0xce,
	0x78, 0x95, 0xbb, 0x46, 0xfc, 0x28, 0x4e, 0xa3, 0x29, 0x7f, 0x72, 0x2d, 0x1f, 0x76, 0x41, 0x2d,
	0x77, 0x88, 0xc5, 0x3d, 0x8e, 0x4e, 0x98, 0x4a, 0x1f, 0x38, 0xa5, 0x0f, 0xe1, 0x04, 0xd8, 0x79,
	0x91, 0x71, 0x76, 0xe2, 0x1e, 0x77, 0xab, 0xaf, 0x87, 0x37, 0xf0, 0x73, 0x70, 0x26, 0x7f, 0x58,
	0xd0, 0x49, 0xc3, 0xbf, 0x34, 0xe1, 0xc4, 0xae, 0x12, 0x2c, 0x0e, 0x32, 0x2b, 0x4e, 0xe3, 0x0c,
	0x0d, 0x5d, 0x70, 0x42, 0x37, 0x1a, 0x5d, 0x30, 0x26, 0xdc, 0x2f, 0x31, 0x61, 0x50, 0x49, 0xe7,
	0x30, 0xa1, 0x66, 0xef, 0x23, 0x11, 0xd7, 0xb0, 0xe0, 0x5d, 0x70, 0x26, 0xa6, 0x01, 0x56, 0xac,
	0x4f, 0xd1, 0x87, 0xa6, 0x98, 0xd5, 0x89, 0x62, 0x5a, 0x9c, 0x87, 0x59, 0x29, 0x83, 0xb5, 0xf0,
	0x01, 0xa8, 0x75, 0x99, 0xef, 0x45, 0xdc, 0x67, 0x3d, 0x46, 0x05, 0xba, 0x35, 0x65, 0x23, 0x0f,
	0x79, 0xda, 0x0d, 0xa9, 0xed, 0x69, 0x97, 0xf9, 0x4f, 0xad, 0x00, 0x36, 0xc1, 0x12, 0x49, 0x88,
	0x67, 0x20, 0x8c, 0x08, 0x2e, 0xd1, 0xd9, 0xf2, 0xa7, 0xa2, 0x46, 0x12, 0xd2, 0x62, 0xfe, 0x53,
	0x23, 0xc8, 0x10, 0x51, 0x11, 0x71, 0x6e, 0x26, 0x44, 0x34, 0x86, 0xe8, 0x17, 0x11, 0x68, 0x26,
	0x44, 0x7f, 0x88, 0x68, 0x83, 0x95, 0x84, 0x0a, 0x42, 0x63, 0xe5, 0x8d, 0x6d, 0xe8, 0x72, 0x39,
	0x6a, 0xd9, 0x4a, 0xb7, 0x8a, 0xfb, 0xea, 0x00, 0x44, 0x7b, 0x3d, 0x4a, 0xb4, 0xd1, 0xe3, 0x4c,
	0x58, 0xce, 0xac, 0x0f, 0xc4, 0x47, 0x51, 0x47, 0x7c, 0x5b, 0x7e, 0x37, 0x6a, 0x34, 0x95, 0x3a,
	0x62, 0xe5, 0xf9, 0x77, 0xa3, 0x16, 0x3c, 0x25, 0x60, 0x6d, 0x48, 0x9d, 0xe2, 0xee, 0x95, 0x72,
	0xfa, 0xa5, 0x01, 0xa4, 0xfd, 0x16, 0x9b, 0xdf, 0xbc, 0xcd, 0xe6, 0xec, 0xe7, 0x8c, 0xea, 0x33,
	0xfd, 0xc4, 0x5a, 0xd9, 0x4b, 0x7b, 0xd7, 0x68, 0xcc, 0x4f, 0x6c, 0x24, 0x32, 0xd1, 0x89, 0x2c,
	0x3c, 0x9e, 0x38, 0x2a, 0x26, 0x5e, 0x39, 0xf6, 0xc4, 0xd1, 0xd4, 0xc4, 0xfd, 0x62, 0xe2, 0xf7,
	0x8e, 0x3d, 0x71, 0x7f, 0x98, 0xf8, 0xd7, 0xca, 0x51, 0x0d, 0xb5, 0x15, 0x5c, 0x3d, 0x96, 0x0a,
	0xa6, 0xf4, 0xdc, 0x16, 0xa2, 0x00, 0x4c, 0xb8, 0x64, 0x4a, 0x1f, 0x44, 0x54, 0x2a, 0x16, 0x61,
	0x45, 0x25, 0x02, 0xe6, 0x51, 0x7a, 0xf4, 0x5f, 0xde, 0xf2, 0x6d, 0x4b, 0x7b, 0x94, 0xc3, 0xdc,
	0x73, 0xc9, 0x78, 0x08, 0xde, 0x03, 0xa0, 0xc7, 0x62, 0x1c, 0x7a, 0xa9, 0x08, 0x25, 0xaa, 0xae,
	0xcd, 0x97, 0xbe, 0xf3, 0x17, 0xcc, 0xfa, 0x97, 0x22, 0xd4, 0xef, 0x97, 0xba, 0x12, 0x98, 0x1c,
	0xe8, 0xe9, 0x20, 0x15, 0xa1, 0xa7, 0x68, 0x94, 0x84, 0x58, 0x51, 0xb4, 0x38, 0xc3, 0xd9, 0xb1,
	0x9c, 0x4b, 0x5f, 0x8a, 0xb0, 0x63, 0x85, 0x90, 0x80, 0xba, 0x06, 0x8d, 0xcf, 0x39, 0x12, 0x2d,
	0x99, 0xca, 0x1a, 0x53, 0x7d, 0xc8, 0x06, 0x24, 0x67, 0xcb, 0x08, 0xdb, 0xb9, 0xce, 0x5d, 0x4e,
	0x45, 0x38, 0x16, 0x93, 0x70, 0x1b, 0x9c, 0x3e, 0xa0, 0x87, 0x6f, 0xb8, 0xf0, 0xd1, 0x45, 0x53,
	0xe8, 0xcd, 0x32, 0xec, 0x93, 0x6c, 0xb9, 0x3e, 0x23, 0x1f, 0xff, 0xcf, 0xcd, 0xd5, 0xf0, 0x29,
	0x58, 0x48, 0x42, 0x4c, 0x68, 0x44, 0x63, 0x85, 0x2e, 0x19, 0xd4, 0xed, 0x32, 0x54, 0x3b, 0x17,
	0x58, 0xd8, 0x90, 0x00, 0xbf, 0x03, 0x8b, 0x21, 0x93, 0x4a, 0xbb, 0x99, 0x1d, 0xc1, 0x6b, 0x06,
	0xb9, 0x51, 0x86, 0xfc, 0x36, 0x13, 0x99, 0xf6, 0x5b, 0x6a, 0x2d, 0x2c, 0xc4, 0xe0, 0x13, 0xb0,
	0x80, 0x03, 0xea, 0x09, 0x1c, 0x07, 0x14, 0x7d, 0x64, 0xa0, 0xb7, 0xca, 0xa0, 0xcd, 0x80, 0xba,
	0x7a, 0xbd, 0x05, 0x9e, 0xc1, 0xf6, 0x1e, 0x3e, 0x04, 0xa7, 0x02, 0x1a, 0xfb, 0x54, 0xa0, 0x6b,
	0x86, 0x74, 0xa3, 0x8c, 0xb4, 0x6d, 0x56, 0x5b, 0x8e, 0xd5, 0xc2, 0x0e, 0xa8, 0xb1, 0x98, 0xf0,
	0x28, 0xaf, 0xea, 0x63, 0xc3, 0x2a, 0xed, 0xef, 0x8e, 0xd1, 0x14, 0x0b, 0xab, 0xb2, 0x61, 0x08,
	0xfe, 0x08, 0xfe, 0x9f, 0x60, 0x41, 0x63, 0x85, 0x43, 0x3b, 0xe2, 0xa2, 0x4f, 0x0c, 0x78, 0xb3,
	0xb4, 0x2d, 0x56, 0x96, 0x0d, 0x5d, 0x96, 0xbd, 0x94, 0x8c, 0x44, 0xb5, 0x8f, 0xa9, 0xa4, 0xc2,
	0xd3, 0xe6, 0xa2, 0x1b, 0xb3, 0xf9, 0xf8, 0x52, 0x52, 0xa1, 0x1b, 0x94, 0xfb, 0x98, 0xda, 0x7b,
	0xdd, 0xed, 0x43, 0x9e, 0xaa, 0xb4, 0x4b, 0xbd, 0x3e, 0xf3, 0x29, 0x47, 0xeb, 0xb3, 0x75, 0xfb,
	0x7b, 0x9e, 0x76, 0xd2, 0x2e, 0xdd, 0xd3, 0x9a, 0xbc, 0xdb, 0x16, 0x64, 0x62, 0xda, 0x84, 0x1c,
	0x4c, 0x5e, 0xe1, 0x38, 0xa6, 0x21, 0xba, 0x3e, 0x9b, 0x09, 0x16, 0xbd, 0x95, 0xa9, 0x72, 0x13,
	0x2c, 0xcc, 0x46, 0x61, 0x13, 0x9c, 0x54, 0x3c, 0x61, 0x04, 0xdd, 0x34, 0xd0, 0xeb, 0x65, 0xd0,
	0x8e, 0x5e, 0x6c, 0x59, 0x99, 0x52, 0x6f, 0xdd, 0xf8, 0xc8, 0x62, 0x45, 0x05, 0x95, 0x0a, 0xdd,
	0x9e, 0x6d, 0xeb, 0xda, 0xcb, 0x1d, 0xab, 0xc9, 0xb7, 0x9e, 0x16, 0x62, 0xab, 0x7f, 0xcd, 0x83,
	0x6a, 0x61, 0xb8, 0x85, 0x5f, 0x83, 0xc5, 0x91, 0xaf, 0x0a, 0xf3, 0x09, 0x30, 0xe5, 0x64, 0xbe,
	0xb3, 0x69, 0x47, 0x28, 0xab, 0xd8, 0xd5, 0x02, 0xf8, 0x33, 0x58, 0x21, 0x82, 0x9a, 0xc1, 0xd2,
	0x1b, 0x45, 0xcd, 0x99, 0x33, 0xe1, 0x71, 0xc9, 0x99, 0xf0, 0xa2, 0x00, 0x6b, 0x99, 0x4f, 0x1a,
	0x73, 0x30, 0x4c, 0x86, 0xdd, 0xf3, 0x79, 0x9e, 0xe2, 0xdf, 0xe0, 0x2f, 0x15, 0x80, 0x12, 0x2e,
	0x95, 0x47, 0x42, 0x46, 0x0e, 0xc6, 0x4a, 0x98, 0x3f, 0xe6, 0x12, 0xea, 0x3a, 0xd3, 0x96, 0x4e,
	0x34, 0x52, 0xc3, 0x4f, 0xe0, 0xbc, 0xa4, 0x58, 0x90, 0x57, 0x5e, 0x22, 0xa8, 0xcf, 0x88, 0xa2,
	0xbe, 0x47, 0x94, 0x30, 0x5f, 0x20, 0xc7, 0x99, 0x1e, 0x66, 0x59, 0xda, 0x79, 0x92, 0x2d, 0x25,
	0x56, 0x7f, 0x9b, 0x03, 0xe7, 0x26, 0x0e, 0x32, 0xf8, 0x0c, 0xd4, 0x7b, 0x4c, 0x48, 0xe5, 0x25,
	0xfa, 0xbd, 0xa6, 0x0f, 0x6b, 0x3b, 0x79, 0x55, 0xca, 0x27, 0x2f, 0x68, 0x94, 0x6d, 0x1c, 0xe8,
	0xc9, 0xc7, 0xce, 0x5b, 0x7b, 0xe0, 0x82, 0xe5, 0xe5, 0x27, 0x70, 0x81, 0x39, 0x57, 0xce, 0x5c,
	0xc9, 0x98, 0x56, 0x3c, 0xe4, 0x3e, 0x07, 0x2b, 0x8a, 0x27, 0x1e, 0xef, 0x4d, 0x14, 0x3a, 0x3f,
	0x43, 0xa1, 0x8a, 0x27, 0xcf, 0x7b, 0x23, 0x85, 0xb6, 0xaa, 0x60, 0x61, 0xf0, 0xf5, 0xd9, 0xfa,
	0xbb, 0x02, 0xae, 0x11, 0x1e, 0x95, 0xcf, 0x06, 0xad, 0xfa, 0xf8, 0x70, 0xd0, 0xd6, 0xf9, 0xda,
	0x95, 0x1f, 0xbe, 0xb1, 0xda, 0x80, 0x87, 0x38, 0x0e, 0x1c, 0x2e, 0x82, 0x46, 0x40, 0x63, 0x53,
	0x4d, 0xfe, 0x89, 0x9e, 0x30, 0x79, 0xc4, 0x7f, 0x47, 0xee, 0x0d, 0xae, 0x7e, 0x9f, 0x9b, 0xdf,
	0x6e, 0x36, 0xff, 0x98, 0xbb, 0xbc, 0x9d, 0x21, 0x9b, 0xbe, 0x74, 0xb2, 0x4b, 0x7d, 0xb5, 0xb7,
	0xe1, 0xb8, 0xf9, 0xca, 0x3f, 0xf3, 0x35, 0xfb, 0x4d, 0x5f, 0xee, 0x0f, 0xd6, 0xec, 0xef, 0x6d,
	0xec, 0x0f, 0xd6, 0x74, 0x4f, 0x99, 0x22, 0xee, 0xfc, 0x1b, 0x00, 0x00, 0xff, 0xff, 0x69, 0x3e,
	0xbe, 0xa3, 0xa1, 0x11, 0x00, 0x00,
}
