/*
 * virtual private network daemon (vpnd)
 *
 * cryptographic stuff (c) 1999 Andreas Steinmetz, astmail@yahoo.com
 * other code (c) 1999 D.O.M. Datenverarbeitung GmbH, author Andreas Steinmetz
 *
 * License:
 * This code is in the public domain (*) under the GNU public license.
 * The copyright holders will however retain their copyright.
 * There is no guarantee for the fitness and usability of this code
 * for any purpose. The author and the copyright holders take no
 * responsibility for any damages caused by the use of this code.
 * Distribution and use of this code is explicitly granted provided
 * that the above header is not modified and the above conditions
 * are met.
 * (*) 'public domain' is used here in the sense of the Wassenaar treaty.
 */

#include "vpnd.h"

/*============================================================================*/
/* user-defined: start of external processes                                  */
/*============================================================================*/

/*
 * doexec
 *
 * input: pathname - the full pathname of the process to be executed or NULL
 *	  param    - an optional parameter or NULL
 *
 * This procedure starts the process stated by pathname asynchronously,
 * if pathname is not null, otherwise no action is taken.
 */

void doexec(char *pathname,char *param)
{
	/* nothing to be done if no process pathname given */

	if(!pathname)return;

	/* create child process */

	switch(fork())
	{
	/* child process */

	case 0:	/* close all open handles */

		closehandles();

		/* reset memory */

		clearmem();

		/* create child of child */

		switch(fork())
		{
		/* child of child */

		case 0:	/* try to execute given process */

			execl(pathname,pathname,param,NULL);

		/* child process or child of child creation failure:
		   just terminate */

		default:exit(1);
		}

	/* fork failure: just ignore this */

	case -1:break;

	/* parent: wait for child to terminate */

	default:wait(NULL);
	}
}
