// -*-c++-*-
/* $Id: authserv.h,v 1.29 1999/12/20 21:56:40 kaashoek Exp $ */

/*
 *
 * Copyright (C) 1999 Michael Kaminsky (kaminsky@lcs.mit.edu)
 * Copyright (C) 1999 David Mazieres (dm@uun.org)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#ifndef _AUTHSERV_H_
#define _AUTHSERV_H_

#include "sfsmisc.h"
#include "arpc.h"
#include "crypt.h"
#include "authdb.h"
#include "srp.h"

/* in authserv.C */
extern sfssrp_parms srpglobal;
extern ptr<rabin_priv> authsrvkey;
extern sfs_servinfo servinfo;
extern sfs_hash hostid;
extern bool accepts_changes;
extern bool accepts_reg;
extern str sfsauthcachedir;

extern int xfer_timeout;
extern int cache_expire;
extern int cache_recheck;


/* in authmisc.C */
extern str denyfile;

class authclient {
  ptr<axprt_stream> x;
  ptr<asrv> authsrv;
  ptr<asrv> sfssrv;

  bool unixauth;
  uid_t uid;
  srp_server srpserv;
  str protected_privkey;
  str privkey;

  sfs_connectinfo ci;
  bool authid_valid;
  sfs_hash authid;
  sfs_hashcharge charge;

  void dispatch (svccb *sbp);
  void dologin (svccb *sbp);
  void doregister (svccb *sbp);
  void doupdate (svccb *sbp);
  void srp_getparms (svccb *sbp);
  void srpinit (svccb *sbp);
  void dosrp (svccb *sbp);
  void srpgetsesskey (sfs_hash *ksc, sfs_hash *kcs);
  void dofetch (svccb *sbp);
public:
  explicit authclient (ptr<axprt_stream> x, const authunix_parms *aup = NULL);
};

bool unixlookup (authentry *, sfs_unixcred *);
bool validshell (char *);
bool indenyfile (str username);

#endif _AUTHSERV_H_
