/* $Id: malloc.C,v 1.7 2000/04/25 02:07:58 dm Exp $ */

#include "amisc.h"

/* The xmalloc handler will have no effect when dmalloc is used, but
 * we leave it in for compatibility. */
static void
default_xmalloc_handler (int size)
{
  const char msg[] = "malloc failed\n";
  write (errfd, msg, sizeof (msg) - 1);
  abort ();
}
void (*xmalloc_handler) (int) = default_xmalloc_handler;

#ifdef DMALLOC

#undef new
dmalloc_t dmalloc;

void *
operator new (size_t size, dmalloc_t, const char *file, int line)
{
  /* As per the C++ standard, allocating 0 bytes must not return NULL,
   * and must return a different pointer each time... */
  if (!size)
    size = 1;
  return _xmalloc_leap (file, line, size);
}

void *
operator new[] (size_t size, dmalloc_t, const char *file, int line)
{
  if (!size)
    size = 1;
  return _xmalloc_leap (file, line, size);
}

#else /* !DMALLOC */

void *
xmalloc (size_t size)
{
  void *p;
  if (!(p = malloc (size)))
    default_xmalloc_handler (size);
  return p;
}

void *
xrealloc (void *o, size_t size)
{
  void *p;
  if (!(p = realloc (o, size)))
    default_xmalloc_handler (size);
  return p;
}

char *
xstrdup (const char *s)
{
  char *d;
  d = (char *) xmalloc (strlen (s) + 1);
  strcpy (d, s);
  return d;
}

#endif /* !DMALLOC */

using std::bad_alloc;

void *
operator new (size_t size) throw (bad_alloc)
{
  if (!size)
    size = 1;
  return txmalloc (size);
}

void *
operator new[] (size_t size) throw (bad_alloc)
{
  if (!size)
    size = 1;
  return txmalloc (size);
}

void
operator delete (void *ptr)
{
  xfree (ptr);
}

void
operator delete[] (void *ptr)
{
  xfree (ptr);
}
