/***************************************************************************
                          kartei_kreditor.cpp  -  description
                             -------------------
    begin                : Sun Jul 9 2000
    version              : $Id: kartei_kreditor.cpp,v 1.8 2001/03/14 13:59:04 joerg_bemme Exp $
    copyright            : (C) 2000 by Jrg Bemm
    email                : info@bemme.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qmessagebox.h>

#include "kartei_kreditor.h"
#include "qdbtableviewsum.h"

Kartei_Kreditor::Kartei_Kreditor(QWidget *parent, const char *name,
															SQLQuerier *sql_ptr )
	: QWidget(parent,name)
{
	if (sql_ptr->conn != 0) {
		QBoxLayout *topLayout = new QVBoxLayout( this, 5 );

		dialog = new QDBMenuDialog( this, 0, sql_ptr, false,
			"select "
			"nummer,kurzname,briefanrede,name,name_2,adresse,adresse_2,postfach"
			",ort,plz,plz_postfach,telefon,fax,homepage"
			",bankverbindung,bankleitzahl,konto_nr,verkaeufercode,zahlungsbed_code"
			",kreditlimit,mwst_pflichtig,buchungsgruppe,lieferantengruppe,waehrungscode"
			",laendercode,bemerkung,lieferungscode,sprachcode"
			" from kreditor order by kurzname", "nummer",
									"kreditor", "Kreditor.kdevdlg" );

		table = dialog->dialog->table;

		// This should be made as a table in the database to change it online.
		dialog->dialog->Page1->Feldvorgabe[table->fNumber("lieferantengruppe")]->setStr( "Lieferant1" );
		dialog->dialog->Page1->Feldvorgabe[table->fNumber("buchungsgruppe")]->setStr( "VERB" );
		dialog->dialog->Page1->Feldvorgabe[table->fNumber("waehrungscode")]->setStr( "EUR" );
		dialog->dialog->Page1->Feldvorgabe[table->fNumber("sprachcode")]->setStr( "D" );
		dialog->dialog->Page1->Feldvorgabe[table->fNumber("laendercode")]->setStr( "D" );
		dialog->dialog->Page1->Feldvorgabe[table->fNumber("mwst_pflichtig")]->setStr( "t" );

		topLayout->addWidget( dialog, 5 );

		buchhaltung = new QPopupMenu( this );
		buchhaltung->insertItem( "Buchungen", this, SLOT(sBuchungen()) );
		buchhaltung->insertItem( "Offene Posten", this, SLOT(sOffenePosten()) );
		buchhaltung->insertItem( "Statistik", this, SLOT(sStatistik()) );
		dialog->menuBar->insertItem( "&Buchhaltung", buchhaltung );

		setMinimumSize( dialog->dialog->Page1->sizeHint() );
		setMinimumSize( width()+50, dialog->dialog->Page1->height()+100 );

		// if new was pressed, get a new customer number
		connect( dialog->dialog->Page1, SIGNAL(sigNew()), SLOT(getNewNo()) );
	} else {
		QMessageBox::critical( this, "QtTudo", "Keine Datenbankverbindung aktiv!" );
	}
}

Kartei_Kreditor::~Kartei_Kreditor(){
}

void Kartei_Kreditor::getNewNo()
{
	QString NoBO;
	QString nothing;

	sql.getLfdNr( "buchhaltungsdaten", &NoBO, "letz_kreditornr", 1);
	NoBO.setNum( NoBO.toLong()+1 );
	dialog->dialog->Page1->Feld[table->fNumber("nummer")]->setText( NoBO );
	dialog->dialog->Page1->Feld[table->fNumber("kurzname")]->setFocus();
}

void Kartei_Kreditor::sBuchungen()
{
	QString selectStr = "select * from kreditorenposten where kreditornr=";
	selectStr += table->getValue( table->pos, table->fNumber( "nummer" ) );
	selectStr += " order by datum,lfd_nr";

	SQLTable *table2 = new SQLTable( selectStr.ascii(), "lfd_nr" );

	// Test: If you want to see the query before.
	//QMessageBox::information( this, "Test: Posten", selectStr.ascii() );

	table2->execute();

	QDialog *Posten = new QDialog( this, 0, true );
	QDBTableViewSum *view = new QDBTableViewSum( Posten, 0, &sql, table2,
			"betrag,restbetrag,urspr_betrag_mw,restbetrag_mw,mw,db" );
	QBoxLayout *topLayout = new QVBoxLayout( Posten, 5 );
	topLayout->addWidget( view, 5 );

	QString sName = "QtTudo Kreditorenposten Kreditor-Nr. ";
	sName += table->getValue( table->pos, table->fNumber( "nummer" ) );
	Posten->setCaption( sName );
	Posten->exec();
}

void Kartei_Kreditor::sOffenePosten(){
	QMessageBox::information( this, "Test", "Offene Posten: Sorry, noch nicht fertig." );
}

void Kartei_Kreditor::sStatistik(){
	QMessageBox::information( this, "Test", "Statistik: Sorry, noch nicht fertig." );
}
