/***************************************************************************
                erfassung_allg_erfassung.cpp  -  description
                --------------------------------------------
    begin                : 19.04.2000
    version              : $Id: erfassung_allg_erfassung.cpp,v 1.16 2001/03/11 11:00:28 joerg_bemme Exp $
    copyright            : (C) 2000 by Jrg Bemm
    email                : <info@bemme.de> www.bemme.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <qmenubar.h>
#include <qstatusbar.h>
#include <qpopupmenu.h>
#include <qdialog.h>
#include <qmessagebox.h>

#include "erfassung_allg_erfassung.h"
#include "qdbtableselect.h"
#include "buchen.h"

Erfassung_Allg_Erfassung::Erfassung_Allg_Erfassung(
				QWidget *parent, const char *name,
				SQLQuerier *sql_ptr, SQLTable *table_ptr,
				const char *tableName )
	: QDBErfassung(parent,name,sql_ptr,table_ptr,tableName,false)
{
	sql = sql_ptr;
	table = table_ptr;

	// defaults
	Page1->Feldvorgabe[table->fNumber("kladdenname")]->append( "Standard" );
	Page1->Feldvorgabe[table->fNumber("spur")]->append( "ERF" );
	Page1->Feldvorgabe[table->fNumber("waehrungscode")]->append( "EUR" );
	Page1->Feldvorgabe[table->fNumber("kontoart")]->append( "Sachkonto" );

	// Special column headers
	Page1->colName[table->fNumber("kontoart")]->append( "Kontoart" );
	Page1->colSize[table->fNumber("kontoart")] = 65;
	Page1->colName[table->fNumber("kontonr")]->append( "Konto-Nr." );
	Page1->colName[table->fNumber("datum")]->append( "Datum" );
	Page1->colSize[table->fNumber("datum")] = 70;
	Page1->colName[table->fNumber("art")]->append( "Art" );
	Page1->colSize[table->fNumber("art")] = 70;
	Page1->colName[table->fNumber("mwst_code")]->append( "MwSt." );
	Page1->colName[table->fNumber("waehrungscode")]->append( "Whr." );
	Page1->colName[table->fNumber("gegenkonto")]->append( "Gegenk." );
	Page1->colName[table->fNumber("betrag")]->append( "Betrag" );
	Page1->colSize[table->fNumber("betrag")] = 70;
	Page1->colName[table->fNumber("mw")]->append( "MW-Betr." );
	Page1->colSize[table->fNumber("mw")] = 70;
	Page1->colName[table->fNumber("belegnr")]->append( "Beleg-Nr." );
	Page1->colSize[table->fNumber("belegnr")] = 75;
	Page1->colName[table->fNumber("text")]->append( "Text" );
	Page1->colSize[table->fNumber("text")] = 220;
	Page1->colName[table->fNumber("buch_gr")]->append( "Buch.-Gr." );
	Page1->colName[table->fNumber("belegdatum")]->append( "Beleg-Dat." );
	Page1->colSize[table->fNumber("belegdatum")] = 70;

	// Don't select the first 2 fields and activate colName's
	// and last field (spur), because not important for the user.
	for (int i = 2; i < table->getnFields()-1; i++ ) {
		Page1->makeVisible( i );
		Page1->addCol( i );
	}

	QPopupMenu *fenster = new QPopupMenu( this );
	fenster->insertItem( "Kladde &wechseln", this, SLOT(sKladdeWechselnClicked()) );

	menuBar()->insertItem( "&Fenster", fenster );
	menuBar()->insertItem( "&Buchen", this, SLOT(sBuchenClicked()) );

	// to get a unique number (lfd_nr) for the tuple
	connect( Page1, SIGNAL(newTuple() ), SLOT(getLfdNr()) );

	// calculate/set different fields
	connect( Page1, SIGNAL(tupleUpdated( const char * )),
		SLOT(setFields( const char * )) );

	setGeometry( x(), y(), 1000, height() );
}

Erfassung_Allg_Erfassung::~Erfassung_Allg_Erfassung()
{
}

void Erfassung_Allg_Erfassung::setFields( const char *field )
{
	QCString *db = new QCString();
	SQLTable *t = new SQLTable();

	// set field belegdatum
	if (strstr(field, "datum") != NULL) {
		if ( Page1->isInsMode() ) {
			Page1->copyText( "datum", "belegdatum" );
		} else {
			db->setStr( "UPDATE kassenkladdenzeile SET belegdatum = '" );
			db->append( table->getValue( table->pos, "datum" ) );
			db->append( "' WHERE " );
			table->GetPrimaryKey( db );

			t->sQuery = db->copy();
			if (t->execute() != SUCCESS_NO_RESULTS)
				QMessageBox::warning( this, "QtTudo", t->ErrorText );
			else
				Page1->update( false );
		}
	}
	// set field MW
	if (strstr(field, "betrag") != NULL) {
		if ( Page1->isInsMode() ) {
			Page1->copyText( "betrag", "MW" );
		} else {
			db->setStr( "UPDATE kassenkladdenzeile SET MW = '" );
			db->append( table->getValue( table->pos, "betrag" ) );
			db->append( "' WHERE " );
			table->GetPrimaryKey( db );

			t->sQuery = db->copy();
			if (t->execute() != SUCCESS_NO_RESULTS)
				QMessageBox::warning( this, "QtTudo", t->ErrorText );
			else
				Page1->update( false );
		}
	}
}

void Erfassung_Allg_Erfassung::getLfdNr()
{
	QString s, value;

	if (Page1->currentItem() != 0) {
		SQLTable *t = new SQLTable( "SELECT * FROM interne_daten" );
		t->execute();

		// read the next Lfd_nr
		Page1->Feldvorgabe[table->fNumber("lfd_nr")]->truncate(0);
		Page1->Feldvorgabe[table->fNumber("lfd_nr")]->append(
			t->getValue( 0, t->fNumber("kk_zeilen_nr")));

		// Only for testing
		//QMessageBox::information( 0, "QtTudo Test",
			//Page1->Feldvorgabe[table->fNumber("lfd_nr")]->copy() );

		// Setting the number for the next accounting.
		s = "UPDATE interne_daten SET kk_zeilen_nr = ";
		value = t->getValue( 0, t->fNumber("kk_zeilen_nr"));
		value.setNum( value.toLong() + 1 );
		s.append( value );
		t = new SQLTable( s.ascii() );
	  if ( t->execute() != SUCCESS_NO_RESULTS ) {
			QMessageBox::warning( 0, "QtTudo Interne Daten", t->ErrorText );
		}
	}
}

void Erfassung_Allg_Erfassung::sKladdeWechselnClicked()
{
	QString *vKladdenname = new QString();

	SQLTable *table2 = new SQLTable( "select * from kassenkladdenkopf", "name" );

	QDBTableSelect *selectKladdenname =
		new QDBTableSelect( this, "QtTudo: Kladde auswhlen",
												sql, table2, vKladdenname, "kassenkladdenkopf" );
	if (selectKladdenname->exec()) { // if ok pressed
		Page1->Feldvorgabe[0] = vKladdenname;
	}
}

void Erfassung_Allg_Erfassung::sBuchenClicked()
{
	Buchen buchen( sql, table );

	buchen.makeAccountErfassung();
	Page1->update();
}
