/*
 * Open Gatekeeper address utilities
 *
 * Copyright (c) Egoboo Ltd. 1999-2000
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is Open Gatekeeper
 *
 * The Initial Developer of the Original Code is Egoboo Ltd.
 *
 * $Log: AddrUtils.h,v $
 * Revision 1.4  2000/05/10 09:19:05  aunitt
 * Removed warning about debug information being truncated in Windows debug build.
 *
 * Revision 1.3  2000/04/21 13:47:49  aunitt
 * Removed bogus warnings in Microsoft STL headers.
 *
 * Revision 1.2  2000/04/12 13:29:49  aunitt
 * Added new convenience functions to convert to and from H225 Transport Addresses.
 *
 * Revision 1.1  2000/02/27 20:40:08  aunitt
 * Address utilies module
 *
 *
 *
 */

#ifndef _ADDR_UTILS_H
#define _ADDR_UTILS_H

#include <ptlib.h>
#include <ptlib/ipsock.h>
#include <h225.h>
#if (_MSC_VER >= 1200)
#pragma warning( disable : 4786 ) // Disable about debug information being truncated
#pragma warning( push, 3 )
#endif
#include <stdexcept>
#if (_MSC_VER >= 1200)  
#pragma warning( pop )
#endif

using namespace std;

namespace AddrUtils
{
    void GetIPAddress(       H225_TransportAddress_ipAddress &  IPAddr,
                       const H225_ArrayOf_TransportAddress &    Addresses
                     );
    // Task: given an array of transport address, returns the first IP address
    //       will throw an error if no IP address

    void GetIPAddress(       H225_TransportAddress &            IPAddr,
                       const H225_ArrayOf_TransportAddress &    Addresses
                     );
    // Task: given an array of transport address, returns the first IP address
    //       will throw an error if no IP address

	
	class IPAddrNotFoundError : public runtime_error
	{
		public:
			IPAddrNotFoundError(const string& what_arg): runtime_error(what_arg) {}
	};
	
	H225_TransportAddress ConvertToH225TransportAddr( const PIPSocket::Address & Addr,
	                                                        WORD                 Port
	                                                );
    // Task: to convert an IP address into an H225 transport address

    void ConvertToIPAddress( const H225_TransportAddress_ipAddress &   H225IP,
                                   PIPSocket::Address &                Addr,
                                   WORD &                              Port
                           );
    // Task: to convert an IP address in H225 format to PWLIB format
}


#endif // _ADDR_UTILS_H

