/*
 * $Id: netddp.h,v 1.1.1.1.2.1 2002/02/08 00:01:08 srittau Exp $
 *
 * Copyright (c) 1999 Adrian Sun (asun@zoology.washington.edu)
 * All Rights Reserved. See COPYRIGHT.
 *
 * this provides a generic interface to the ddp layer. with this, we
 * should be able to interact with any appletalk stack that allows
 * direct access to the ddp layer. right now, only os x server's ddp
 * layer and the generic socket based interfaces are understood.  
 */

#ifndef _ATALK_NETDDP_H
#define _ATALK_NETDDP_H 1

#include <sys/types.h>
#include <sys/cdefs.h>
#include <sys/socket.h>
#include <netatalk/at.h>

extern int netddp_open   __P((struct sockaddr_at *, struct sockaddr_at *));

#if !defined(NO_DDP) && defined(MACOSX_SERVER)
extern int netddp_sendto __P((int, void *, size_t, unsigned int, 
			   const struct sockaddr *, unsigned int));
extern int netddp_recvfrom __P((int, void *, int, unsigned int, 
			     struct sockaddr *, unsigned int *));
#define netddp_close(a)  ddp_close(a)
#else
#include <unistd.h>
#include <sys/types.h>

#define netddp_close(a)  close(a)
#define netddp_sendto    sendto
#define netddp_recvfrom  recvfrom
#endif

#endif /* netddp.h */

