#!/usr/bin/env ruby

require 'socket'
require 'ssl'
require 'getopts'
begin require 'verify_cb'; rescue LoadError; end

include SSL

getopts "v", "C:", "p:2000", "c:sample.crt", "k:sample.key"

p [ $OPT_p, $OPT_k, $OPT_c ]

ns = TCPServer.new($OPT_p)
loop do
  begin
    s = ns.accept
    STDERR.print "connect from #{s.peeraddr[3]}.\n"

    ssl = SSLSocket.new(s, $OPT_c, $OPT_k)
    ssl.ca_path = $OPT_C if $OPT_C && FileTest::directory?($OPT_C)
    ssl.ca_file = $OPT_C if $OPT_C && FileTest::file?($OPT_C)
    ssl.verify_mode = VERIFY_PEER|VERIFY_FAIL_IF_NO_PEER_CERT if $OPT_v
    ssl.verify_callback = VerifyCallbackProc if defined? VerifyCallbackProc
    STDERR.print "SSLSocket initialized.\n"

    ssl.accept
    STDERR.print "SSLSocket accepted.\n"
    STDERR.print ssl.peer_cert.inspect, "\n" if ssl.peer_cert
  rescue 
    ssl.close
    s.close
    print $!, "\n"
    next
  end

  Thread.start{
    while line = ssl.gets
      p line
    end
    STDERR.print "connection closed.\n"
    ssl.close
    s.close
  }
end
