/*
 * libpam-sfs - Pluggable Authentication Module for SFS
 * 
 * Copyright (C) 2000 Luca Filipozzi
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free 
 * Software Foundation; either version 2, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc., 59 
 * Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * 
 */

#include <nana.h>
#include <stdio.h>
#include <syslog.h>

#undef  L_DEFAULT_HANDLER
#define L_DEFAULT_HANDLER syslog
#undef  L_DEFAULT_PARAMS
#define L_DEFAULT_PARAMS  LOG_DEBUG

#define PAM_SM_SESSION
#include <security/pam_modules.h>

#include "handler.h"

PAM_EXTERN int
pam_sm_open_session (pam_handle_t *pamh, int flags, int argc, const char **argv)
{
    const char *service;
    const char *username;
    const char *password;
    handler     handler;
    int         rval;
    int        *lockfilefdp = new int;

    openlog("PAM_sfs", LOG_PID, LOG_AUTH);

    rval = pam_get_user(pamh, &username, NULL);
    if (rval != PAM_SUCCESS)
    {
        return rval;
    }

    rval = pam_get_item(pamh, PAM_SERVICE, (const void**)&service);
    if (rval != PAM_SUCCESS)
    {
        return rval;
    }

    rval =  handler.pam_sm_open_session(service, flags, argc, argv,
                                        username, lockfilefdp);
    if (rval != PAM_SUCCESS)
    {
        return rval;
    }

    rval = pam_set_data(pamh, "pam_sfs_lockfile", (void*)lockfilefdp, NULL);
    if (rval != PAM_SUCCESS)
    {
        return rval;
    }

    closelog();

    return rval;
}

PAM_EXTERN int
pam_sm_close_session(pam_handle_t *pamh, int flags, int argc, const char **argv)
{
    const char *service;
    const char *username;
    const char *password;
    handler     handler;
    int         rval;
    int        *lockfilefdp;

    openlog("PAM_sfs", LOG_PID, LOG_AUTH);

    rval = pam_get_user(pamh, &username, NULL);
    if (rval != PAM_SUCCESS)
    {
        return rval;
    }

    rval = pam_get_item(pamh, PAM_SERVICE, (const void**)&service);
    if (rval != PAM_SUCCESS)
    {
        return rval;
    }

    rval = pam_get_data(pamh, "pam_sfs_lockfile", (const void**)&lockfilefdp);
    if (rval != PAM_SUCCESS)
    {
        return rval;
    }

    rval=handler.pam_sm_close_session(service, flags, argc, argv,
                                      username, *lockfilefdp);

    closelog();

    return rval;
}

