/* Info dialogs */
/* $Id: info.c,v 1.6 2002/04/02 22:29:46 pasky Exp $ */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_LUA
#include <lua.h>
#include <lualib.h>
#endif
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include <links.h>

#include <bfu/align.h>
#include <bfu/bfu.h>
#include <dialogs/info.h>
#include <dialogs/refresh.h>
#include <config/default.h>
#include <document/cache.h>
#include <document/session.h>
#include <document/html/renderer.h>
#include <intl/language.h>
#include <lowlevel/sched.h>
#include <lowlevel/select.h>
#include <lowlevel/terminal.h>
#ifdef LEAK_DEBUG
#include <util/error.h>
#endif
#include <util/memlist.h>


void menu_about(struct terminal *term, void *d, struct session *ses)
{
	unsigned char *s = stracpy(_(TEXT(T_LINKS__LYNX_LIKE), term));
	
	add_to_strn(&s, "\n\n");
	add_to_strn(&s, _(TEXT(T_FEATURES), term));
	add_to_strn(&s, ":"
			" Default"
#ifdef HAVE_SSL
			" SSL"
#endif
#ifdef HAVE_LUA
			" Lua"
#endif
#ifdef IPV6
			" IPv6"
#endif
#ifdef BOOKMARKS
			" Bookmarks"
#endif
#ifdef COOKIES
			" Cookies"
#endif
#ifdef GLOBHIST
			" GlobHist"
#endif
	);
	msg_box(term, getml(s, NULL),
		TEXT(T_ABOUT), AL_CENTER,
		s,
		NULL, 1,
		TEXT(T_OK), NULL, B_ENTER | B_ESC);
}

/* TODO: This should be autogenerated. */
void menu_keys(struct terminal *term, void *d, struct session *ses)
{
	msg_box(term, NULL,
		TEXT(T_KEYS), AL_LEFT,
		TEXT(T_KEYS_DESC),
		NULL, 1,
		TEXT(T_OK), NULL, B_ENTER | B_ESC);
}

void menu_copying(struct terminal *term, void *d, struct session *ses)
{
	msg_box(term, NULL,
		TEXT(T_COPYING), AL_CENTER,
		TEXT(T_COPYING_DESC),
		NULL, 1,
		TEXT(T_OK), NULL, B_ENTER | B_ESC);
}


void res_inf(struct terminal *term, void *d, struct session *ses)
{
	unsigned char *a1, *a2, *a3, *a4, *a5, *a6, *a7, *a8, *a9, *a10, *a11, *a12, *a13, *a14, *a15, *a16;
	int l = 0;
	struct refresh *r;

	r = mem_alloc(sizeof(struct refresh));
	if (!r)	return;

	l = 0; a1 = init_str(); add_to_str(&a1, &l, ": ");
				add_num_to_str(&a1, &l, select_info(CI_FILES)); add_to_str(&a1, &l, " ");
	l = 0; a2 = init_str(); add_to_str(&a2, &l, ", ");
				add_num_to_str(&a2, &l, select_info(CI_TIMERS)); add_to_str(&a2, &l, " ");
	l = 0; a3 = init_str(); add_to_str(&a3, &l, ".\n");

	l = 0; a4 = init_str(); add_to_str(&a4, &l, ": ");
				add_num_to_str(&a4, &l, connect_info(CI_FILES)); add_to_str(&a4, &l, " ");
	l = 0; a5 = init_str(); add_to_str(&a5, &l, ", ");
				add_num_to_str(&a5, &l, connect_info(CI_CONNECTING)); add_to_str(&a5, &l, " ");
	l = 0; a6 = init_str(); add_to_str(&a6, &l, ", ");
				add_num_to_str(&a6, &l, connect_info(CI_TRANSFER)); add_to_str(&a6, &l, " ");
	l = 0; a7 = init_str(); add_to_str(&a7, &l, ", ");
				add_num_to_str(&a7, &l, connect_info(CI_KEEP)); add_to_str(&a7, &l, " ");
	l = 0; a8 = init_str(); add_to_str(&a8, &l, ".\n");

	l = 0; a9 = init_str(); add_to_str(&a9, &l, ": ");
				add_num_to_str(&a9, &l, cache_info(CI_BYTES)); add_to_str(&a9, &l, " ");
	l = 0; a10 =init_str(); add_to_str(&a10, &l, ", ");
				add_num_to_str(&a10, &l, cache_info(CI_FILES)); add_to_str(&a10, &l, " ");
	l = 0; a11 =init_str(); add_to_str(&a11, &l, ", ");
				add_num_to_str(&a11, &l, cache_info(CI_LOCKED)); add_to_str(&a11, &l, " ");
	l = 0; a12 =init_str(); add_to_str(&a12, &l, ", ");
				add_num_to_str(&a12, &l, cache_info(CI_LOADING)); add_to_str(&a12, &l, " ");
	l = 0; a13 =init_str(); add_to_str(&a13, &l, ".\n");

	l = 0; a14 =init_str(); add_to_str(&a14, &l, ": ");
				add_num_to_str(&a14, &l, formatted_info(CI_FILES)); add_to_str(&a14, &l, " ");
	l = 0; a15 =init_str(); add_to_str(&a15, &l, ", ");
				add_num_to_str(&a15, &l, formatted_info(CI_LOCKED)); add_to_str(&a15, &l, " ");
	l = 0; a16 =init_str(); add_to_str(&a16, &l, ".");

	msg_box(term, getml(a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12, a13, a14, a15, a16, NULL),
		TEXT(T_RESOURCES), AL_LEFT | AL_EXTD_TEXT,
		TEXT(T_RESOURCES), a1,
		TEXT(T_HANDLES), a2,
		TEXT(T_TIMERS), a3,
		TEXT(T_CONNECTIONS), a4,
		TEXT(T_cONNECTIONS), a5,
		TEXT(T_CONNECTING), a6,
		TEXT(T_tRANSFERRING), a7,
		TEXT(T_KEEPALIVE), a8,
		TEXT(T_MEMORY_CACHE), a9,
		TEXT(T_BYTES), a10,
		TEXT(T_FILES), a11,
		TEXT(T_LOCKED), a12,
		TEXT(T_LOADING), a13,
		TEXT(T_FORMATTED_DOCUMENT_CACHE), a14,
		TEXT(T_DOCUMENTS), a15,
		TEXT(T_LOCKED), a16, NULL,
		r, 1,
		TEXT(T_OK), NULL, B_ENTER | B_ESC);

	refresh_init(r, term, ses, d, res_inf);
}

void cache_inf(struct terminal *term, void *d, struct session *ses)
{
	unsigned char *a;
	int l = 0;
	struct refresh *r;
	struct cache_entry *ce, *cache;

	r = mem_alloc(sizeof(struct refresh));
	if (!r)	return;

	a = init_str();

	cache = (struct cache_entry *) cache_info(CI_LIST);
	add_to_str(&a, &l, ":");
	foreach(ce, *cache) {
		add_to_str(&a, &l, "\n");
		add_to_str(&a, &l, ce->url);
	}

	msg_box(term, getml(a, NULL),
		TEXT(T_CACHE_INFO), AL_LEFT | AL_EXTD_TEXT,
		TEXT(T_CACHE_CONTENT), a, NULL,
		r, 1,
		TEXT(T_OK), NULL, B_ENTER | B_ESC);

	refresh_init(r, term, ses, d, cache_inf);
}

#ifdef LEAK_DEBUG

#define MSG_BUF	2000
#define MSG_W	100

void memory_inf(struct terminal *term, void *d, struct session *ses)
{
	char message[MSG_BUF];
	char *p;
	struct refresh *r;

	r = mem_alloc(sizeof(struct refresh));
	if (!r) return;

	p = message;
	sprintf(p, "%ld %s", mem_amount, _(TEXT(T_MEMORY_ALLOCATED), term));
	p += strlen(p);

	sprintf(p, ".");
	p += strlen(p);

	p = stracpy(message);
	if (!p) {
		mem_free(r);
		return;
	}

	msg_box(term, getml(p, NULL),
		TEXT(T_MEMORY_INFO), AL_CENTER,
		p,
		r, 1,
		TEXT(T_OK), NULL, B_ENTER | B_ESC);

	refresh_init(r, term, ses, d, memory_inf);
}

#undef MSG_W
#undef MSG_BUF

#endif
