/*
integrit - file integrity verification system
Copyright (C) 2001 Ed Cashin

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
/* checkset.h - interface for checkset type, a set of rules about what
 *              runtime checks to perform
 *
 * this is a packed type instead of a struct.  a byte array seems most
 * convenient, since I want speed, compactness in memory, and portability.
 *
 * hopefully the macros here will make it stable.
 *
 * the data looks like this:
 *
 * ----------------------------------------------------------------------
 * |  n switches | boolean flags | switch 0 | switch 1 | ... | switch n |
 * ----------------------------------------------------------------------
 * */
#ifndef	ELC_CHECKSET_H
#define	ELC_CHECKSET_H

/* include	<limits.h> */
#define	CHECKSET_MAXLEN	UCHAR_MAX

#define	CHECKSET_SIZEOF(n)	((n)+2) /* number of bytes needed for a
					 * checkset with n switches */

#define	CHECKSET_SWITCHSTART(c)	((c)+2)	/* eval to pointer to switches */

/* ------------ macros for switches that inherit */
#define	CHECKSET_LEN(c)	((c)[0])	/* get the number of switches in c */

/* lookup checkset from c at zero-based index i */
#define	CHECKSET_SWITCH_AT(c,i)	((c)[(i)+2])

/* set checkset at index i to value v */
#define	CHECKSET_SET(c,i,v)	 do {		\
    (c)[(i)+2]	 = v;				\
} while (0)

/* ----------- booleans that don't inherit from directory to its subdirs */
#define	CHECKSET_IGNORE		(0x1)
#define	CHECKSET_NOCHILD	(0x2)
#define CHECKSET_SETBOOLEAN(c, b, v) do {	\
    if (v)					\
      (c)[1]	 |= b;				\
    else					\
      (c)[1]	 &= ~b;				\
} while (0)
#define	CHECKSET_SETIGNORE(c,v) CHECKSET_SETBOOLEAN(c,CHECKSET_IGNORE,v)
#define	CHECKSET_SETNOCHILD(c,v) CHECKSET_SETBOOLEAN(c,CHECKSET_NOCHILD,v)

#define	CHECKSET_GETIGNORE(c)	( (c)[1] & CHECKSET_IGNORE)
#define	CHECKSET_GETNOCHILD(c)	( (c)[1] & CHECKSET_NOCHILD)

typedef unsigned char	 *checkset; /* a checkset is a pointer to a sequence
				     * of unsigned char of length
				     * checkset[0] + 2 */

#endif
