#ifndef __htmlstreamh__
  #include "../htmlstream.h"
#endif

#ifndef __htmlh__
  #include "../html.h"
#endif

#ifndef __stringproch__
  #include "../stringproc.h"
#endif

#ifndef __pluginh__
  #include "../plugin.h"
#endif

#include <string>
#include <vector>
#include <cstdio>

class dsoDeutschMod :public Plugin{
public:
  dsoDeutschMod();
  virtual void Init();
private:
  static void DAYNAME(const HTML& Cur,string& data,const vector<string>& params);
  static void MONTHNAME(const HTML& Cur,string& data,const vector<string>& params);
  static void DAYSHORTNAME(const HTML& Cur,string& data,const vector<string>& params);
  static void MONTHSHORTNAME(const HTML& Cur,string& data,const vector<string>& params);
  static void DAYABBREV(const HTML& Cur,string& data,const vector<string>& params);
  static void MONTHABBREV(const HTML& Cur,string& data,const vector<string>& params);
};

static dsoDeutschMod initmodule;

static const string daynames[]={"Sonntag","Montag","Dienstag","Mittwoch",
  "Donnerstag","Freitag","Samstag"};
static const string monthnames[]={"Januar","Februar","M&auml;rz","April",
  "Mai","Juni","Juli","August","September","Oktober","November","Dezember"};
static const string dayshortnames[]={"Son","Mon","Die","Mit","Don","Fre",
  "Sam"};
static const string monthshortnames[]={"Jan","Feb","M&auml;r","Apr","Mai",
  "Jun","Jul","Aug","Sep","Okt","Nov","Dez"};
static const string dayabbrevs[]={"So","Mo","Di","Mi","Do","F","Sa"};
static const string monthabbrevs[]={"Jan","Feb","M&auml;r","Apr","Mai",
  "Jun","Jul","Aug","Sep","Okt","Nov","Dez"};

dsoDeutschMod::dsoDeutschMod() {
  RegisterPlugin(string("deutsch"),1);
}

void dsoDeutschMod::Init(){
  SetNamespace("DEUTSCH");
  RegisterFunction("DAYNAME",&DAYNAME);
  RegisterFunction("MONTHNAME",&MONTHNAME);
  RegisterFunction("DAYSHORTNAME",&DAYSHORTNAME);
  RegisterFunction("MONTHSHORTNAME",&MONTHSHORTNAME);
  RegisterFunction("DAYABBREV",&DAYABBREV);
  RegisterFunction("MONTHABBREV",&MONTHABBREV);
}

void dsoDeutschMod::DAYNAME(const HTML& cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(cur,"DAYNAME",e_ParamNone);
  data=daynames[atoi(data.c_str())%7];
}

void dsoDeutschMod::MONTHNAME(const HTML& cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(cur,"MONTHNAME",e_ParamNone);
  data=monthnames[(atoi(data.c_str())-1)%12];
}

void dsoDeutschMod::DAYSHORTNAME(const HTML& cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(cur,"DAYSHORTNAME",e_ParamNone);
  data=dayshortnames[atoi(data.c_str())%7];
}

void dsoDeutschMod::MONTHSHORTNAME(const HTML& cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(cur,"DAYABBREV",e_ParamNone);
  data=monthshortnames[(atoi(data.c_str())-1)%12];
}

void dsoDeutschMod::DAYABBREV(const HTML& cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(cur,"",e_ParamNone);
  data=dayabbrevs[atoi(data.c_str())%7];
}

void dsoDeutschMod::MONTHABBREV(const HTML& cur,string& data,const vector<string>& params){
  if(params.size()!=0) Error(cur,"",e_ParamNone);
  data=monthabbrevs[(atoi(data.c_str())-1)%12];
}
