#ifndef __errorh__
  #include "error.h"
#endif
#ifndef __htmlh__
  #include "html.h"
#endif
#include <iostream>
#include <stdio.h>

static map<int,string> g_errors;

void InitErrors(){
  g_errors[e_CloseNoDef]="</@DEF> without <@DEF>";
  g_errors[e_CloseNoIf]="</@IF> without <@IF>";
  g_errors[e_ElseNoClose]="<@ELSE> without </@IF>";
  g_errors[e_ElseNoIf]="<@ELSE> without <@IF>";
  g_errors[e_DefNoClose]="<@DEF> without </@DEF>";
  g_errors[e_IfNoClose]="<@IF> without </@IF>";

  g_errors[e_BadCompare]="COMPARE must be EQ, NE, LT, GT, LE, GE, EQINT, NEINT, LTINT, GTINT, LEINT, GEINT, IN or NI";
  g_errors[e_BadScope]="SCOPE must be LOCAL, PARENT or GLOBAL";
  g_errors[e_BadVarName]="Illegal variable name";
  g_errors[e_BadProcName]="Illegal procedure name";
  g_errors[e_BadFormat]="FORMAT must be one of FOLDED, OPEN or FLAT";

  g_errors[e_NoName]="NAME missing";
  g_errors[e_NoSrc]="SRC missing";
  g_errors[e_NoEntry]="ENTRY missing";
  g_errors[e_NoValue]="VALUE missing";
  g_errors[e_NoDataSrc]="<@NAV> must have either a DATA or SRC";

  g_errors[e_UndefVar]="Undefined variable";
  g_errors[e_UndefProc]="Undefined procedure";
  g_errors[e_UndefEntry]="Undefined ENTRY procedure";
  g_errors[e_UndefPregroup]="Undefined PREGROUP procedure";
  g_errors[e_UndefPostgroup]="Undefined POSTGROUP procedure";
  g_errors[e_UndefStringProc]="Undefined string process";

  g_errors[e_FileNotOpen]="Couldn't open file";
  g_errors[e_TooDeep]="Maximum recursion level exceeded";
  g_errors[e_RunOnVar]="Unterminated inline variable";
  g_errors[e_MissingColon]="Missing colon";
  g_errors[e_ExpectBrackets]="Expecting brackets";
  g_errors[e_ExpectCloseBracket]="Expecting close bracket";
  g_errors[e_UntermQuotes]="Unterminated quotes";
  g_errors[e_DataBadFormat]="Error in DATA format";
  g_errors[e_NavBadFormat]="Error in format of the navigation file";

  g_errors[e_ParamWrong]=" has the wrong number of parameters";
  g_errors[e_ParamNone]=" shouldn't have any parameters";
  g_errors[e_ParamOne]=" should have one parameter";
}

extern void doError(const string& message);
extern void doWarn(const string& message);
extern void doDebug(const string& message);

void Warn(const HTML& cur,const string& mess){
  char buf[80]; 
  sprintf(buf,"%i",cur.m_line);
  doWarn(cur.m_fname+":"+buf+": "+mess+" in \""+cur.Print()+"\"");
}

void Warn(const string& mess){
  doWarn(mess);
}

void Debug(const HTML& cur,const string& mess){
  char buf[80];
  sprintf(buf,"%i",cur.m_line);
  doDebug(cur.m_fname+":"+buf+": "+mess);
}

void Error(const HTML& cur,const string& mess){
  char buf[80]; 
  sprintf(buf,"%i",cur.m_line);
  doError(cur.m_fname+":"+buf+": "+mess+" in \""+cur.Print()+"\"");
}

void Error(const HTML& cur,ErrNum mess){
  Error(cur,g_errors[mess]);
}

void Error(const HTML& cur,ErrNum mess,const string& data){
  Error(cur,g_errors[mess]+" '"+data+"'");
}

void Error(const HTML& cur,const string& data,ErrNum mess){
  Error(cur,data+" "+g_errors[mess]);
}

void Error(const string& mess){
  doError(": "+mess);
}

void Error(ErrNum mess){
  Error(g_errors[mess]);
}
