# PropList.pm - Property list class definition for Gutenbook
# http://www.gutenbook.org/
# Copyright (C) 2000  Lee "Lefty" Burgess
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

package PGB::PropList;

use PGB;
use PGB::File;

use vars qw($VERSION @ISA @EXPORT @EXPORT_OK);

require Exporter;
require AutoLoader;

@ISA = qw(Exporter AutoLoader);
$VERSION = '0.01';

sub new {
  my ($class, $file) = @_;
  my $self = {};
  $self->{"filename"} = $file;
  bless($self, $class);
  $self->_initialize();
  return($self);
}

sub _initialize {
  my ($self) = @_;
  $self->{"filepath"} = "$config_dir" . $self->{"filename"};
  $self->{"plist_hash"} = undef;
}

sub destroy {
  my ($self) = @_;
  undef($self->{"filename"});
  undef($self->{"filepath"});
  undef($self->{"plist_hash"});
  undef($self);
  return;
}

sub filename {
  my ($self) = @_;
  return($self->{"filename"});
}

sub filepath {
  my ($self) = @_;
  return($self->{"filepath"});
}

sub proplist_hash {
  my ($self) = @_;
  if (defined($self->{"plist_hash"})) {
    return($self->{"plist_hash"});	
  }
  else {
    return(undef);
  }
}

sub read_plist {
  my ($self) = @_;
  my $array;
  
  if (! -f $self->{"filepath"}) {
    my @plist = ("\$VAR1 = undef;\n");
    file_save($self->{"filepath"}, \@plist);
  }
  
  $array = file_get($self->{"filepath"});
  
  eval("@{$array}");
  $self->{"plist_hash"} = $VAR1;
}

sub write_plist {
  my ($self, $hashref) = @_;
  my (@array, $plist);
  
  $self->{"plist_hash"} = $hashref;
  
  @array = Dumper($self->{"plist_hash"});
  
  file_save($self->{"filepath"}, \@array);
}

1;
