/*
 *  Copyright (C) 2001 Philip Langdale
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "galeon.h"
#include "history.h" 
#include "mozilla.h"

#include "nsCOMPtr.h"
#include "nsISupportsArray.h"
#include "nsIFactory.h"
#include "nsIServiceManager.h"
#include "nsXPComFactory.h"

#include "nsIGlobalHistory.h"
#include "nsIBrowserHistory.h"
#include "nsIRequestObserver.h"

/**
 * class GlobalHistory: 
 *
 */
class GlobalHistory: public nsIGlobalHistory,
	public nsIBrowserHistory
{
	public:
		GlobalHistory ();
  		virtual ~GlobalHistory();

		NS_DECL_ISUPPORTS
		NS_DECL_NSIGLOBALHISTORY
		NS_DECL_NSIBROWSERHISTORY
};

NS_IMPL_ADDREF(GlobalHistory)
NS_IMPL_RELEASE(GlobalHistory)
NS_INTERFACE_MAP_BEGIN(GlobalHistory)
  NS_INTERFACE_MAP_ENTRY(nsIGlobalHistory)
  NS_INTERFACE_MAP_ENTRY(nsIBrowserHistory)
NS_INTERFACE_MAP_END

GlobalHistory::GlobalHistory ()
{
	NS_INIT_REFCNT();
}

GlobalHistory::~GlobalHistory ()
{
}

/* void addPage (in string aURL); */
NS_IMETHODIMP GlobalHistory::AddPage (const char *aURL)
{
	history_visited (aURL);
	return NS_OK;
}

/* boolean isVisited (in string aURL); */
NS_IMETHODIMP GlobalHistory::IsVisited (const char *aURL, PRBool *_retval)
{
	*_retval = history_is_visited (aURL);
	return NS_OK;
}

/* void setPageTitle (in string aURL, in wstring aTitle); */
NS_IMETHODIMP GlobalHistory::SetPageTitle (const char *aURL, 
					   const PRUnichar *aTitle)
{
	gchar *title_locale;
	gchar *title_utf8;

	/* check for NULL title (it happens, strangely) */
	if (aTitle == NULL)
	{
		/* not sure what we should do, so... */
		return NS_OK;
	}

	/* attempt conversion */
	title_locale = mozilla_unicode_to_locale (aTitle);
	title_utf8 = mozilla_unicode_to_utf8 (aTitle);
	
	/* set page title */
	history_set_page_title (aURL, title_locale, title_utf8);

	/* NB: we don't free the strings since set_page_title
	 * will hold onto them -- this is just to save some 
	 * unnecessary g_strdup()ing -- Matt */

	/* done */
	return NS_OK;
}

/* void removePage (in string aURL); */
NS_IMETHODIMP GlobalHistory::RemovePage(const char *aURL)
{
	return NS_ERROR_NOT_IMPLEMENTED;
}

/* void removePagesFromHost (in string aHost, in boolean aEntireDomain); */
NS_IMETHODIMP GlobalHistory::RemovePagesFromHost(const char *aHost, 
						 PRBool aEntireDomain)
{
	return NS_ERROR_NOT_IMPLEMENTED;
}

/* void removeAllPages (); */
NS_IMETHODIMP GlobalHistory::RemoveAllPages()
{
	return NS_ERROR_NOT_IMPLEMENTED;
}

/* readonly attribute string lastPageVisited; */
NS_IMETHODIMP GlobalHistory::GetLastPageVisited(char **aLastPageVisited)
{
	return NS_ERROR_NOT_IMPLEMENTED;
}

NS_IMETHODIMP GlobalHistory::HidePage(const char *url)
{
	return NS_ERROR_NOT_IMPLEMENTED;

}

#if MOZILLA_VERSION > VERSION3(0,9,8)
/* readonly attribute PRUint32 count; */
NS_IMETHODIMP GlobalHistory::GetCount(PRUint32 *aCount)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
  
/* void startBatchUpdate (); */
NS_IMETHODIMP GlobalHistory::StartBatchUpdate()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
  
/* void endBatchUpdate (); */
NS_IMETHODIMP GlobalHistory::EndBatchUpdate()
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* void markPageAsTyped (in string url); */
NS_IMETHODIMP GlobalHistory::MarkPageAsTyped(const char *url)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}
#endif

NS_DEF_FACTORY (GlobalHistory, GlobalHistory);

nsresult NS_NewGlobalHistoryFactory(nsIFactory** aFactory)
{
	NS_ENSURE_ARG_POINTER(aFactory);
	*aFactory = nsnull;

	nsGlobalHistoryFactory *result = new nsGlobalHistoryFactory;
	if (result == NULL)
	{
		return NS_ERROR_OUT_OF_MEMORY;
	}
    
	NS_ADDREF(result);
	*aFactory = result;

	return NS_OK;
}
