/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * 
 *  Gabber
 *  Copyright (C) 1999-2001 Dave Smith & Julian Missig
 */

/*
 * URLInterface
 * Author Thomas "temas" Muldowney <temas@jabber.org>
 */

#include "URLInterface.hh"

#include "GabberUtility.hh"
#include "GabberApp.hh"
#include "GabberWidgets.hh"

#include <libgnome/gnome-i18n.h>

#include <gtk--/proxy.h>
#include <gnome--/href.h>

using namespace jabberoo;
using namespace GabberUtil;

// Init function to register view with MessageManager
void URLRecvView::init_view(MessageManager& mm)
{
     mm.register_view_type("jabber:x:oob", MessageManager::MessageViewInfo::vfExtension,
                           new_view_msg, new_view_jid, "glade-file.xpm", "#999966");
}
 
MessageView* URLRecvView::new_view_msg(const Message& m, ViewMap& vm)
{
     MessageView* mv = manage(new URLRecvView(m, vm));
     return mv;
}
 
MessageView* URLRecvView::new_view_jid(const string& jid, ViewMap& vm)
{
     MessageView* mv = manage(new URLRecvView(jid, vm));
     return mv;
}

URLRecvView::URLRecvView(const jabberoo::Message& m, ViewMap& vm) : 
    MessageView(m, vm), 
    BaseGabberDialog("URLRecv_dlg") 
{
     init(m.getFrom());

     render(m);
}

URLRecvView::URLRecvView(const string& jid, ViewMap& vm) : 
    MessageView(jid, vm), 
    BaseGabberDialog("URLRecv_dlg")
{
     init(jid);
}

void URLRecvView::init(string jid)
{
     _lblDesc = getWidget<Gtk::Label>("URLRecv_Desc_lbl");

     getButton("URLRecv_Close_btn")->clicked.connect(slot(this, &URLRecvView::on_Close_clicked));

     PrettyJID* pj = manage(new PrettyJID(jid, "", PrettyJID::dtNickRes));
     pj->show();
     getWidget<Gtk::HBox>("URLRecv_JIDInfo_hbox")->pack_start(*pj, true, true, 0);

     _thisWindow->set_title(_("Received Web Link from ") + fromUTF8(pj->get_nickname()) + _(" - Gabber"));
}

URLRecvView::~URLRecvView()
{
}

void URLRecvView::render(const jabberoo::Message& m)
{
    Gnome::HRef* _href = getWidget<Gnome::HRef>("URLRecv_href");
    Tag* x = m.getBaseTag().getTag("x", "jabber:x:oob");
    _href->set_label(x->getTaggedCDATA("url"));
    _href->set_url(x->getTaggedCDATA("url"));
    _lblDesc->set_text(x->getTaggedCDATA("desc"));
}

void URLRecvView::on_Close_clicked()
{
    close();
}
