/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * 
 *  Gabber
 *  Copyright (C) 1999-2001 Dave Smith & Julian Missig
 */

#include "RosterInterface.hh"

#include "GabberApp.hh"
#include "GabberUtility.hh"

#include <libgnome/gnome-i18n.h>

using namespace judo;
using namespace jabberoo;
using namespace GabberUtil;

// ---------------------------------------------------------
//
// Roster Export
//
// ---------------------------------------------------------

RosterExportDlg* RosterExportDlg::_Dialog = NULL;

RosterExportDlg::RosterExportDlg()
     : FileSelection(_("Export Jabber Roster - Gabber"))
{
     // Attach buttons
     get_ok_button()->clicked.connect(slot(this, &RosterExportDlg::on_ok_clicked));
     get_cancel_button()->clicked.connect(slot(this, &RosterExportDlg::on_cancel_clicked));

     // Set default filename
     set_filename("gabber.roster");

     show();
}

void RosterExportDlg::on_ok_clicked()
{
      string filename = get_filename();
     
      // Save the file
      ofstream file(filename.c_str());
      if (!file)
      {
	   Gnome::Dialog* d = manage(Gnome::Dialogs::warning(_("Unable to save file. Please try another name or location.")));
	   d->set_modal(true);
      }
      else
      {
	   // <jabber> root
	   Tag jabber("jabber");
	   jabber.putAttrib("xmlns", "jabber:client");
	   // iq set
	   Tag& iq = jabber.addTag("iq");
	   iq.putAttrib("type", "set");
	   // query of jabber:iq:roster namespace
	   Tag& query = iq.addTag("query");
	   query.putAttrib("xmlns", "jabber:iq:roster");
	   
	   // Run through every roster item
	   for(Roster::iterator i = G_App->getSession().roster().begin(); i != G_App->getSession().roster().end(); i++)
	   {
		// An item element for this user
		Tag& item = query.addTag("item");
		// Insert item specifics
		item.putAttrib("jid", i->getJID());
		if (!i->getNickname().empty())
		     item.putAttrib("name", i->getNickname());
		// Add all groups in this item
		for (Roster::Item::iterator it = i->begin(); it != i->end(); it++)
		     item.addTaggedCDATA("group", *it);
	   }

	   // Actually insert it all into a string
	   file << "<?xml version=\"1.0\"  encoding=\"UTF-8\"?>" << endl;
	   file << "<!--Exported Roster from Gabber-->" << endl;
	   file << endl;
	   file << jabber.getXML() << endl;

	   // Get rid of file selection dialog
	   hide();
	   destroy();
      }
}

void RosterExportDlg::on_cancel_clicked()
{
     // Get rid of file selection dialog
     hide();
     destroy();
}

RosterExportDlg::~RosterExportDlg()
{
     _Dialog = NULL;
}

void RosterExportDlg::execute()
{
     if (_Dialog == NULL)
	  _Dialog = manage(new RosterExportDlg());
}


// ---------------------------------------------------------
//
// Roster Import
//
// ---------------------------------------------------------

RosterImportDlg* RosterImportDlg::_Dialog = NULL;

RosterImportDlg::RosterImportDlg()
     : FileSelection(_("Import Jabber Roster - Gabber"))
{
     // Attach buttons
     get_ok_button()->clicked.connect(slot(this, &RosterImportDlg::on_ok_clicked));
     get_cancel_button()->clicked.connect(slot(this, &RosterImportDlg::on_cancel_clicked));

     // Set default filename
     set_filename("gabber.roster");

     show();
}

void RosterImportDlg::on_ok_clicked()
{
      string filename = get_filename();
     
      // Save the file
      ifstream file(filename.c_str());
      if (!file)
      {
	   Gnome::Dialog* d = manage(Gnome::Dialogs::warning(_("Unable to open file. Please try another name or location.")));
	   d->set_modal(true);
      }
      else
      {
//	   tempsession = new Session;

//	   Session.roster().evtRefresh.connect(slot(this, &RosterImportDlg::on_update_refresh));


	   // Get rid of file selection dialog
	   hide();
	   destroy();
      }
}

void RosterImportDlg::on_update_refresh()
{

}

void RosterImportDlg::on_cancel_clicked()
{
     // Get rid of file selection dialog
     hide();
     destroy();
}

RosterImportDlg::~RosterImportDlg()
{
     _Dialog = NULL;
}

void RosterImportDlg::execute()
{
     if (_Dialog == NULL)
	  _Dialog = manage(new RosterImportDlg());
}
