/********************************************************************************
 *   Jabberoo/Judo -- C++ Jabber Library                                        *
 *                                                                              *
 *   Copyright (C) 1999-2000 Dave Smith (dave@jabber.org)                       *
 *                                                                              *
 *   This library is free software; you can redistribute it and/or              *
 *   modify it under the terms of the GNU Lesser General Public                 *
 *   License as published by the Free Software Foundation; either               *
 *   version 2.1 of the License, or (at your option) any later version.         *
 *                                                                              *
 *   This library is distributed in the hope that it will be useful,            *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          *
 *   Lesser General Public License for more details.                            *
 *                                                                              *
 *   You should have received a copy of the GNU Lesser General Public           *
 *   License along with this library; if not, write to the Free Software        *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  *
 ********************************************************************************
 */

#include <jabberoo.hh>
using namespace jabberoo;

Packet::Packet(const string& name)
     : _base(name)
{}

Packet::Packet(const Tag& t)
     : _base(t)
{}

const string Packet::getFrom() const
{
     return _base.getAttrib("from");
}

const string Packet::getTo() const
{
     return _base.getAttrib("to");
}

const string Packet::getID() const
{
     return _base.getAttrib("id");
}

const string Packet::getError() const
{
     return string(_base.getTaggedCDATA("error"));
}

const int Packet::getErrorCode() const
{
     Tag* error = _base.getTag("error");
     if (error)
	  return atoi(error->getAttrib("code").c_str());
     else
	  return 0;
}

const string Packet::toXML() const
{
     return _base.getXML();
}

const Tag& Packet::getBaseTag() const
{
     return _base;
}

void Packet::setFrom(const string& from)
{
     _base.putAttrib("from", from);
}

void Packet::setTo(const string& to)
{
     _base.putAttrib("to", to);
}

void Packet::setID(const string& id)
{
     _base.putAttrib("id", id);
}

Tag& Packet::addX()
{
     return _base.addTag("x");
}

Tag& Packet::addX(const string& tnamespace)
{
     Tag& x = _base.addTag("x");
     x.putAttrib("xmlns", tnamespace);
     return x;
}

Tag* Packet::getX(const string& tnamespace) const
{
     return _base.getTag("x", tnamespace.c_str());
}

Tag& Packet::getBaseTag()
{
     return _base;
}
