/* hey emacs! -*- Mode: C++; c-file-style: "stroustrup"; indent-tabs-mode: nil -*- */
/*
 * Thread.h
 *
 * $Id: Thread.h,v 1.3 2000/12/27 16:59:27 rex Exp $
 *
 * Copyright (c) 2000 Benoit Joly <benoit@dhis.net>
 *
 * DDT comes with ABSOLUTELY NO WARRANTY and is licenced under the
 * GNU General Public License (version 2 or later). This license
 * can be retrieved from http://www.gnu.org/copyleft/gnu.html.
 *
 */

#ifndef THREAD_H
#define THREAD_H

#include <pthread.h>
#include "Mutex.h"

/**
 * This class is a wrapper for the pthreads. It implements the most used
 * methods of JAVA Thread class.
 */

class Thread;
class Thread
{

  public:

    /// Constructor
    Thread ();

    /// Constructor with arguments
    Thread (void *);

    /// Destructor
    virtual ~Thread ();

    /// This method will start the thread.
    void start (void);
    
    /**
     * This method will block the thread calling this method
     * until thread_id will end.
     */
    static void join (Thread* thread_id);
    
    /// This method terminate a thread
    void cancel ();
    
    /// This method detach the mentionned thread
    static void detach (Thread *thread_id);

    static void cleanUpDispatch (void *);    
    static void *dispatchStart(void *);

    /// This is the method where the thread will loop
    virtual void *run (void *) = 0;

    /// This method is automatically called when a thread terminate
    virtual void cleanUp () = 0;
    
    /// This method return if the thread is still running or not.
    bool isAlive (void);
    
    /**
     * This method force a the thread to sleep a number of second
     *   @param Number of second to sleep.
     */
    static void sleepInSecond (double);
    
  protected:
    /// Arguments to the thread.
    void *a_arguments;

    /// The system pthread_id.
    pthread_t a_thread;
    
    /// This methoid return the system pthread_id
    int getThreadID (void);
    
    /// This method set the state of the thread.
    void setIsAlive (bool);
    
    /// A variable to contain the state of the thread.
    bool a_isAlive;
    
    /// A mutex to prevent cancellation in a critical zone.
    Mutex a_protectCancel;
    
  private:
    
};

#endif
