#include "DBWorkerCtlMO.hh"
#include "DBThreadWorker.hh"


DBThreadWorker::DBThreadWorker(string name, int nthreads):_nthreads(0) {

  ACE_DEBUG((LM_NOTICE,"(%t, %T) Thread Worker %s created with %d threads.\n",name.c_str(),nthreads));

  _name = name;
  _open = true;
  this->open(nthreads);

}

DBThreadWorker::~DBThreadWorker() {

  ACE_DEBUG((LM_NOTICE,"(%t,%T)  DBThreadWorker: Worker %s destroyed. Queue: %d\n",_name.c_str(),getQueueSize()));  
  //this->thr_mgr()->cancel_task((ACE_Task_Base *)this);
  

}

void DBThreadWorker::open(int nthreads) {

  this->activate(THR_NEW_LWP | THR_JOINABLE, nthreads, 1);

}

void DBThreadWorker::shutdown() {

  int threadsToStop = _nthreads.value();
  _open = false;

  ACE_DEBUG((LM_NOTICE,"(%t %T) DBThreadWorker: Closing worker %s with %d threads.\n",_name.c_str(),threadsToStop));

  // Send as many NULL ACE_Method_Objects as threads, to stop them;
  for (int i=0;i<threadsToStop;i++)
    submit(new DBWorkerCtlMO());

  //  int nwaits = 0;
  while( _nthreads.value()>0 ) { 
    ACE_DEBUG((LM_NOTICE,"(%t,%T)  DBThreadWorker: Still %d threads to close in Worker %s.\n",_nthreads.value(),_name.c_str()));
    ACE_OS::sleep(ACE_Time_Value(1)); 
  } 

  //ACE_Task<ACE_MT_SYNCH>::close();

  ACE_DEBUG((LM_NOTICE,"(%t,%T)  DBThreadWorker: Worker %s closed. Queue: %d\n",_name.c_str(),getQueueSize()));

}


int DBThreadWorker::svc(void) {

  //_barrier.wait();

  ACE_DEBUG((LM_NOTICE,"Starting svc = %s \n",_name.c_str()));
  // Used when the worker is closed
  
  DBThreadWorkerGuard guard(_nthreads);

  while(1) {

    auto_ptr<ACE_Method_Object> mo (this->activation_queue_.dequeue());
    if (!mo.get() || (mo->call() == -1)) break;

  }
  
  ACE_DEBUG((LM_NOTICE,"Ending svc %s \n",_name.c_str()));
  return 0;

}


void DBThreadWorker::submit(ACE_Method_Object *t) {

  this->activation_queue_.enqueue(t);
  if (!_open)
    ACE_DEBUG((LM_WARNING,"(%t, %T) WARNING: Submitting work with Worker %s Closed!!!!!!!!!! \n",_name.c_str()));    


}


