//  
//  SelectFolder.h  -- functions for accessing imap mail folders
//    and retrieving information about imap messages
//  -- created 4/20/00  updated 4/20/00
//////////////////////////////////////////////


// Changes to make compile possible on Suns and BSD boxen thanks to Thomas Strmberg

#ifndef SELECTFOLDER_H
#define SELECTFOLDER_H
namespace std {};
using namespace std;

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <unistd.h>
#include <string>
#include <stdlib.h>
#include <ctype.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>
#include "basicNetwork.h"
#include "tcpUtilities.h"
#include "imap.h"
#include "Folder.h"
#include "errors.h"
#include "Althea.h"
#include "progressbar.h"
#include "tolower.h"

/*****************************
 * the main functions        *
 *****************************/

// main function for retrieving message headers
// as well as selecting a new folder.
// on exit, the folder parameter
// will contain the headers of all messages
// in the folder.
// the folder name must be set in the folder instance.
// the first parameter is the socket

int GetMessageHeaders(ACon *the_connection,Folder &folder);

// will select a folder and return the number of messages 
// as well as how the folder was opened (read-only
// read-write, etc.

int SelectFolder(ACon *the_connection, const string &foldername, int &numMessages, 
                 string &folderOpenStatus);

// returns a string consisting of the flags
// sent to us from the server regarding the
// message passed as the parameter
string GetFlags(ACon *the_connection, int msgNumber, int &errnum);

// when passed the sock and the folder, will query server
// and get any messages that have been added to the folder
// since the last update
int GetNewMail(ACon *the_connection, Folder &folder);


/*****************************
 * some utility functions    *
 *****************************/

// erases all text from the string prior to the 
// first instance of needle.
// haystack is unchanged if needle is now found 
void EraseBefore(string &haystack, const string &needle);

// returns the text between the given keyword and
// the newline.
void GetLineText(const string &haystack, const string &keyword, string &value);

// will get the header information for just the
// message indicated.
int GetMessageHeader(AConPtr the_connection, int msgNumber, string &to,
		     string &cc,
                     string &from, string &subject, string &uid, 
		     string &date);

// reads til end of line, but also returns an error depending
// on what other information it came accross.
// errnum 0: all is fine
// errnum 911: receive BYE message from server -- we have lost our 
//            connection.
string readTilEOL(AConPtr the_connection, int &errnum);

#endif
