/***************************************************************************/
/* 		This code is part of WWW graber called pavuk		   */
/*		Copyright (c) 1997,1998,1999 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#ifndef _gaccel_h_
#define _gaccel_h_

#include <gtk/gtk.h>

#ifdef _GTK_FEATURES_1_2
typedef struct {
	GtkWidget	*widget;
	gchar		*sigid;
	gchar		*name;
	GdkModifierType	modifier_mask;
	guint		accelerator_key;
	GtkAccelGroup	*accel_group;
} gaccel;


extern void	gaccel_window_activate(GtkAccelGroup *, GtkWidget *);
extern void	gaccel_init(void);
extern gaccel	*gaccel_parse_str(guchar *);
extern guchar	*gaccel_to_str(gaccel *);
extern void	gaccel_bind_widget(gchar *, gchar *, GtkWidget *, GtkAccelGroup *);
extern gaccel	*gaccel_find_by_name(gchar *);
extern void	gaccel_add(gaccel *);
extern void	gaccel_load_keys();
extern void	gaccel_save_keys();
#else
#define gaccel_window_activate(p1,p2)
#define gaccel int
#define gaccel_init()
#define gaccel_parse_str(p1)
#define gaccel_to_str(p1)
#define gaccel_bind_widget(p1,p2,p3,p4)
#define gaccel_find_by_name(p1)
#define gaccel_add(p1)
#define gaccel_load_keys()
#define gaccel_save_keys()
#endif

extern GSList	*gaccel_list;

#endif

