/***************************************************************************/
/* 	This code is part of X-toolkit widget library called Nws 	   */
/*	Copyright (c) 1997,1998,1999 Ondrejicka Stefan			   */
/*	(ondrej@idata.sk)						   */
/*	Distributed under GPL 2 or later				   */
/***************************************************************************/

#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#include <Nws/utils.h>
#include <Nws/BBoxP.h>
#include <Nws/Init.h>
#include <Nws/misc.h>


#define offset(field) XtOffsetOf(BBoxRec,bBox.field)

static XtResource resources [] = {
	{
	 XtNbox_intensity ,
	 XtCBox_intensity ,
	 XtRInt ,
	 sizeof(int) ,
	 XtOffsetOf(BBoxRec,baseComp.box_intensity) ,
	 XtRImmediate ,
	 (XtPointer) 10000,
	},
	{
	 XtNbreak_width ,
	 XtCBreak_width ,
	 XtRInt ,
	 sizeof(int) ,
	 XtOffsetOf(BBoxRec,bBox.break_width) ,
	 XtRImmediate ,
	 (XtPointer) 3
	},
	{
	 XtNbreak_xposition ,
	 XtCBreak_xposition ,
	 XtRInt ,
	 sizeof(int) ,
	 XtOffsetOf(BBoxRec,bBox.break_xposition) ,
	 XtRImmediate ,
	 (XtPointer) 3
	},
	{
	 XtNborderWidth ,
	 XtCBorderWidth ,
	 XtRDimension ,
	 sizeof(Dimension) ,
	 XtOffsetOf(BBoxRec,core.border_width) ,
	 XtRImmediate ,
	 (XtPointer) 0
	},
};

#undef offset

static Widget Find_Managed ();

static void Initialize ();
static void ClassInitialize ();
static void Redisplay ();
static void Resize ();
static Boolean SetValues ();
static void ChangeManaged ();
static void Destroy ();
static XtGeometryResult QueryGeometry();

BBoxClassRec bBoxClassRec = {
/* core */
{
    /* superclass            */ (WidgetClass) &baseCompClassRec,
    /* class_name            */ "BBox",
    /* widget_size           */ sizeof(BBoxRec),
    /* class_initialize      */ ClassInitialize,
    /* class_part_initialize */ NULL,
    /* class_inited          */ FALSE,
    /* initialize            */ (XtInitProc) Initialize,
    /* initialize_hook       */ NULL,
    /* realize               */ XtInheritRealize,
    /* actions               */ NULL,
    /* num_actions           */ 0,
    /* resources             */ resources,
    /* num_resources         */ XtNumber(resources),
    /* xrm_class             */ NULLQUARK,
    /* compress_motion       */ False,
    /* compress_exposure     */ False,
    /* compress_enterleave   */ False,
    /* visible_interest      */ FALSE,
    /* destroy               */ Destroy,
    /* resize                */ Resize,
    /* expose                */ Redisplay,
    /* set_values            */ SetValues,
    /* set_values_hook       */ NULL,
    /* set_values_almost     */ XtInheritSetValuesAlmost,
    /* get_values_hook       */ NULL,
    /* accept_focus          */ XtInheritAcceptFocus,
    /* version               */ XtVersion,
    /* callback_private      */ NULL,
    /* tm_table              */ NULL,
    /* query_geometry        */ QueryGeometry,
    /* display_accelerator   */ XtInheritDisplayAccelerator,
    /* extension             */ NULL
   },
   {
/* composite */
    /* geometry_manager	     */ XtInheritGeometryManager,
    /* change_managed	     */ ChangeManaged,
    /* insert_child	     */ XtInheritInsertChild,
    /* delete_child	     */ XtInheritDeleteChild,
    /* extension	     */ NULL 
   },
/* baseComp */
   {
    /* get_internal_dimension  */ XtInheritGetInternalDimension,
    /* set_internal_dimension  */ XtInheritSetInternalDimension,
    /* traverse		       */ XtInheritTraverse,
    /* traverseTo	       */ XtInheritTraverseTo,
    /* traverseOut	       */ XtInheritTraverseOut,
    /* traverseInside          */ XtInheritTraverseInside,
    /* highlightBorder         */ XtInheritHighlightBorder,
    /* unhighlightBorder       */ XtInheritUnhighlightBorder,
   },
   {
/* bBox */
   /* empty		     */	0
   },
};

WidgetClass bBoxWidgetClass = (WidgetClass) & bBoxClassRec; 

static void ClassInitialize()
{
	_InitializeWidgetSet();
}

static void Initialize(req_widget,w,args,num_args)
Widget req_widget;
Widget w;
ArgList args;
Cardinal *num_args;
{
	BBoxWidget cw = (BBoxWidget) w;
	XtGCMask mask;
	XGCValues values;
	Display *dpy = XtDisplay(w);

	values.background = cw->core.background_pixel;
	values.foreground = cw->baseComp.foreground;
	mask =  GCBackground | GCForeground;
	cw->bBox.bgc = XCreateGC(dpy,RootWindowOfScreen(XtScreen(w)),
			mask, &values);
}

static void Destroy(w)
Widget w;
{
	BBoxWidget cw = (BBoxWidget) w;

	XtDestroyGC(cw->bBox.bgc);
}

static void Resize(w)
Widget w;
{
	BBoxWidget cw = (BBoxWidget) w;
	Widget managed_child = Find_Managed(cw);
	Dimension width , height;
	Position x,y;

	((BBoxWidgetClass)w->core.widget_class)->baseComp_class.
		get_internal_dimension(w , &x , &y , &width , &height);

	if (managed_child)
		XtConfigureWidget(managed_child , x , y , width , height , 0);

}

static void Redisplay(w , event , region)
Widget w;
XEvent *event;
Region region;
{
	XPoint poly[7];
	BBoxWidget cw = (BBoxWidget) w;
	Display *dpy = XtDisplay(w);
	int x;

	if (cw->bBox.break_xposition < cw->baseComp.box_width)
		x = cw->baseComp.box_width;
	else x = cw->bBox.break_xposition;

	poly[0].x = 0;				poly[0].y = 0;
	poly[1].x = x;				poly[1].y = 0;
	poly[2].x = x;			 	poly[2].y = cw->baseComp.box_width;;
	poly[3].x = cw->baseComp.box_width;	poly[3].y = cw->baseComp.box_width;
	poly[4].x = cw->baseComp.box_width;	poly[4].y = cw->core.height - cw->baseComp.box_width;
	poly[5].x = 0;				poly[5].y = cw->core.height; 

	XSetForeground(dpy,cw->bBox.bgc,cw->baseComp.light);

	XFillPolygon(dpy,XtWindow(w),cw->bBox.bgc,poly,6,Convex,CoordModeOrigin);

	poly[0].x = cw->bBox.break_width + x;	poly[0].y = 0;
	poly[1].x = cw->bBox.break_width + x;	poly[1].y = cw->baseComp.box_width;
	poly[2].x = cw->core.width;		poly[2].y = cw->baseComp.box_width;
	poly[3].x = cw->core.width;		poly[3].y = 0;

	XFillPolygon(dpy,XtWindow(w),cw->bBox.bgc,poly,4,Convex,CoordModeOrigin);

	poly[0].x = cw->core.width;		poly[0].y = 0;
	poly[1].x = cw->core.width;		poly[1].y = cw->core.height;
	poly[2].x = 0;				poly[2].y = cw->core.height;
	poly[3].x = cw->baseComp.box_width;	poly[3].y = cw->core.height - cw->baseComp.box_width;
	poly[4].x = cw->core.width - cw->baseComp.box_width; poly[4].y = cw->core.height - cw->baseComp.box_width;
	poly[5].x = cw->core.width - cw->baseComp.box_width; poly[5].y = cw->baseComp.box_width;

	XSetForeground(XtDisplay(w),cw->bBox.bgc,cw->baseComp.dark);

	XFillPolygon(dpy,XtWindow(w),cw->bBox.bgc,poly,6,Convex,CoordModeOrigin);

}

#define WidgetValuesDiffer(w1,w2,component) (w1 -> bBox.component != \
                                             w2 -> bBox.component)
 

static Boolean SetValues(current, request, new_widget, args, num_args)
Widget current;
Widget request;
Widget new_widget;
ArgList args;
Cardinal *num_args; 
{
	Boolean redraw = False;
	BBoxWidget cw = (BBoxWidget) current;
	BBoxWidget nw = (BBoxWidget) new_widget;

	if (WidgetValuesDiffer(cw ,nw ,break_width) ||
		WidgetValuesDiffer(cw ,nw ,break_xposition)) redraw =True;

	return redraw;
}
#undef  WidgetValuesDiffer

static void ChangeManaged (w)
Widget w;
{
	BBoxWidget cw = (BBoxWidget) w;
	Widget managed_child = Find_Managed(cw);
	Dimension width , height;
	Position x,y;

	((BBoxWidgetClass)w->core.widget_class)->baseComp_class.
		get_internal_dimension(w , &x , &y , &width , &height);

	if (managed_child)
		XtConfigureWidget(managed_child , x , y , width , height , 0);
}

#define ForAllChildren(cw, child) \
        for ( (child) = (cw)->composite.children ; \
                (child) < ((cw)->composite.children + \
                (cw)->composite.num_children ) ; \
                (child)++ )

static XtGeometryResult QueryGeometry(w, intended , preferred)
Widget w;
XtWidgetGeometry *intended;
XtWidgetGeometry *preferred;
{
        BBoxWidget cw = (BBoxWidget) w;
	XtWidgetGeometry pref_geom , inten_geom;
	Widget *child;
	Dimension width , height;
	Position x,y;
	int maxheight = 0;
	int maxwidth = 0;
	
	bBoxClassRec.baseComp_class.get_internal_dimension(w , &x , &y , &width,&height);

	preferred->request_mode = CWWidth | CWHeight;
	preferred->width = cw->core.width - width;
	preferred->height = cw->core.height - height;
	
	inten_geom.request_mode = CWWidth | CWHeight;
	inten_geom.width = width;
	inten_geom.height = height;

	ForAllChildren(cw , child)
	{
		XtQueryGeometry(*child , &inten_geom , &pref_geom);		

		maxheight = MAX(maxheight , pref_geom.height);
		maxwidth = MAX(maxwidth , pref_geom.width);
	}

	preferred->height += maxheight;
	preferred->width += maxwidth;

	if (((intended->request_mode & (CWWidth | CWHeight))
		== (CWWidth | CWHeight)) &&
		intended->width == preferred->width &&
		intended->height == preferred->height)
		return XtGeometryYes;

	else if (preferred->width == cw->core.width &&
		preferred->height == cw->core.height)
		return XtGeometryNo;

	else return XtGeometryAlmost;
}
		
static Widget Find_Managed (w)
BBoxWidget w;
{
	Widget *children;
	int i;

	for (i = 0, children = w->composite.children;
		i < w->composite.num_children; i++, children++)
			if (XtIsManaged(*children)) return *children;

	return (Widget) NULL;
}

